/*
 * Decompiled with CFR 0.152.
 */
package at.nightfirec.roguesden;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.runelite.api.coords.WorldPoint;

class Obstacles {
    static final Map<WorldPoint, Obstacle> TILE_MAP = new HashMap<WorldPoint, Obstacle>();
    static final Obstacle[] OBSTACLES = new Obstacle[]{new Obstacle(3050, 4997, "Enter"), new Obstacle(3049, 4997, 7251), new Obstacle(3039, 4999, "Stand"), new Obstacle(3029, 5003, "Run"), new Obstacle(3024, 5001, "Open", 7255), new Obstacle(3011, 5005, "Run"), new Obstacle(3004, 5003, "Run"), new Obstacle(2994, 5004, "Climb"), new Obstacle(2993, 5004, 7240), new Obstacle(2994, 5005, "Climb"), new Obstacle(2993, 5005, 7240), new Obstacle(2969, 5016, "Stand"), new Obstacle(2969, 5017, "Stand"), new Obstacle(2969, 5018, "Stand"), new Obstacle(2969, 5019, "Stand"), new Obstacle(2958, 5031, "Cross"), new Obstacle(2962, 5050, "Stand"), new Obstacle(2963, 5056, "Run"), new Obstacle(2957, 5068, "Enter"), new Obstacle(2957, 5069, 7219), new Obstacle(2955, 5094, "Enter"), new Obstacle(2955, 5095, 7219), new Obstacle(2963, 5105, "Stand"), new Obstacle(2972, 5098, "Enter"), new Obstacle(2972, 5097, 7219), new Obstacle(2972, 5094, "Open"), new Obstacle(2972, 5094, 7255), new Obstacle(2982, 5087, "Climb"), new Obstacle(2983, 5087, 7240), new Obstacle(2982, 5090, "Climb"), new Obstacle(2983, 5090, 7240), new Obstacle(2993, 5088, "Search"), new Obstacle(2993, 5087, 7249), new Obstacle(2997, 5088, "Run"), new Obstacle(2993, 5089, "Search"), new Obstacle(2993, 5089, 7249), new Obstacle(2997, 5089, "Run"), new Obstacle(3006, 5088, "Run"), new Obstacle(3018, 5080, "Take"), new Obstacle(3023, 5082, "Open", 7234), new Obstacle(3030, 5079, 7255), new Obstacle(3032, 5078, 7255), new Obstacle(3036, 5076, 7255), new Obstacle(3039, 5079, 7255), new Obstacle(3042, 5076, 7255), new Obstacle(3044, 5069, 7255), new Obstacle(3041, 5068, 7255), new Obstacle(3040, 5070, 7255), new Obstacle(3038, 5069, 7255), new Obstacle(3028, 5033, "Stand"), new Obstacle(3024, 5033, "Run"), new Obstacle(3028, 5034, "Stand"), new Obstacle(3024, 5034, "Run"), new Obstacle(3015, 5033, "Open", 7255), new Obstacle(3010, 5033, "Run/Open", 7255), new Obstacle(3000, 5034, "Run"), new Obstacle(2992, 5045, "Stand"), new Obstacle(2992, 5053, "Run"), new Obstacle(2992, 5067, "Stand"), new Obstacle(2992, 5075, "Run"), new Obstacle(3009, 5063, "Take"), new Obstacle(3028, 5056, "Run"), new Obstacle(3028, 5047, "Walk"), new Obstacle(3018, 5047, "Crack", 7237), new Obstacle(2967, 5061, "80 Thieving", 7246), new Obstacle(2967, 5066, "80 Thieving", 7246), new Obstacle(2974, 5061, "Enter"), new Obstacle(2974, 5060, 7251), new Obstacle(2989, 5057, "Open", 7255), new Obstacle(2989, 5058, "Open", 7255), new AvoidObstacle(2977, 5090), new AvoidObstacle(2978, 5090), new AvoidObstacle(2979, 5090), new AvoidObstacle(2977, 5089), new AvoidObstacle(2978, 5089), new AvoidObstacle(2979, 5089), new AvoidObstacle(2977, 5088), new AvoidObstacle(2978, 5088), new AvoidObstacle(2979, 5088), new TipObstacle(3014, 5063, "Stun NPC"), new TipObstacle(2992, 5057, "Continue North")};

    Obstacles() {
    }

    private static class TipObstacle
    extends Obstacle {
        private final Color tileColor = Color.ORANGE;

        private TipObstacle(int x, int y, String hint) {
            super(x, y, hint);
        }

        @Override
        public Color getTileColor() {
            return this.tileColor;
        }
    }

    private static class AvoidObstacle
    extends Obstacle {
        private final Color tileColor = Color.RED;

        private AvoidObstacle(int x, int y) {
            super(x, y, "AVOID");
        }

        @Override
        public Color getTileColor() {
            return this.tileColor;
        }
    }

    static class Obstacle {
        private final WorldPoint tile;
        private final String hint;
        private final int objectId;
        private final Color tileColor = Color.GREEN;

        private Obstacle(int x, int y, String hint) {
            this(x, y, hint, -1);
        }

        private Obstacle(int x, int y, int objectId) {
            this(x, y, "", objectId);
        }

        private Obstacle(int x, int y, String hint, int objectId) {
            this.tile = new WorldPoint(x, y, 1);
            this.hint = hint;
            this.objectId = objectId;
            if (objectId != -1) {
                TILE_MAP.put(new WorldPoint(x, y, 1), this);
            }
        }

        public WorldPoint getTile() {
            return this.tile;
        }

        public String getHint() {
            return this.hint;
        }

        public int getObjectId() {
            return this.objectId;
        }

        public Color getTileColor() {
            return this.tileColor;
        }
    }
}

