/*
 * Decompiled with CFR 0.152.
 */
package com.github.m0bilebtw;

import com.github.m0bilebtw.CEngineerCompletedConfig;
import com.github.m0bilebtw.Sound;
import com.github.m0bilebtw.SoundFileManager;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SoundEngine {
    private static final Logger log = LoggerFactory.getLogger(SoundEngine.class);
    @Inject
    private CEngineerCompletedConfig config;
    private static final long CLIP_MTIME_UNLOADED = -2L;
    private long lastClipMTime = -2L;
    private Clip clip = null;

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean loadClip(Sound sound) {
        try (BufferedInputStream stream = new BufferedInputStream(SoundFileManager.getSoundStream(sound));){
            boolean bl;
            block13: {
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(stream);
                try {
                    this.clip.open(audioInputStream);
                    bl = true;
                    if (audioInputStream == null) break block13;
                }
                catch (Throwable throwable) {
                    if (audioInputStream != null) {
                        try {
                            audioInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                audioInputStream.close();
            }
            return bl;
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            log.warn("Failed to load C Engineer sound " + sound, (Throwable)e);
            return false;
        }
    }

    public void playClip(Sound sound, Executor executor) {
        executor.execute(() -> this.playClip(sound));
    }

    public void playClip(Sound sound, ScheduledExecutorService executor, Duration initialDelay) {
        executor.schedule(() -> this.playClip(sound), initialDelay.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void playClip(Sound sound) {
        long currentMTime = System.currentTimeMillis();
        if (this.clip == null || currentMTime != this.lastClipMTime || !this.clip.isOpen()) {
            if (this.clip != null && this.clip.isOpen()) {
                this.clip.close();
            }
            try {
                this.clip = AudioSystem.getClip();
            }
            catch (LineUnavailableException e) {
                this.lastClipMTime = -2L;
                log.warn("Failed to get clip for C Engineer sound " + sound, (Throwable)e);
                return;
            }
            this.lastClipMTime = currentMTime;
            if (!this.loadClip(sound)) {
                return;
            }
        }
        FloatControl volume = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        float gain = 20.0f * (float)Math.log10((float)this.config.announcementVolume() / 100.0f);
        gain = Math.min(gain, volume.getMaximum());
        gain = Math.max(gain, volume.getMinimum());
        volume.setValue(gain);
        this.clip.loop(0);
    }

    public void close() {
        if (this.clip != null && this.clip.isOpen()) {
            this.clip.close();
        }
    }
}

