/*
 * Decompiled with CFR 0.152.
 */
package com.github.m0bilebtw;

import com.github.m0bilebtw.CEngineerCompletedConfig;
import com.github.m0bilebtw.Sound;
import com.github.m0bilebtw.SoundEngine;
import com.github.m0bilebtw.SoundFileManager;
import com.google.inject.Provides;
import java.time.Duration;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.GameState;
import net.runelite.api.GrandExchangeOffer;
import net.runelite.api.GrandExchangeOfferState;
import net.runelite.api.Player;
import net.runelite.api.Projectile;
import net.runelite.api.Skill;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GrandExchangeOfferChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.PlayerDespawned;
import net.runelite.api.events.PlayerSpawned;
import net.runelite.api.events.ProjectileMoved;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="C Engineer: Completed", description="C Engineer announces when you complete an achievement", tags={"c engineer", "stats", "levels", "quests", "diary", "announce"})
public class CEngineerCompletedPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CEngineerCompletedPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private SoundEngine soundEngine;
    @Inject
    private CEngineerCompletedConfig config;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private OkHttpClient okHttpClient;
    private final int[] varbitsAchievementDiaries = new int[]{4458, 4459, 4460, 4461, 4483, 4484, 4485, 4486, 4462, 4463, 4464, 4465, 4475, 4476, 4477, 4478, 3578, 3599, 3611, 4566, 7925, 7926, 7927, 7928, 4495, 4496, 4497, 4498, 4487, 4488, 4489, 4490, 4479, 4480, 4481, 4482, 4471, 4472, 4473, 4474, 4466, 4467, 4468, 4469};
    private static final String ZULRAH = "Zulrah";
    private static final String C_ENGINEER = "C Engineer";
    private static final String SKILL_SPECS = "Skill Specs";
    private static final Pattern KILLCOUNT_PATTERN = Pattern.compile("Your (?:completion count for |subdued |completed )?(.+?) (?:(?:kill|harvest|lap|completion) )?(?:count )?is: <col=ff0000>(\\d+)</col>");
    private static final Pattern NEW_PB_PATTERN = Pattern.compile("(?i)(?:(?:Fight |Lap |Challenge |Corrupted challenge )?duration:|Subdued in) <col=[0-9a-f]{6}>(?<pb>[0-9:]+(?:\\.[0-9]+)?)</col> \\(new personal best\\)");
    private static final Pattern STRAY_DOG_GIVEN_BONES_REGEX = Pattern.compile("You give the dog some nice.*bones.*");
    private static final Pattern COLLECTION_LOG_ITEM_REGEX = Pattern.compile("New item added to your collection log:.*");
    private static final Pattern COMBAT_TASK_REGEX = Pattern.compile("Congratulations, you've completed an? (?:\\w+) combat task:.*");
    private static final Pattern QUEST_REGEX = Pattern.compile("Congratulations, you've completed a quest:.*");
    private static final Pattern BOND_OFFER_REGEX = Pattern.compile("C Engineer is offering to give you a bond\\.");
    private static final Pattern STAT_SPY_REGEX = Pattern.compile(Text.standardize((String)"C Engineer is reading your skill stats!"));
    private static final Random random = new Random();
    private static final WorldArea FALADOR_HAIRDRESSER = new WorldArea(new WorldPoint(2942, 3377, 0), 8, 12);
    private static final int FALADOR_HAIRCUT_WIDGET_GROUP_ID = 516;
    private static final int CHILD_ID_MASK = 65535;
    private static final int ID_OBJECT_LUMCASTLE_GROUND_LEVEL_STAIRCASE = 16671;
    private static final int WORLD_POINT_LUMCASTLE_STAIRCASE_NORTH_X = 3204;
    private static final int WORLD_POINT_LUMCASTLE_STAIRCASE_NORTH_Y = 3229;
    private static final Set<Integer> badCollectionLogNotificationSettingValues = Set.of(Integer.valueOf(0), Integer.valueOf(2));
    private final Map<Skill, Integer> oldExperience = new EnumMap<Skill, Integer>(Skill.class);
    private final Map<Integer, Integer> oldAchievementDiaries = new HashMap<Integer, Integer>();
    private int lastLoginTick = -1;
    private int lastGEOfferTick = -1;
    private int lastZulrahKillTick = -1;
    private int lastSnowballTriggerTick = -1;
    private int lastColLogSettingWarning = -1;
    private Player cEngineerPlayer = null;
    private boolean gameStateLoggedIn = false;

    protected void startUp() throws Exception {
        this.clientThread.invoke(this::setupOldMaps);
        this.lastLoginTick = -1;
        this.executor.submit(() -> {
            SoundFileManager.ensureDownloadDirectoryExists();
            SoundFileManager.downloadAllMissingSounds(this.okHttpClient, this.config.downloadStreamerTrolls());
        });
    }

    protected void shutDown() throws Exception {
        this.oldExperience.clear();
        this.oldAchievementDiaries.clear();
        this.soundEngine.close();
    }

    private void setupOldMaps() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            this.oldExperience.clear();
            this.oldAchievementDiaries.clear();
        } else {
            for (Skill skill : Skill.values()) {
                this.oldExperience.put(skill, this.client.getSkillExperience(skill));
            }
            for (int diary : this.varbitsAchievementDiaries) {
                int value = this.client.getVarbitValue(diary);
                this.oldAchievementDiaries.put(diary, value);
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        this.gameStateLoggedIn = event.getGameState() == GameState.LOGGED_IN;
        switch (event.getGameState()) {
            case LOGIN_SCREEN: 
            case HOPPING: 
            case LOGGING_IN: 
            case LOGIN_SCREEN_AUTHENTICATOR: {
                this.oldExperience.clear();
                this.oldAchievementDiaries.clear();
            }
            case CONNECTION_LOST: {
                this.lastLoginTick = -1;
                this.lastColLogSettingWarning = this.client.getTickCount();
                break;
            }
            case LOGGED_IN: {
                this.lastLoginTick = this.client.getTickCount();
            }
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        Skill skill = statChanged.getSkill();
        int xpAfter = this.client.getSkillExperience(skill);
        int levelAfter = Experience.getLevelForXp((int)xpAfter);
        int xpBefore = this.oldExperience.getOrDefault(skill, -1);
        int levelBefore = xpBefore == -1 ? -1 : Experience.getLevelForXp((int)xpBefore);
        this.oldExperience.put(skill, xpAfter);
        if (xpBefore == -1 || xpAfter <= xpBefore || levelBefore >= levelAfter || levelAfter > 99 && !this.config.announceLevelUpIncludesVirtual()) {
            return;
        }
        if (this.config.announceLevelUp()) {
            if (this.config.showChatMessages()) {
                this.client.addChatMessage(ChatMessageType.PUBLICCHAT, C_ENGINEER, "Level up: completed.", null);
            }
            this.soundEngine.playClip(Sound.LEVEL_UP, this.executor);
        }
    }

    @Subscribe
    public void onActorDeath(ActorDeath actorDeath) {
        if (this.config.announceDeath() && actorDeath.getActor() == this.client.getLocalPlayer()) {
            if (this.config.showChatMessages()) {
                this.client.addChatMessage(ChatMessageType.PUBLICCHAT, C_ENGINEER, "Dying on my HCIM: completed.", null);
            }
            this.soundEngine.playClip(Sound.DEATH, this.executor);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() != ChatMessageType.GAMEMESSAGE && chatMessage.getType() != ChatMessageType.SPAM) {
            return;
        }
        if (this.config.announceCollectionLog() && COLLECTION_LOG_ITEM_REGEX.matcher(chatMessage.getMessage()).matches()) {
            if (this.config.showChatMessages()) {
                this.client.addChatMessage(ChatMessageType.PUBLICCHAT, C_ENGINEER, "Collection log slot: completed.", null);
            }
            this.soundEngine.playClip(Sound.COLLECTION_LOG_SLOT, this.executor);
        } else if (this.config.announceQuestCompletion() && QUEST_REGEX.matcher(chatMessage.getMessage()).matches()) {
            if (this.config.showChatMessages()) {
                this.client.addChatMessage(ChatMessageType.PUBLICCHAT, C_ENGINEER, "Quest: completed.", null);
            }
            this.soundEngine.playClip(Sound.QUEST, this.executor);
        } else if (this.config.announceCombatAchievement() && COMBAT_TASK_REGEX.matcher(chatMessage.getMessage()).matches()) {
            if (this.config.showChatMessages()) {
                this.client.addChatMessage(ChatMessageType.PUBLICCHAT, C_ENGINEER, "Combat task: completed.", null);
            }
            this.soundEngine.playClip(Sound.COMBAT_TASK, this.executor);
        } else if (this.config.easterEggs() && STRAY_DOG_GIVEN_BONES_REGEX.matcher(chatMessage.getMessage()).matches()) {
            if (this.config.showChatMessages()) {
                this.client.addChatMessage(ChatMessageType.PUBLICCHAT, C_ENGINEER, "I love you.", null);
            }
            this.soundEngine.playClip(Sound.EASTER_EGG_STRAYDOG_BONE, this.executor);
        } else if (this.config.easterEggs() && STAT_SPY_REGEX.matcher(Text.standardize((String)chatMessage.getMessage())).matches()) {
            Player localPlayer = this.client.getLocalPlayer();
            if (localPlayer == null) {
                return;
            }
            String localPlayerName = localPlayer.getName();
            if (localPlayerName == null) {
                return;
            }
            if (SKILL_SPECS.equalsIgnoreCase(Text.toJagexName((String)localPlayerName))) {
                this.soundEngine.playClip(Sound.STAT_SPY_TORVESTA, this.executor);
            } else {
                this.soundEngine.playClip(Sound.STAT_SPY_SOUNDS[random.nextInt(Sound.STAT_SPY_SOUNDS.length)], this.executor);
            }
        } else if (this.config.easterEggs()) {
            Matcher matcher = KILLCOUNT_PATTERN.matcher(chatMessage.getMessage());
            if (matcher.find() && ZULRAH.equals(matcher.group(1))) {
                this.lastZulrahKillTick = this.client.getTickCount();
            }
            if ((matcher = NEW_PB_PATTERN.matcher(chatMessage.getMessage())).find() && this.client.getTickCount() - this.lastZulrahKillTick < 2) {
                if (this.config.showChatMessages()) {
                    this.client.addChatMessage(ChatMessageType.PUBLICCHAT, C_ENGINEER, "Gz on the new personal best! Last time I got a pb here, I died on my HCIM!", null);
                }
                this.soundEngine.playClip(Sound.EASTER_EGG_ZULRAH_PB, this.executor);
            }
        }
    }

    private void checkAndWarnForCollectionLogNotificationSetting(int newVarbitValue) {
        if (!this.config.announceCollectionLog()) {
            return;
        }
        if (!this.gameStateLoggedIn) {
            return;
        }
        if (badCollectionLogNotificationSettingValues.contains(newVarbitValue) && (this.lastColLogSettingWarning == -1 || this.client.getTickCount() - this.lastColLogSettingWarning > 16)) {
            this.lastColLogSettingWarning = this.client.getTickCount();
            this.sendHighlightedMessage("Please enable \"Collection log - New addition notification\" in your game settings for C Engineer to know when to announce it! (The chat message one, pop-up doesn't matter)");
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        if (varbitChanged.getVarbitId() == 11959) {
            this.checkAndWarnForCollectionLogNotificationSetting(varbitChanged.getValue());
        }
        if (this.lastLoginTick == -1 || this.client.getTickCount() - this.lastLoginTick < 8) {
            return;
        }
        for (int diary : this.varbitsAchievementDiaries) {
            int newValue = this.client.getVarbitValue(diary);
            int previousValue = this.oldAchievementDiaries.getOrDefault(diary, -1);
            this.oldAchievementDiaries.put(diary, newValue);
            if (!this.config.announceAchievementDiary() || previousValue == -1 || previousValue == newValue || !this.isAchievementDiaryCompleted(diary, newValue)) continue;
            if (this.config.showChatMessages()) {
                this.client.addChatMessage(ChatMessageType.PUBLICCHAT, C_ENGINEER, "Achievement diary: completed.", null);
            }
            this.soundEngine.playClip(Sound.ACHIEVEMENT_DIARY, this.executor);
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked menuOptionClicked) {
        WorldPoint wp;
        if (this.config.easterEggs() && menuOptionClicked.getId() == 16671 && menuOptionClicked.getMenuOption().equals("Climb-up") && (wp = WorldPoint.fromLocal((Client)this.client, (LocalPoint)LocalPoint.fromScene((int)menuOptionClicked.getParam0(), (int)menuOptionClicked.getParam1()))).getX() == 3204 && wp.getY() == 3229) {
            if (this.config.showChatMessages()) {
                this.client.addChatMessage(ChatMessageType.PUBLICCHAT, C_ENGINEER, "Please do not use the northern staircase, use the southern one instead.", null);
            }
            this.soundEngine.playClip(Sound.EASTER_EGG_STAIRCASE, this.executor);
        }
    }

    @Subscribe
    public void onGrandExchangeOfferChanged(GrandExchangeOfferChanged offerEvent) {
        if (this.lastLoginTick == -1 || this.client.getTickCount() - this.lastLoginTick < 3) {
            return;
        }
        GrandExchangeOffer offer = offerEvent.getOffer();
        if (this.config.easterEggs() && offer.getItemId() == 20997 && offer.getPrice() == 1 && offer.getState() == GrandExchangeOfferState.SELLING && (this.lastGEOfferTick == -1 || this.client.getTickCount() - this.lastGEOfferTick > 4)) {
            if (this.config.showChatMessages()) {
                this.client.addChatMessage(ChatMessageType.PUBLICCHAT, C_ENGINEER, "Are you stupid? Did you just try to sell a twisted bow for 1gp?", null);
            }
            this.soundEngine.playClip(Sound.EASTER_EGG_TWISTED_BOW_1GP, this.executor);
        }
        this.lastGEOfferTick = this.client.getTickCount();
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded e) {
        if (!this.config.easterEggs()) {
            return;
        }
        if (e.getGroupId() == 516) {
            WorldPoint currentLocation = this.client.getLocalPlayer().getWorldLocation();
            if (FALADOR_HAIRDRESSER.contains(currentLocation)) {
                this.soundEngine.playClip(Sound.EASTER_EGG_HAIRCUT, this.executor);
            }
            return;
        }
        if (e.getGroupId() != 219) {
            return;
        }
        this.clientThread.invokeLater(() -> {
            Widget root = this.client.getWidget(219, this.getChildId(14352385));
            if (root == null) {
                return;
            }
            Widget[] children = root.getChildren();
            if (children == null) {
                return;
            }
            for (Widget child : children) {
                if (!BOND_OFFER_REGEX.matcher(Text.removeTags((String)child.getText())).matches()) continue;
                this.soundEngine.playClip(Sound.BOND_OFFER_SOUNDS[random.nextInt(Sound.BOND_OFFER_SOUNDS.length)], this.executor);
                return;
            }
        });
    }

    private int getChildId(int componentId) {
        return componentId & 0xFFFF;
    }

    @Subscribe
    public void onPlayerSpawned(PlayerSpawned playerSpawned) {
        Player player = playerSpawned.getPlayer();
        if (C_ENGINEER.equals(player.getName())) {
            this.cEngineerPlayer = player;
        }
    }

    @Subscribe
    public void onPlayerDespawned(PlayerDespawned playerDespawned) {
        Player player = playerDespawned.getPlayer();
        if (C_ENGINEER.equals(player.getName())) {
            this.cEngineerPlayer = null;
        }
    }

    @Subscribe
    public void onProjectileMoved(ProjectileMoved projectileMoved) {
        WorldPoint projectileWP;
        if (this.cEngineerPlayer == null) {
            return;
        }
        Projectile projectile = projectileMoved.getProjectile();
        if (projectile.getId() != 861) {
            return;
        }
        int currentTick = this.client.getTickCount();
        if (currentTick - this.lastSnowballTriggerTick < 50) {
            return;
        }
        Player myself = this.client.getLocalPlayer();
        if (myself == null) {
            return;
        }
        Actor projectileInteracting = projectile.getInteracting();
        if (!myself.equals(projectileInteracting)) {
            return;
        }
        if (!this.config.easterEggs()) {
            return;
        }
        WorldPoint cEngineerWP = this.cEngineerPlayer.getWorldLocation();
        if (cEngineerWP.distanceTo2D(projectileWP = WorldPoint.fromLocal((Client)this.client, (int)projectile.getX1(), (int)projectile.getY1(), (int)cEngineerWP.getPlane())) <= 2) {
            this.lastSnowballTriggerTick = currentTick;
            this.soundEngine.playClip(Sound.SNOWBALL_SOUNDS[random.nextInt(Sound.SNOWBALL_SOUNDS.length)], this.executor, Duration.ofSeconds(10L));
        }
    }

    private boolean isAchievementDiaryCompleted(int diary, int value) {
        switch (diary) {
            case 3578: 
            case 3599: 
            case 3611: {
                return value == 2;
            }
        }
        return value == 1;
    }

    @Provides
    CEngineerCompletedConfig provideConfig(ConfigManager configManager) {
        return (CEngineerCompletedConfig)configManager.getConfig(CEngineerCompletedConfig.class);
    }

    private void sendHighlightedMessage(String message) {
        String highlightedMessage = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(message).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(highlightedMessage).build());
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if ("cengineercompleted".equals(event.getGroup()) && "announceCollectionLog".equals(event.getKey())) {
            this.clientThread.invokeLater(() -> this.checkAndWarnForCollectionLogNotificationSetting(this.client.getVarbitValue(11959)));
        }
    }

    ClientThread getClientThread() {
        return this.clientThread;
    }
}

