/*
 * Decompiled with CFR 0.152.
 */
package com.example.lootbagUtilities;

import com.example.lootbagUtilities.LootbagUtilitiesConfig;
import com.google.inject.Provides;
import java.util.Arrays;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="LootbagUtilities")
public class LootbagUtilities
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LootbagUtilities.class);
    @Inject
    private Client client;
    @Inject
    private LootbagUtilitiesConfig config;
    DestroyableItem[] removeDestroyList;

    boolean getInWilderness() {
        int wilderness_varbit = this.client.getVarbitValue(5963);
        if (wilderness_varbit == 1) {
            return true;
        }
        if (wilderness_varbit == 0) {
            return false;
        }
        log.warn("Cannot determine if player is in wilderness. IN_WILDERNESS has value {}", (Object)wilderness_varbit);
        return false;
    }

    static Boolean removeLootingBagDestroy(LootbagUtilitiesConfig.LootingBagDestroySetting setting, boolean inWilderness) {
        if (setting == LootbagUtilitiesConfig.LootingBagDestroySetting.REMOVE) {
            return true;
        }
        if (setting == LootbagUtilitiesConfig.LootingBagDestroySetting.ALLOW) {
            return false;
        }
        if (setting == LootbagUtilitiesConfig.LootingBagDestroySetting.ALLOW_IN_WILDY) {
            return inWilderness;
        }
        log.error("An enum was added to LootingBagDestroySetting and this if/else was not updated");
        assert (false);
        return true;
    }

    static DestroyableItem[] genDestroyList(LootbagUtilitiesConfig config, BooleanSupplier getInWilderness) {
        DestroyableItem[] destroyableItemArray = new DestroyableItem[25];
        destroyableItemArray[0] = new DestroyableItem(() -> LootbagUtilities.removeLootingBagDestroy(config.LootingBagDestroySetting(), !getInWilderness.getAsBoolean()), 11941, "Looting Bag");
        destroyableItemArray[1] = new DestroyableItem(() -> LootbagUtilities.removeLootingBagDestroy(config.LootingBagDestroySetting(), !getInWilderness.getAsBoolean()), 22586, "Open Looting Bag");
        destroyableItemArray[2] = new DestroyableItem(config::RemoveRunePouchDestroy, 12791, "Rune Pouch");
        destroyableItemArray[3] = new DestroyableItem(config::RemoveRunePouchDestroy, 23650, "Rune Pouch");
        destroyableItemArray[4] = new DestroyableItem(config::RemoveRunePouchDestroy, 24416, "Rune Pouch(l)");
        destroyableItemArray[5] = new DestroyableItem(config::RemoveRunePouchDestroy, 27281, "Divine Rune Pouch");
        destroyableItemArray[6] = new DestroyableItem(config::RemoveRunePouchDestroy, 27509, "Divine Rune Pouch(l)");
        destroyableItemArray[7] = new DestroyableItem(config::RemoveSeedBoxDestroy, 13639, "Seed Box");
        destroyableItemArray[8] = new DestroyableItem(config::RemoveSeedBoxDestroy, 24482, "Open Seed Box");
        destroyableItemArray[9] = new DestroyableItem(config::RemoveBoltPouchDestroy, 9433, "Bolt Pouch");
        destroyableItemArray[10] = new DestroyableItem(config::RemoveHerbSackDestroy, 13226, "Herb Sack");
        destroyableItemArray[11] = new DestroyableItem(config::RemoveHerbSackDestroy, 24478, "Herb Sack");
        destroyableItemArray[12] = new DestroyableItem(config::RemoveCoalBagDestroy, 764, "Coal Bag");
        destroyableItemArray[13] = new DestroyableItem(config::RemoveCoalBagDestroy, 24480, "Open Coal Bag");
        destroyableItemArray[14] = new DestroyableItem(config::RemoveCoalBagDestroy, 12019, "Alt Coal Bag");
        destroyableItemArray[15] = new DestroyableItem(config::RemoveCoalBagDestroy, 25627, "Alt Coal Bag");
        destroyableItemArray[16] = new DestroyableItem(config::RemoveFishBarrelDestroy, 25582, "Fish Barrel");
        destroyableItemArray[17] = new DestroyableItem(config::RemoveFishBarrelDestroy, 25585, "Fish Sack Barrel");
        destroyableItemArray[18] = new DestroyableItem(config::RemoveFishBarrelDestroy, 25584, "Open Fish Barrel");
        destroyableItemArray[19] = new DestroyableItem(config::RemoveFishBarrelDestroy, 25587, "Open Fish Sack Barrel");
        destroyableItemArray[20] = new DestroyableItem(config::RemoveGemBagDestroy, 766, "Gem Bag");
        destroyableItemArray[21] = new DestroyableItem(config::RemoveGemBagDestroy, 12020, "Alt Gem Bag");
        destroyableItemArray[22] = new DestroyableItem(config::RemoveGemBagDestroy, 25628, "Alt Gem Bag");
        destroyableItemArray[23] = new DestroyableItem(config::RemoveGemBagDestroy, 24481, "Open Gem Bag");
        destroyableItemArray[24] = new DestroyableItem(config::RemoveTackleBoxDestroy, 25580, "Tackle Box");
        return destroyableItemArray;
    }

    protected void startUp() {
        this.removeDestroyList = LootbagUtilities.genDestroyList(this.config, this::getInWilderness);
    }

    protected void shutDown() {
    }

    static boolean isLootingBag(int itemId) {
        return itemId == 11941 || itemId == 22586;
    }

    static void doInventorySwaps(MenuEntry[] entries) {
        if (entries.length < 2) {
            return;
        }
        int firstIdx = entries.length - 1;
        int useIdx = -1;
        for (int i = 0; i < entries.length; ++i) {
            MenuEntry entry = entries[i];
            Widget widget = entry.getWidget();
            if (widget == null || !LootbagUtilities.isLootingBag(widget.getItemId()) || !entry.getOption().equals("Use")) continue;
            useIdx = i;
        }
        if (useIdx != -1) {
            MenuEntry tmp = entries[firstIdx];
            entries[firstIdx] = entries[useIdx];
            entries[useIdx] = tmp;
        }
    }

    static <T> void swap(T[] array, int first, int second) {
        T tmp = array[first];
        array[first] = array[second];
        array[second] = tmp;
    }

    static void doLootingBagSwaps(MenuEntry[] entries) {
        int i;
        if (entries.length < 2) {
            return;
        }
        int firstIdx = entries.length - 1;
        int depositAllIdx = -1;
        for (i = 0; i < entries.length; ++i) {
            MenuEntry entry = entries[i];
            if (!entry.getOption().equals("Store-All")) continue;
            depositAllIdx = i;
            break;
        }
        if (depositAllIdx != -1) {
            LootbagUtilities.swap(entries, firstIdx, depositAllIdx);
            for (i = depositAllIdx; i < firstIdx - 1; ++i) {
                LootbagUtilities.swap(entries, i, i + 1);
            }
        }
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.client.isMenuOpen()) {
            return;
        }
        MenuEntry[] entries = this.client.getMenuEntries();
        if (this.config.leftClickUseLootingBag()) {
            LootbagUtilities.doInventorySwaps(entries);
        }
        if ((this.config.LootingBagStoreAll() == LootbagUtilitiesConfig.LootingBagStoreAll.LEFT_CLICK || this.config.LootingBagStoreAll() == LootbagUtilitiesConfig.LootingBagStoreAll.SHIFT_CLICK && this.client.isKeyPressed(81)) && this.isLootingBagInterfaceOpen()) {
            LootbagUtilities.doLootingBagSwaps(entries);
        }
        this.client.setMenuEntries(entries);
    }

    static MenuEntry[] removeDestroy(MenuEntry[] entries, DestroyableItem[] removeDestroyList) {
        Stream<MenuEntry> entryStream = Arrays.stream(entries);
        for (DestroyableItem r : removeDestroyList) {
            Predicate<MenuEntry> p = entry -> {
                if (entry.getItemId() == r.itemId) {
                    log.debug("Removing destroy option on {}", (Object)r.itemName);
                    return true;
                }
                return false;
            };
            if (!r.removeDestroy.getAsBoolean()) continue;
            entryStream = entryStream.filter(entry -> !entry.getOption().equals("Destroy") || !p.test((MenuEntry)entry));
        }
        return (MenuEntry[])entryStream.toArray(MenuEntry[]::new);
    }

    private boolean isLootingBagInterfaceOpen() {
        return this.client.getWidget(WidgetInfo.LOOTING_BAG_CONTAINER) != null;
    }

    @Subscribe
    public void onMenuOpened(MenuOpened _unused) {
        MenuEntry[] entries = this.client.getMenuEntries();
        entries = LootbagUtilities.removeDestroy(entries, this.removeDestroyList);
        if ((this.config.LootingBagStoreAll() == LootbagUtilitiesConfig.LootingBagStoreAll.LEFT_CLICK || this.config.LootingBagStoreAll() == LootbagUtilitiesConfig.LootingBagStoreAll.SHIFT_CLICK && this.client.isKeyPressed(81)) && this.isLootingBagInterfaceOpen()) {
            LootbagUtilities.doLootingBagSwaps(entries);
        }
        this.client.setMenuEntries(entries);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked clickedOption) {
        Widget clickedWidget = clickedOption.getWidget();
        if (clickedWidget != null && LootbagUtilities.isLootingBag(clickedWidget.getItemId()) && clickedOption.getMenuOption().equals("Destroy") && LootbagUtilities.removeLootingBagDestroy(this.config.LootingBagDestroySetting(), this.getInWilderness()).booleanValue()) {
            clickedOption.consume();
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "A magical force (LootbagUtilities plugin) prevents you from destroying your looting bag", "");
            log.debug("User tried to destroy looting bag when not allowed");
        }
    }

    @Provides
    LootbagUtilitiesConfig provideConfig(ConfigManager configManager) {
        return (LootbagUtilitiesConfig)configManager.getConfig(LootbagUtilitiesConfig.class);
    }

    static final class DestroyableItem {
        public BooleanSupplier removeDestroy;
        public int itemId;
        public String itemName;

        DestroyableItem(BooleanSupplier removeDestroy, int itemId, String itemName) {
            this.removeDestroy = removeDestroy;
            this.itemId = itemId;
            this.itemName = itemName;
        }
    }
}

