/*
 * Decompiled with CFR 0.152.
 */
package com.discordscreenshot;

import com.discordscreenshot.DiscordScreenshotBody;
import com.discordscreenshot.DiscordScreenshotConfig;
import com.discordscreenshot.DiscordScreenshotOverlay;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.ImageCapture;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Discord Screenshot", description="Take a screenshot & send it to Discord!", tags={"discord", "screenshot", "photo", "screen", "instant"})
public class DiscordScreenshotPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DiscordScreenshotPlugin.class);
    @Inject
    private Client client;
    @Inject
    private DiscordScreenshotConfig config;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private DrawManager drawManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private KeyManager keyManager;
    private NavigationButton discordScreenshotBtn;
    @Inject
    private ImageCapture imageCapture;
    @Inject
    private ClientThread clientThread;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private DiscordScreenshotOverlay overlay;
    @Inject
    private ConfigManager configManager;
    private long lastButtonClickTime = 0L;
    private static final long coolDownMS = 2000L;
    private String selectedWebhookUrl;
    private final HotkeyListener hotkeyListener = new HotkeyListener(() -> this.config.hotkey()){

        public void hotkeyPressed() {
            DiscordScreenshotPlugin.this.setSelectedWebhookUrl(DiscordScreenshotPlugin.this.config.webhook());
        }
    };
    private final HotkeyListener hotkeyListener2 = new HotkeyListener(() -> this.config.hotkey2()){

        public void hotkeyPressed() {
            DiscordScreenshotPlugin.this.setSelectedWebhookUrl(DiscordScreenshotPlugin.this.config.webhook2());
        }
    };
    private final HotkeyListener hotkeyListener3 = new HotkeyListener(() -> this.config.hotkey3()){

        public void hotkeyPressed() {
            DiscordScreenshotPlugin.this.setSelectedWebhookUrl(DiscordScreenshotPlugin.this.config.webhook3());
        }
    };
    private final HotkeyListener hotkeyListener4 = new HotkeyListener(() -> this.config.hotkey4()){

        public void hotkeyPressed() {
            DiscordScreenshotPlugin.this.setSelectedWebhookUrl(DiscordScreenshotPlugin.this.config.webhook4());
        }
    };
    private final HotkeyListener hotkeyListener5 = new HotkeyListener(() -> this.config.hotkey5()){

        public void hotkeyPressed() {
            DiscordScreenshotPlugin.this.setSelectedWebhookUrl(DiscordScreenshotPlugin.this.config.webhook5());
        }
    };

    @Provides
    DiscordScreenshotConfig provideConfig(ConfigManager configManager) {
        return (DiscordScreenshotConfig)configManager.getConfig(DiscordScreenshotConfig.class);
    }

    protected void startUp() throws Exception {
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener);
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener2);
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener3);
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener4);
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener5);
        this.overlayManager.add((Overlay)this.overlay);
        RuneLite.SCREENSHOT_DIR.mkdirs();
        this.updateDiscordScreenshotButton();
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.discordScreenshotBtn);
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener2);
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener3);
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener4);
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener5);
        this.overlayManager.remove((Overlay)this.overlay);
    }

    private void updateDiscordScreenshotButton() {
        if (this.discordScreenshotBtn != null) {
            this.clientToolbar.removeNavigation(this.discordScreenshotBtn);
            this.discordScreenshotBtn = null;
        }
        this.checkWebhookNames();
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/discord-screenshot.png");
        this.discordScreenshotBtn = NavigationButton.builder().tab(false).tooltip("Send screenshot to " + this.config.webhook()).icon(icon).onClick(() -> this.setSelectedWebhookUrl(this.config.webhook())).popup((Map)ImmutableMap.builder().put((Object)this.config.webhookName2(), () -> this.setSelectedWebhookUrl(this.config.webhook2())).put((Object)this.config.webhookName3(), () -> this.setSelectedWebhookUrl(this.config.webhook3())).put((Object)this.config.webhookName4(), () -> this.setSelectedWebhookUrl(this.config.webhook4())).put((Object)this.config.webhookName5(), () -> this.setSelectedWebhookUrl(this.config.webhook5())).put((Object)"Open screenshot folder", () -> LinkBrowser.open((String)RuneLite.SCREENSHOT_DIR.toString())).build()).build();
        this.clientToolbar.addNavigation(this.discordScreenshotBtn);
    }

    private void setSelectedWebhookUrl(String webhookUrl) {
        this.selectedWebhookUrl = webhookUrl;
        this.sendMessage();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        this.updateDiscordScreenshotButton();
    }

    private void sendMessage() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastButtonClickTime < 2000L) {
            return;
        }
        this.lastButtonClickTime = currentTime;
        if (this.client.getGameState() == GameState.LOGIN_SCREEN || this.client.getLocalPlayer() == null) {
            return;
        }
        if (this.config.soundScreenshot()) {
            this.clientThread.invoke(() -> this.client.playSoundEffect(2419, this.config.volumeSound()));
        }
        String discordString = "Screenshot from " + this.client.getLocalPlayer().getName();
        DiscordScreenshotBody discordScreenshotBody = new DiscordScreenshotBody();
        discordScreenshotBody.setContent(discordString);
        this.sendWebhook(discordScreenshotBody);
    }

    private void sendWebhook(DiscordScreenshotBody discordScreenshotBody) {
        String discordUrl = this.selectedWebhookUrl;
        if (Strings.isNullOrEmpty((String)discordUrl)) {
            return;
        }
        if (this.config.hidePrivate()) {
            this.client.getWidget(0xA30000).setHidden(true);
        }
        if (this.config.hideChat()) {
            this.client.getWidget(0xA20022).setHidden(true);
        }
        HttpUrl url = HttpUrl.parse((String)discordUrl);
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", RuneLiteAPI.GSON.toJson((Object)discordScreenshotBody));
        this.screenshotConvert(url, requestBodyBuilder);
    }

    private void screenshotConvert(HttpUrl url, MultipartBody.Builder requestBodyBuilder) {
        this.drawManager.requestNextFrameListener(image -> {
            byte[] imageBytes;
            BufferedImage bufferedImage = (BufferedImage)image;
            try {
                imageBytes = DiscordScreenshotPlugin.convertImageToByteArray(bufferedImage);
            }
            catch (IOException e) {
                log.warn("Error converting the image to byte array", (Throwable)e);
                return;
            }
            if (this.config.saveScreenshot()) {
                this.imageCapture.takeScreenshot(bufferedImage, "DiscordScreenshot", "DiscordScreenshot", false, null);
            }
            requestBodyBuilder.addFormDataPart("file", "image.png", RequestBody.create((MediaType)MediaType.parse((String)"image/png"), (byte[])imageBytes));
            this.buildRequestAndSend(url, requestBodyBuilder);
        });
    }

    private static byte[] convertImageToByteArray(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void buildRequestAndSend(HttpUrl url, MultipartBody.Builder requestBodyBuilder) {
        MultipartBody requestBody = requestBodyBuilder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        this.sendRequest(request);
    }

    private void sendRequest(Request request) {
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Error submitting to the webhook", (Throwable)e);
                DiscordScreenshotPlugin.this.client.getWidget(0xA30000).setHidden(false);
                DiscordScreenshotPlugin.this.client.getWidget(0xA20022).setHidden(false);
            }

            public void onResponse(Call call, Response response) throws IOException {
                response.close();
                DiscordScreenshotPlugin.this.client.getWidget(0xA30000).setHidden(false);
                DiscordScreenshotPlugin.this.client.getWidget(0xA20022).setHidden(false);
            }
        });
    }

    public void checkWebhookNames() {
        String[] webhookNames = new String[]{this.config.webhookName2(), this.config.webhookName3(), this.config.webhookName4(), this.config.webhookName5()};
        String changedWebhookName = null;
        for (int i = 0; i < webhookNames.length; ++i) {
            for (int j = i + 1; j < webhookNames.length; ++j) {
                if (!webhookNames[i].equals(webhookNames[j])) continue;
                changedWebhookName = webhookNames[i];
                break;
            }
            if (changedWebhookName != null) break;
        }
        if (changedWebhookName != null) {
            String defaultValue = this.generateUniqueValue(webhookNames, "DefaultValue");
            int index = Arrays.asList(webhookNames).indexOf(changedWebhookName) + 2;
            this.configManager.setConfiguration("discord-screenshot", "webhook " + index, defaultValue);
        }
    }

    private String generateUniqueValue(String[] existingValues, String defaultValue) {
        Object uniqueValue = defaultValue;
        int counter = 1;
        while (Arrays.asList(existingValues).contains(uniqueValue)) {
            uniqueValue = defaultValue + counter;
            ++counter;
        }
        return uniqueValue;
    }
}

