/*
 * Decompiled with CFR 0.152.
 */
package com.discordscreenshot;

import com.discordscreenshot.DiscordScreenshotConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.inject.Inject;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;

public class DiscordScreenshotOverlay
extends OverlayPanel {
    @Inject
    private DiscordScreenshotConfig config;

    @Inject
    private DiscordScreenshotOverlay() {
        this.setPosition(OverlayPosition.TOP_CENTER);
    }

    public static String localTime() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date) + " UTC";
    }

    public Dimension render(Graphics2D graphics) {
        Object customText = this.config.customText();
        Color textColor = this.config.textColor();
        Color dateTimeColor = this.config.dateTimeColor();
        if (!((String)customText).equals(" ") && !((String)customText).equals("  ") && this.config.overlay()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left((String)customText).leftColor(textColor).build());
            if (this.config.dateTime()) {
                customText = (String)customText + " " + DiscordScreenshotOverlay.localTime();
                List e = this.panelComponent.getChildren();
                ((LineComponent)e.get(0)).setRight(DiscordScreenshotOverlay.localTime());
                ((LineComponent)e.get(0)).setRightColor(dateTimeColor);
            }
            this.panelComponent.setPreferredSize(new Dimension(graphics.getFontMetrics().stringWidth((String)customText) + this.config.textWidth(), 0));
        }
        return super.render(graphics);
    }
}

