/*
 * Decompiled with CFR 0.152.
 */
package shadechests;

import com.google.inject.Provides;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadechests.ShadeChestsConfig;
import shadechests.ShadeChestsOverlay;

@PluginDescriptor(name="Shade Chests Highlighter")
public class ShadeChestsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ShadeChestsPlugin.class);
    @Inject
    private ShadeChestsOverlay shadeChestsOverlay;
    private final HashSet<GameObject> chestsToHighlight = new HashSet();
    private final HashSet<Integer> chestIdsToHighlight = new HashSet();
    private final HashMap<Integer, Integer> keyChestsMap = new HashMap();
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ShadeChestsConfig config;

    protected void startUp() throws Exception {
        this.keyChestsMap.put(3450, 4111);
        this.keyChestsMap.put(3451, 4112);
        this.keyChestsMap.put(3452, 4113);
        this.keyChestsMap.put(3453, 4114);
        this.keyChestsMap.put(3454, 4115);
        this.keyChestsMap.put(3455, 4116);
        this.keyChestsMap.put(3456, 4117);
        this.keyChestsMap.put(3457, 4118);
        this.keyChestsMap.put(3458, 4119);
        this.keyChestsMap.put(3459, 4120);
        this.keyChestsMap.put(3460, 4121);
        this.keyChestsMap.put(3461, 4122);
        this.keyChestsMap.put(3462, 4123);
        this.keyChestsMap.put(3463, 4124);
        this.keyChestsMap.put(3464, 4125);
        this.keyChestsMap.put(3465, 4126);
        this.keyChestsMap.put(3466, 4127);
        this.keyChestsMap.put(3467, 4128);
        this.keyChestsMap.put(3468, 4129);
        this.keyChestsMap.put(3469, 4130);
        this.keyChestsMap.put(25424, 41212);
        this.keyChestsMap.put(25426, 41213);
        this.keyChestsMap.put(25428, 41214);
        this.keyChestsMap.put(25430, 41215);
        this.keyChestsMap.put(25432, 41216);
        this.overlayManager.add((Overlay)this.shadeChestsOverlay);
    }

    protected void shutDown() throws Exception {
        this.chestsToHighlight.clear();
        this.overlayManager.remove((Overlay)this.shadeChestsOverlay);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOADING) {
            this.chestsToHighlight.clear();
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        ItemContainer itemContainer = event.getItemContainer();
        if (event.getContainerId() != InventoryID.INVENTORY.getId()) {
            return;
        }
        this.chestIdsToHighlight.clear();
        for (Map.Entry<Integer, Integer> keyChest : this.keyChestsMap.entrySet()) {
            if (!itemContainer.contains(keyChest.getKey().intValue())) continue;
            this.chestIdsToHighlight.add(keyChest.getValue());
        }
        Iterator<GameObject> chestIterator = this.chestsToHighlight.iterator();
        while (chestIterator.hasNext()) {
            Integer chestId = chestIterator.next().getId();
            if (this.chestIdsToHighlight.contains(chestId)) continue;
            chestIterator.remove();
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        if (this.chestIdsToHighlight.contains(gameObject.getId())) {
            this.chestsToHighlight.add(gameObject);
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        this.chestsToHighlight.remove(event.getGameObject());
    }

    @Provides
    ShadeChestsConfig provideConfig(ConfigManager configManager) {
        return (ShadeChestsConfig)configManager.getConfig(ShadeChestsConfig.class);
    }

    public HashSet<GameObject> getChestsToHighlight() {
        return this.chestsToHighlight;
    }
}

