/*
 * Decompiled with CFR 0.152.
 */
package shadechests;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import shadechests.ShadeChestsConfig;
import shadechests.ShadeChestsPlugin;

public class ShadeChestsOverlay
extends Overlay {
    private final Client client;
    private final ShadeChestsPlugin plugin;
    private final ShadeChestsConfig config;

    @Inject
    private ShadeChestsOverlay(Client client, ShadeChestsPlugin plugin, ShadeChestsConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        for (GameObject chest : this.plugin.getChestsToHighlight()) {
            Shape polygon = chest.getConvexHull();
            if (polygon == null) continue;
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)polygon, (Color)this.config.chestHighlightColor());
        }
        return null;
    }
}

