/*
 * Decompiled with CFR 0.152.
 */
package com.randomEventAnalytics.localstorage;

import java.util.HashMap;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.client.plugins.xptracker.XpTrackerService;

public class XpInfoRecord {
    public final int totalActionsHr;
    public final int totalXpHr;
    public final String maximumActionsHrSkillName;
    public final int maximumActionsHr;
    public final String maximumXpHrSkillName;
    public final int maximumXpHr;
    public final long overallExperience;
    public final HashMap<String, Integer> xpPerSkill;

    public static XpInfoRecord create(Client client, XpTrackerService xpTrackerService) {
        Skill maximumActionsHrSkill = Skill.AGILITY;
        int maximumActionsHr = xpTrackerService.getActionsHr(Skill.AGILITY);
        Skill maximumXpHrSkill = Skill.AGILITY;
        int maximumXpHr = xpTrackerService.getXpHr(Skill.AGILITY);
        int newSkillActionsHr = -1;
        int newSkillXpHr = -1;
        HashMap<String, Integer> xpPerSkill = new HashMap<String, Integer>();
        for (Skill skill : Skill.values()) {
            xpPerSkill.put(skill.getName(), client.getSkillExperience(skill));
            newSkillActionsHr = xpTrackerService.getActionsHr(skill);
            newSkillXpHr = xpTrackerService.getXpHr(skill);
            if (newSkillActionsHr > xpTrackerService.getActionsHr(maximumActionsHrSkill)) {
                maximumActionsHrSkill = skill;
                maximumActionsHr = newSkillActionsHr;
            }
            if (newSkillXpHr <= xpTrackerService.getXpHr(maximumXpHrSkill)) continue;
            maximumXpHrSkill = skill;
            maximumXpHr = newSkillXpHr;
        }
        return new XpInfoRecord(0, 0, maximumActionsHrSkill.getName(), maximumActionsHr, maximumXpHrSkill.getName(), maximumXpHr, client.getOverallExperience(), xpPerSkill);
    }

    public int getTotalActionsHr() {
        return this.totalActionsHr;
    }

    public int getTotalXpHr() {
        return this.totalXpHr;
    }

    public String getMaximumActionsHrSkillName() {
        return this.maximumActionsHrSkillName;
    }

    public int getMaximumActionsHr() {
        return this.maximumActionsHr;
    }

    public String getMaximumXpHrSkillName() {
        return this.maximumXpHrSkillName;
    }

    public int getMaximumXpHr() {
        return this.maximumXpHr;
    }

    public long getOverallExperience() {
        return this.overallExperience;
    }

    public HashMap<String, Integer> getXpPerSkill() {
        return this.xpPerSkill;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XpInfoRecord)) {
            return false;
        }
        XpInfoRecord other = (XpInfoRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalActionsHr() != other.getTotalActionsHr()) {
            return false;
        }
        if (this.getTotalXpHr() != other.getTotalXpHr()) {
            return false;
        }
        String this$maximumActionsHrSkillName = this.getMaximumActionsHrSkillName();
        String other$maximumActionsHrSkillName = other.getMaximumActionsHrSkillName();
        if (this$maximumActionsHrSkillName == null ? other$maximumActionsHrSkillName != null : !this$maximumActionsHrSkillName.equals(other$maximumActionsHrSkillName)) {
            return false;
        }
        if (this.getMaximumActionsHr() != other.getMaximumActionsHr()) {
            return false;
        }
        String this$maximumXpHrSkillName = this.getMaximumXpHrSkillName();
        String other$maximumXpHrSkillName = other.getMaximumXpHrSkillName();
        if (this$maximumXpHrSkillName == null ? other$maximumXpHrSkillName != null : !this$maximumXpHrSkillName.equals(other$maximumXpHrSkillName)) {
            return false;
        }
        if (this.getMaximumXpHr() != other.getMaximumXpHr()) {
            return false;
        }
        if (this.getOverallExperience() != other.getOverallExperience()) {
            return false;
        }
        HashMap<String, Integer> this$xpPerSkill = this.getXpPerSkill();
        HashMap<String, Integer> other$xpPerSkill = other.getXpPerSkill();
        return !(this$xpPerSkill == null ? other$xpPerSkill != null : !((Object)this$xpPerSkill).equals(other$xpPerSkill));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XpInfoRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalActionsHr();
        result = result * 59 + this.getTotalXpHr();
        String $maximumActionsHrSkillName = this.getMaximumActionsHrSkillName();
        result = result * 59 + ($maximumActionsHrSkillName == null ? 43 : $maximumActionsHrSkillName.hashCode());
        result = result * 59 + this.getMaximumActionsHr();
        String $maximumXpHrSkillName = this.getMaximumXpHrSkillName();
        result = result * 59 + ($maximumXpHrSkillName == null ? 43 : $maximumXpHrSkillName.hashCode());
        result = result * 59 + this.getMaximumXpHr();
        long $overallExperience = this.getOverallExperience();
        result = result * 59 + (int)($overallExperience >>> 32 ^ $overallExperience);
        HashMap<String, Integer> $xpPerSkill = this.getXpPerSkill();
        result = result * 59 + ($xpPerSkill == null ? 43 : ((Object)$xpPerSkill).hashCode());
        return result;
    }

    public String toString() {
        return "XpInfoRecord(totalActionsHr=" + this.getTotalActionsHr() + ", totalXpHr=" + this.getTotalXpHr() + ", maximumActionsHrSkillName=" + this.getMaximumActionsHrSkillName() + ", maximumActionsHr=" + this.getMaximumActionsHr() + ", maximumXpHrSkillName=" + this.getMaximumXpHrSkillName() + ", maximumXpHr=" + this.getMaximumXpHr() + ", overallExperience=" + this.getOverallExperience() + ", xpPerSkill=" + this.getXpPerSkill() + ")";
    }

    public XpInfoRecord(int totalActionsHr, int totalXpHr, String maximumActionsHrSkillName, int maximumActionsHr, String maximumXpHrSkillName, int maximumXpHr, long overallExperience, HashMap<String, Integer> xpPerSkill) {
        this.totalActionsHr = totalActionsHr;
        this.totalXpHr = totalXpHr;
        this.maximumActionsHrSkillName = maximumActionsHrSkillName;
        this.maximumActionsHr = maximumActionsHr;
        this.maximumXpHrSkillName = maximumXpHrSkillName;
        this.maximumXpHr = maximumXpHr;
        this.overallExperience = overallExperience;
        this.xpPerSkill = xpPerSkill;
    }
}

