/*
 * Decompiled with CFR 0.152.
 */
package com.randomEventAnalytics.localstorage;

import com.randomEventAnalytics.TimeTracking;
import com.randomEventAnalytics.localstorage.NpcInfoRecord;
import com.randomEventAnalytics.localstorage.PlayerInfoRecord;
import com.randomEventAnalytics.localstorage.XpInfoRecord;

public class RandomEventRecord {
    public final long spawnedTime;
    public final int secondsSinceLastRandomEvent;
    public final int ticksSinceLastRandomEvent;
    public final int intervalsSinceLastRandom;
    public final NpcInfoRecord npcInfoRecord;
    public final PlayerInfoRecord playerInfoRecord;
    public final XpInfoRecord xpInfoRecord;
    private final int secondsInInstance;

    public RandomEventRecord(long spawnedTime, TimeTracking timeTracking, NpcInfoRecord npcInfoRecord, PlayerInfoRecord playerInfoRecord, XpInfoRecord xpInfoRecord) {
        this.spawnedTime = spawnedTime;
        this.secondsSinceLastRandomEvent = timeTracking.getTotalSecondsSinceLastRandomEvent();
        this.ticksSinceLastRandomEvent = timeTracking.getTicksSinceLastRandomEvent();
        this.secondsInInstance = -1;
        this.intervalsSinceLastRandom = timeTracking.getIntervalsSinceLastRandom();
        this.xpInfoRecord = xpInfoRecord;
        this.playerInfoRecord = playerInfoRecord;
        this.npcInfoRecord = npcInfoRecord;
    }

    public long getSpawnedTime() {
        return this.spawnedTime;
    }

    public int getSecondsSinceLastRandomEvent() {
        return this.secondsSinceLastRandomEvent;
    }

    public int getTicksSinceLastRandomEvent() {
        return this.ticksSinceLastRandomEvent;
    }

    public int getIntervalsSinceLastRandom() {
        return this.intervalsSinceLastRandom;
    }

    public NpcInfoRecord getNpcInfoRecord() {
        return this.npcInfoRecord;
    }

    public PlayerInfoRecord getPlayerInfoRecord() {
        return this.playerInfoRecord;
    }

    public XpInfoRecord getXpInfoRecord() {
        return this.xpInfoRecord;
    }

    public int getSecondsInInstance() {
        return this.secondsInInstance;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RandomEventRecord)) {
            return false;
        }
        RandomEventRecord other = (RandomEventRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSpawnedTime() != other.getSpawnedTime()) {
            return false;
        }
        if (this.getSecondsSinceLastRandomEvent() != other.getSecondsSinceLastRandomEvent()) {
            return false;
        }
        if (this.getTicksSinceLastRandomEvent() != other.getTicksSinceLastRandomEvent()) {
            return false;
        }
        if (this.getIntervalsSinceLastRandom() != other.getIntervalsSinceLastRandom()) {
            return false;
        }
        NpcInfoRecord this$npcInfoRecord = this.getNpcInfoRecord();
        NpcInfoRecord other$npcInfoRecord = other.getNpcInfoRecord();
        if (this$npcInfoRecord == null ? other$npcInfoRecord != null : !((Object)this$npcInfoRecord).equals(other$npcInfoRecord)) {
            return false;
        }
        PlayerInfoRecord this$playerInfoRecord = this.getPlayerInfoRecord();
        PlayerInfoRecord other$playerInfoRecord = other.getPlayerInfoRecord();
        if (this$playerInfoRecord == null ? other$playerInfoRecord != null : !((Object)this$playerInfoRecord).equals(other$playerInfoRecord)) {
            return false;
        }
        XpInfoRecord this$xpInfoRecord = this.getXpInfoRecord();
        XpInfoRecord other$xpInfoRecord = other.getXpInfoRecord();
        if (this$xpInfoRecord == null ? other$xpInfoRecord != null : !((Object)this$xpInfoRecord).equals(other$xpInfoRecord)) {
            return false;
        }
        return this.getSecondsInInstance() == other.getSecondsInInstance();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RandomEventRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $spawnedTime = this.getSpawnedTime();
        result = result * 59 + (int)($spawnedTime >>> 32 ^ $spawnedTime);
        result = result * 59 + this.getSecondsSinceLastRandomEvent();
        result = result * 59 + this.getTicksSinceLastRandomEvent();
        result = result * 59 + this.getIntervalsSinceLastRandom();
        NpcInfoRecord $npcInfoRecord = this.getNpcInfoRecord();
        result = result * 59 + ($npcInfoRecord == null ? 43 : ((Object)$npcInfoRecord).hashCode());
        PlayerInfoRecord $playerInfoRecord = this.getPlayerInfoRecord();
        result = result * 59 + ($playerInfoRecord == null ? 43 : ((Object)$playerInfoRecord).hashCode());
        XpInfoRecord $xpInfoRecord = this.getXpInfoRecord();
        result = result * 59 + ($xpInfoRecord == null ? 43 : ((Object)$xpInfoRecord).hashCode());
        result = result * 59 + this.getSecondsInInstance();
        return result;
    }

    public String toString() {
        return "RandomEventRecord(spawnedTime=" + this.getSpawnedTime() + ", secondsSinceLastRandomEvent=" + this.getSecondsSinceLastRandomEvent() + ", ticksSinceLastRandomEvent=" + this.getTicksSinceLastRandomEvent() + ", intervalsSinceLastRandom=" + this.getIntervalsSinceLastRandom() + ", npcInfoRecord=" + this.getNpcInfoRecord() + ", playerInfoRecord=" + this.getPlayerInfoRecord() + ", xpInfoRecord=" + this.getXpInfoRecord() + ", secondsInInstance=" + this.getSecondsInInstance() + ")";
    }
}

