/*
 * Decompiled with CFR 0.152.
 */
package com.randomEventAnalytics.localstorage;

import com.randomEventAnalytics.localstorage.RandomEventRecord;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import net.runelite.client.RuneLite;
import net.runelite.http.api.RuneLiteAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomEventAnalyticsLocalStorage {
    private static final String FILE_EXTENSION = ".log";
    private static final File RANDOM_EVENT_RECORD_DIR = new File(RuneLite.RUNELITE_DIR, "random-event-analytics");
    private static final String RANDOM_EVENTS_FILE = "random-events";
    private static final Logger log = LoggerFactory.getLogger(RandomEventAnalyticsLocalStorage.class);
    private File playerFolder;
    private int numberOfLoggedEvents = 0;
    private String username;

    @Inject
    public RandomEventAnalyticsLocalStorage() {
        RANDOM_EVENT_RECORD_DIR.mkdir();
    }

    public boolean setPlayerUsername(String username) {
        if (username.equalsIgnoreCase(this.username)) {
            return false;
        }
        this.playerFolder = new File(RANDOM_EVENT_RECORD_DIR, username);
        this.playerFolder.mkdir();
        this.username = username;
        return true;
    }

    private File getFile(String fileName) {
        return new File(this.playerFolder, fileName + FILE_EXTENSION);
    }

    public synchronized ArrayList<RandomEventRecord> loadRandomEventRecords() {
        File file = this.getFile(RANDOM_EVENTS_FILE);
        ArrayList<RandomEventRecord> data = new ArrayList<RandomEventRecord>();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.length() <= 0) continue;
                RandomEventRecord r = (RandomEventRecord)RuneLiteAPI.GSON.fromJson(line, RandomEventRecord.class);
                data.add(r);
            }
        }
        catch (FileNotFoundException e) {
            log.debug("File not found: {}", (Object)file.getName());
        }
        catch (IOException e) {
            log.warn("IOException for file {}: {}", (Object)file.getName(), (Object)e.getMessage());
        }
        this.numberOfLoggedEvents = data.size();
        return data;
    }

    public synchronized RandomEventRecord getMostRecentRandom() {
        ArrayList<RandomEventRecord> data = this.loadRandomEventRecords();
        if (data.size() > 0) {
            return data.get(data.size() - 1);
        }
        return null;
    }

    public synchronized boolean renameUsernameFolderToAccountHash(String username, long hash) {
        File usernameDir = new File(RANDOM_EVENT_RECORD_DIR, username);
        if (!usernameDir.exists()) {
            return true;
        }
        File hashDir = new File(RANDOM_EVENT_RECORD_DIR, String.valueOf(hash));
        if (hashDir.exists()) {
            log.warn("Can't rename username folder to account hash as the folder for this account hash already exists. This was most likely caused by running RL through the Jagex launcher before the migration code was added");
            log.warn("Username: {} | AccountHash: {}", (Object)username, (Object)hash);
            return false;
        }
        return usernameDir.renameTo(hashDir);
    }

    public synchronized boolean addRandomEventRecord(RandomEventRecord rec) {
        File randomEventsFile = this.getFile(RANDOM_EVENTS_FILE);
        String dataAsString = RuneLiteAPI.GSON.toJson((Object)rec);
        try {
            BufferedWriter file = new BufferedWriter(new FileWriter(String.valueOf(randomEventsFile), true));
            file.append(dataAsString);
            file.newLine();
            file.close();
            ++this.numberOfLoggedEvents;
            return true;
        }
        catch (IOException ioe) {
            log.warn("Error writing loot data to file {}: {}", (Object)randomEventsFile.getName(), (Object)ioe.getMessage());
            return false;
        }
    }

    public int getNumberOfLoggedEvents() {
        return this.numberOfLoggedEvents;
    }

    public String getUsername() {
        return this.username;
    }
}

