/*
 * Decompiled with CFR 0.152.
 */
package com.randomEventAnalytics.localstorage;

import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;

public class PlayerInfoRecord {
    public final int combatLevel;
    public final int localX;
    public final int localY;
    public final int worldX;
    public final int worldY;
    public final int worldPlane;

    public static PlayerInfoRecord create(Player player) {
        LocalPoint playerLocalLocation = player.getLocalLocation();
        WorldPoint playerWorldLocation = player.getWorldLocation();
        return new PlayerInfoRecord(player.getCombatLevel(), playerLocalLocation.getX(), playerLocalLocation.getY(), playerWorldLocation.getX(), playerWorldLocation.getY(), playerWorldLocation.getPlane());
    }

    public int getCombatLevel() {
        return this.combatLevel;
    }

    public int getLocalX() {
        return this.localX;
    }

    public int getLocalY() {
        return this.localY;
    }

    public int getWorldX() {
        return this.worldX;
    }

    public int getWorldY() {
        return this.worldY;
    }

    public int getWorldPlane() {
        return this.worldPlane;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerInfoRecord)) {
            return false;
        }
        PlayerInfoRecord other = (PlayerInfoRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCombatLevel() != other.getCombatLevel()) {
            return false;
        }
        if (this.getLocalX() != other.getLocalX()) {
            return false;
        }
        if (this.getLocalY() != other.getLocalY()) {
            return false;
        }
        if (this.getWorldX() != other.getWorldX()) {
            return false;
        }
        if (this.getWorldY() != other.getWorldY()) {
            return false;
        }
        return this.getWorldPlane() == other.getWorldPlane();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerInfoRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCombatLevel();
        result = result * 59 + this.getLocalX();
        result = result * 59 + this.getLocalY();
        result = result * 59 + this.getWorldX();
        result = result * 59 + this.getWorldY();
        result = result * 59 + this.getWorldPlane();
        return result;
    }

    public String toString() {
        return "PlayerInfoRecord(combatLevel=" + this.getCombatLevel() + ", localX=" + this.getLocalX() + ", localY=" + this.getLocalY() + ", worldX=" + this.getWorldX() + ", worldY=" + this.getWorldY() + ", worldPlane=" + this.getWorldPlane() + ")";
    }

    public PlayerInfoRecord(int combatLevel, int localX, int localY, int worldX, int worldY, int worldPlane) {
        this.combatLevel = combatLevel;
        this.localX = localX;
        this.localY = localY;
        this.worldX = worldX;
        this.worldY = worldY;
        this.worldPlane = worldPlane;
    }
}

