/*
 * Decompiled with CFR 0.152.
 */
package com.randomEventAnalytics.localstorage;

import net.runelite.api.NPC;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;

public class NpcInfoRecord {
    public final int npcId;
    public final String npcName;
    public final int combatLevel;
    public final int localX;
    public final int localY;
    public final int worldX;
    public final int worldY;
    public final int worldPlane;

    public static NpcInfoRecord create(NPC npc) {
        LocalPoint npcLocalLocation = npc.getLocalLocation();
        WorldPoint npcWorldLocation = npc.getWorldLocation();
        return new NpcInfoRecord(npc.getId(), npc.getName(), npc.getCombatLevel(), npcLocalLocation.getX(), npcLocalLocation.getY(), npcWorldLocation.getX(), npcWorldLocation.getY(), npcWorldLocation.getPlane());
    }

    public int getNpcId() {
        return this.npcId;
    }

    public String getNpcName() {
        return this.npcName;
    }

    public int getCombatLevel() {
        return this.combatLevel;
    }

    public int getLocalX() {
        return this.localX;
    }

    public int getLocalY() {
        return this.localY;
    }

    public int getWorldX() {
        return this.worldX;
    }

    public int getWorldY() {
        return this.worldY;
    }

    public int getWorldPlane() {
        return this.worldPlane;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NpcInfoRecord)) {
            return false;
        }
        NpcInfoRecord other = (NpcInfoRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNpcId() != other.getNpcId()) {
            return false;
        }
        String this$npcName = this.getNpcName();
        String other$npcName = other.getNpcName();
        if (this$npcName == null ? other$npcName != null : !this$npcName.equals(other$npcName)) {
            return false;
        }
        if (this.getCombatLevel() != other.getCombatLevel()) {
            return false;
        }
        if (this.getLocalX() != other.getLocalX()) {
            return false;
        }
        if (this.getLocalY() != other.getLocalY()) {
            return false;
        }
        if (this.getWorldX() != other.getWorldX()) {
            return false;
        }
        if (this.getWorldY() != other.getWorldY()) {
            return false;
        }
        return this.getWorldPlane() == other.getWorldPlane();
    }

    protected boolean canEqual(Object other) {
        return other instanceof NpcInfoRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNpcId();
        String $npcName = this.getNpcName();
        result = result * 59 + ($npcName == null ? 43 : $npcName.hashCode());
        result = result * 59 + this.getCombatLevel();
        result = result * 59 + this.getLocalX();
        result = result * 59 + this.getLocalY();
        result = result * 59 + this.getWorldX();
        result = result * 59 + this.getWorldY();
        result = result * 59 + this.getWorldPlane();
        return result;
    }

    public String toString() {
        return "NpcInfoRecord(npcId=" + this.getNpcId() + ", npcName=" + this.getNpcName() + ", combatLevel=" + this.getCombatLevel() + ", localX=" + this.getLocalX() + ", localY=" + this.getLocalY() + ", worldX=" + this.getWorldX() + ", worldY=" + this.getWorldY() + ", worldPlane=" + this.getWorldPlane() + ")";
    }

    public NpcInfoRecord(int npcId, String npcName, int combatLevel, int localX, int localY, int worldX, int worldY, int worldPlane) {
        this.npcId = npcId;
        this.npcName = npcName;
        this.combatLevel = combatLevel;
        this.localX = localX;
        this.localY = localY;
        this.worldX = worldX;
        this.worldY = worldY;
        this.worldPlane = worldPlane;
    }
}

