/*
 * Decompiled with CFR 0.152.
 */
package com.randomEventAnalytics;

import com.google.inject.Singleton;
import com.randomEventAnalytics.localstorage.RandomEventRecord;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.client.config.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TimeTracking {
    private static final Logger log = LoggerFactory.getLogger(TimeTracking.class);
    public static final int SPAWN_INTERVAL_SECONDS = 300;
    private static final int SPAWN_INTERVAL_MARGIN_SECONDS = 0;
    private static final int SPAWN_INTERVAL_TIMEFRAME_SECONDS = 15;
    public static final int SECONDS_IN_AN_HOUR = 3600;
    private int sessionTicks;
    private Instant lastRandomSpawnInstant;
    private Instant loginTime;
    @Inject
    private ConfigManager configManager;

    public void init(Instant loginTime, Instant lastRandomSpawnInstant) {
        this.loginTime = loginTime;
        this.lastRandomSpawnInstant = lastRandomSpawnInstant;
    }

    public int getTotalSecondsSinceLastRandomEvent() {
        if (this.loginTime == null) {
            return this.getConfigSecondsSinceLastRandom();
        }
        if (this.lastRandomSpawnInstant != null && this.lastRandomSpawnInstant.isAfter(this.loginTime)) {
            return (int)Duration.between(this.lastRandomSpawnInstant, Instant.now()).toMillis() / 1000;
        }
        Duration duration = Duration.between(this.loginTime, Instant.now());
        return this.getConfigSecondsSinceLastRandom() + (int)duration.getSeconds();
    }

    public void onTick() {
        ++this.sessionTicks;
    }

    public boolean hasLoggedInLongEnoughForSpawn() {
        return this.getSecondsSinceLogin() > 300;
    }

    public int getSecondsSinceLogin() {
        if (this.loginTime == null) {
            return -1;
        }
        return (int)Duration.between(this.loginTime, Instant.now()).toMillis() / 1000;
    }

    public int getNextRandomEventEstimation() {
        int loginTime = this.getSecondsSinceLogin();
        if (loginTime < 0) {
            return 300;
        }
        if (!this.hasLoggedInLongEnoughForSpawn()) {
            return 300 - loginTime;
        }
        int secondsMod = loginTime % 300;
        if (secondsMod <= 0) {
            return -secondsMod;
        }
        return 300 - secondsMod;
    }

    private boolean isInsideRandomEventWindow() {
        int loginTime = this.getSecondsSinceLogin();
        int secondsMod = loginTime % 300;
        return secondsMod <= 15 || secondsMod >= 285;
    }

    public boolean isPossibleTimeForRandomEvent() {
        if (this.lastRandomSpawnInstant == null) {
            return this.isInsideRandomEventWindow();
        }
        if (!this.hasLoggedInLongEnoughForSpawn()) {
            return false;
        }
        if (this.getTotalSecondsSinceLastRandomEvent() < 3600) {
            return false;
        }
        return this.isInsideRandomEventWindow();
    }

    public void setRandomEventSpawned() {
        this.lastRandomSpawnInstant = Instant.now();
        this.sessionTicks = 0;
        this.setConfigAfterSpawn();
    }

    public void setStrangePlantSpawned(RandomEventRecord record) {
        this.lastRandomSpawnInstant = Instant.ofEpochMilli(record.spawnedTime);
        this.sessionTicks = 0;
        this.setConfigAfterSpawn();
    }

    public void setLoginTime(Instant instant) {
        this.loginTime = instant;
    }

    private Instant getMostRecentInstant() {
        if (this.loginTime == null) {
            return null;
        }
        if (this.lastRandomSpawnInstant == null) {
            return this.loginTime;
        }
        if (this.lastRandomSpawnInstant.isAfter(this.loginTime)) {
            return this.lastRandomSpawnInstant;
        }
        return this.loginTime;
    }

    public int getIntervalsSinceLastRandom() {
        if (this.getMostRecentInstant() == null) {
            return this.getConfigIntervalsSinceLastRandom();
        }
        int sessionDuration = (int)Duration.between(this.getMostRecentInstant(), Instant.now()).getSeconds();
        return this.getConfigIntervalsSinceLastRandom() + sessionDuration / 300;
    }

    public int getTicksSinceLastRandomEvent() {
        return this.getConfigTicksSinceLastRandom() + this.sessionTicks;
    }

    public int getSecondsInInstance() {
        return this.getConfigSecondsInInstance();
    }

    public int getCountdownSeconds(int numMinutesPerRandom) {
        return numMinutesPerRandom * 60 - this.getTotalSecondsSinceLastRandomEvent();
    }

    public double getProbabilityForNextWindow() {
        int intervalsAfterHour = this.getIntervalsSinceLastRandom() - 12;
        if (intervalsAfterHour < 0) {
            return 0.0;
        }
        return (double)intervalsAfterHour / 12.0;
    }

    private int getConfigIntervalsSinceLastRandom() {
        int configIntervals = this.getIntFromConfig("intervalsSinceLastRandom", -1);
        if (configIntervals == -1) {
            configIntervals = this.getTotalSecondsSinceLastRandomEvent() / 300;
        }
        return configIntervals;
    }

    private int getConfigTicksSinceLastRandom() {
        return this.getIntFromConfig("ticksSinceLastRandom", 0);
    }

    private int getConfigSecondsSinceLastRandom() {
        return this.getIntFromConfig("secondsSinceLastRandom", 0);
    }

    private int getConfigSecondsInInstance() {
        return this.getIntFromConfig("secondsInInstance", -1);
    }

    public void persistConfig() {
        this.saveConfig("secondsSinceLastRandom", this.getTotalSecondsSinceLastRandomEvent());
        this.saveConfig("intervalsSinceLastRandom", this.getIntervalsSinceLastRandom());
        this.saveConfig("ticksSinceLastRandom", this.getTicksSinceLastRandomEvent());
        this.saveConfig("secondsInInstance", this.getSecondsInInstance());
        if (this.lastRandomSpawnInstant != null) {
            this.saveConfig("lastRandomSpawnInstant", this.lastRandomSpawnInstant);
        }
    }

    public void setConfigAfterSpawn() {
        this.saveConfig("secondsSinceLastRandom", 0);
        this.saveConfig("intervalsSinceLastRandom", 0);
        this.saveConfig("ticksSinceLastRandom", 0);
        this.saveConfig("secondsInInstance", 0);
        if (this.lastRandomSpawnInstant != null) {
            this.saveConfig("lastRandomSpawnInstant", this.lastRandomSpawnInstant);
        }
    }

    private <T> void saveConfig(String key, T value) {
        try {
            this.configManager.setRSProfileConfiguration("randomeventanalytics", key, value);
        }
        catch (NullPointerException e) {
            log.debug("Error setting config {}: {} | ConfigManager most likely not set", (Object)key, value);
        }
    }

    private int getIntFromConfig(String key, int _default) {
        try {
            return (Integer)this.configManager.getRSProfileConfiguration("randomeventanalytics", key, Integer.TYPE);
        }
        catch (NullPointerException e) {
            try {
                log.debug("No config loaded for: {}@{}", (Object)key, (Object)this.configManager.getRSProfileKey());
                return _default;
            }
            catch (NullPointerException configError) {
                log.debug("Error loading configManager");
                return _default;
            }
        }
    }

    public Instant getLastRandomSpawnInstant() {
        return this.lastRandomSpawnInstant;
    }

    public Instant getLoginTime() {
        return this.loginTime;
    }
}

