/*
 * Decompiled with CFR 0.152.
 */
package com.randomEventAnalytics;

import com.randomEventAnalytics.RandomEventAnalyticsPanel;
import com.randomEventAnalytics.RandomEventAnalyticsUtil;
import com.randomEventAnalytics.localstorage.RandomEventRecord;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;

public class RandomEventRecordBox
extends JPanel {
    private final RandomEventAnalyticsPanel panel;
    private final RandomEventRecord randomEvent;
    private final JLabel spawnedTimeLabel = new JLabel();

    RandomEventRecordBox(RandomEventAnalyticsPanel panel, RandomEventRecord randomEvent) {
        this(panel, randomEvent, true);
    }

    RandomEventRecordBox(RandomEventAnalyticsPanel panel, RandomEventRecord randomEvent, boolean isConfirmed) {
        this.randomEvent = randomEvent;
        this.panel = panel;
        this.buildRandomEventPanel(randomEvent, isConfirmed);
    }

    private String buildToolTip(RandomEventRecord record) {
        String spawnedTime = this.panel.longTimeFormat.format(record.spawnedTime);
        String data = "<html> NPC ID: " + record.npcInfoRecord.npcId + "<br>\u0394 Event Time: " + RandomEventAnalyticsUtil.formatSeconds(record.secondsSinceLastRandomEvent) + "<br>Spawned Time: " + spawnedTime;
        data = data + "<br>PlayerLocal: <p style=\"font-size: 0.95em\">(X: " + record.playerInfoRecord.localX + " , Y: " + record.playerInfoRecord.localY + ")</p>";
        data = data + "Intervals: ";
        data = record.intervalsSinceLastRandom > 0 ? data + record.intervalsSinceLastRandom + "<p style=\"font-size: 0.95em\">(" + record.intervalsSinceLastRandom * 5 + " minutes)</p>" : data + "Record has no data<br>";
        data = data + "World: <p style=\"font-size: 0.95em\">(X: " + record.playerInfoRecord.worldX + " , Y: " + record.playerInfoRecord.worldY + " , P: " + record.playerInfoRecord.worldPlane + ")</p>";
        data = data + "</html>";
        return data;
    }

    public RandomEventRecord getRandomEvent() {
        return this.randomEvent;
    }

    private JPanel buildRandomEventPanel(RandomEventRecord record, boolean isConfirmed) {
        JLabel randomName = new JLabel(record.npcInfoRecord.npcName);
        this.spawnedTimeLabel.setText(this.panel.shortTimeFormat.format(record.spawnedTime));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        JPanel randomInfo = new JPanel();
        randomInfo.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        randomInfo.setLayout(new GridLayout(2, 1));
        randomInfo.setBorder(new EmptyBorder(0, 10, 0, 0));
        randomName.setFont(FontManager.getRunescapeBoldFont());
        this.spawnedTimeLabel.setFont(FontManager.getRunescapeSmallFont());
        randomInfo.add(randomName);
        randomInfo.add(this.spawnedTimeLabel);
        this.add((Component)new JLabel(RandomEventAnalyticsUtil.getNPCIcon(record.npcInfoRecord.npcId)), "West");
        this.add(randomInfo);
        this.setToolTipText(this.buildToolTip(record));
        if (!isConfirmed) {
            this.add(this.buildConfirmationPanel(record));
        }
        this.update();
        return this;
    }

    private JPanel buildConfirmationPanel(RandomEventRecord record) {
        JPanel confirmationPanel = new JPanel();
        confirmationPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        confirmationPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        confirmationPanel.setLayout(new BorderLayout());
        JLabel confirmRandomLabel = new JLabel("Is this your random event?");
        JButton confirm = new JButton("\u2713");
        confirm.setFont(new Font("Dialog", 0, 12));
        confirm.setForeground(Color.GREEN);
        confirm.addActionListener(e -> SwingUtilities.invokeLater(() -> this.panel.eventRecordBoxUpdated(this, true)));
        JButton cancel = new JButton("\u2717");
        cancel.setFont(new Font("Dialog", 0, 12));
        cancel.setForeground(Color.RED);
        cancel.addActionListener(e -> this.panel.eventRecordBoxUpdated(this, false));
        confirmationPanel.add((Component)confirmRandomLabel, "North");
        confirmationPanel.add((Component)confirm, "West");
        confirmationPanel.add((Component)cancel, "East");
        return confirmationPanel;
    }

    void update() {
        this.spawnedTimeLabel.setText(this.panel.shortTimeFormat.format(this.randomEvent.spawnedTime));
        this.setToolTipText(this.buildToolTip(this.randomEvent));
    }
}

