/*
 * Decompiled with CFR 0.152.
 */
package com.randomEventAnalytics;

import com.randomEventAnalytics.RandomEventAnalyticsPlugin;
import java.awt.Color;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.QuantityFormatter;

public class RandomEventAnalyticsUtil {
    public static final HashMap<Integer, NpcIdWrapper> NPCS = new HashMap<Integer, NpcIdWrapper>(){
        {
            this.put(6747, new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/bee_keeper.png")), false, true));
            this.put(5426, new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/capt_arnav.png")), true, true));
            this.put(322, new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/drunken_dwarf.png")), true, true));
            this.put(6744, new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/flippa.png")), false, true));
            NpcIdWrapper giles = new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/giles.png")), true, true);
            this.put(5438, giles);
            this.put(5441, giles);
            NpcIdWrapper miles = new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/miles.png")), true, true);
            this.put(5437, miles);
            this.put(5440, miles);
            NpcIdWrapper niles = new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/niles.png")), true, true);
            this.put(5436, niles);
            this.put(5439, niles);
            this.put(380, new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/pillory_guard.png")), false, true));
            this.put(6738, new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/postie_pete.png")), false, true));
            NpcIdWrapper rickTurpentine = new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/rick_turpentine.png")), true, true);
            this.put(375, rickTurpentine);
            this.put(376, rickTurpentine);
            this.put(6743, new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/sergeant_damien.png")), false, true));
            this.put(6748, new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/freaky_forester.png")), false, true));
            this.put(5429, new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/frog.png")), true, true));
            NpcIdWrapper genie = new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/genie.png")), true, true);
            this.put(326, genie);
            this.put(327, genie);
            NpcIdWrapper drJekyll = new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/dr_jekyll.png")), true, false);
            this.put(307, drJekyll);
            this.put(314, drJekyll);
            NpcIdWrapper evilBob = new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/evil_bob.png")), false, true);
            this.put(390, evilBob);
            this.put(6754, evilBob);
            this.put(6746, new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/leo.png")), false, true));
            NpcIdWrapper mysteriousOldMan = new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/mysterious_old_man.png")), true, true);
            this.put(6750, mysteriousOldMan);
            this.put(6751, mysteriousOldMan);
            this.put(6752, mysteriousOldMan);
            this.put(6753, mysteriousOldMan);
            this.put(6755, new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/quiz_master.png")), false, true));
            this.put(6749, new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/dunce.png")), false, true));
            this.put(5510, new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/sandwich_lady.png")), true, true));
            this.put(323, new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/strange_plant.png")), true, false));
            NpcIdWrapper countCheck = new NpcIdWrapper(new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/count_check.png")), false, true);
            this.put(12551, countCheck);
            this.put(12552, countCheck);
        }
    };
    static final DecimalFormat TWO_DECIMAL_FORMAT = new DecimalFormat("0.00");
    private static final String HTML_LABEL_TEMPLATE = "<html><body style='color:%s'>%s<span style='color:white'>%s</span></body></html>";
    private static final ImageIcon unknownNPC = new ImageIcon(ImageUtil.loadImageResource(RandomEventAnalyticsPlugin.class, (String)"chatheads/question_mark.png"));

    public static Set<Integer> getEventNpcIds() {
        return NPCS.keySet();
    }

    public static Set<Integer> getWildernessEventNpcIds() {
        return NPCS.entrySet().stream().filter(npcWrapper -> ((NpcIdWrapper)npcWrapper.getValue()).isAvailableInWilderness).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public static Set<Integer> getF2PEventNpcIds() {
        return NPCS.entrySet().stream().filter(npcWrapper -> ((NpcIdWrapper)npcWrapper.getValue()).isAvailableF2P).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public static String calculateTimeFromTicks(int ticks) {
        long seconds = Math.round((double)ticks * 0.6);
        long durationDays = seconds / 86400L;
        long durationHours = seconds % 86400L / 3600L;
        long durationHoursTotal = seconds / 3600L;
        long durationMinutes = seconds % 3600L / 60L;
        long durationSeconds = seconds % 60L;
        if (durationHoursTotal > 0L) {
            return String.format("%02d:%02d:%02d", durationHoursTotal, durationMinutes, durationSeconds);
        }
        return String.format("%02d:%02d", durationMinutes, durationSeconds);
    }

    public static String formatSeconds(int seconds) {
        long durationDays = seconds / 86400;
        long durationHours = seconds % 86400 / 3600;
        long durationHoursTotal = seconds / 3600;
        long durationMinutes = seconds % 3600 / 60;
        long durationSeconds = seconds % 60;
        if (durationHoursTotal > 0L) {
            return String.format("%02d:%02d:%02d", durationHoursTotal, durationMinutes, durationSeconds);
        }
        return String.format("%02d:%02d", durationMinutes, durationSeconds);
    }

    static String htmlLabel(String key, int value) {
        return RandomEventAnalyticsUtil.htmlLabel(key, QuantityFormatter.quantityToRSDecimalStack((int)value, (boolean)true));
    }

    static String htmlLabel(String key, String value) {
        return String.format(HTML_LABEL_TEMPLATE, ColorUtil.toHexColor((Color)ColorScheme.LIGHT_GRAY_COLOR), key, value);
    }

    public static String formatNumber(int value) {
        return NumberFormat.getNumberInstance(Locale.US).format(value);
    }

    public static String formatNumber(long value) {
        return NumberFormat.getNumberInstance(Locale.US).format(value);
    }

    public static ImageIcon getNPCIcon(int id) {
        NpcIdWrapper npc = NPCS.get(id);
        if (npc == null || npc.icon == null) {
            return unknownNPC;
        }
        return npc.icon;
    }

    static {
        TWO_DECIMAL_FORMAT.setRoundingMode(RoundingMode.DOWN);
    }

    private static class NpcIdWrapper {
        ImageIcon icon;
        boolean isAvailableInWilderness;
        boolean isAvailableF2P;

        public ImageIcon getIcon() {
            return this.icon;
        }

        public boolean isAvailableInWilderness() {
            return this.isAvailableInWilderness;
        }

        public boolean isAvailableF2P() {
            return this.isAvailableF2P;
        }

        public void setIcon(ImageIcon icon) {
            this.icon = icon;
        }

        public void setAvailableInWilderness(boolean isAvailableInWilderness) {
            this.isAvailableInWilderness = isAvailableInWilderness;
        }

        public void setAvailableF2P(boolean isAvailableF2P) {
            this.isAvailableF2P = isAvailableF2P;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NpcIdWrapper)) {
                return false;
            }
            NpcIdWrapper other = (NpcIdWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ImageIcon this$icon = this.getIcon();
            ImageIcon other$icon = other.getIcon();
            if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
                return false;
            }
            if (this.isAvailableInWilderness() != other.isAvailableInWilderness()) {
                return false;
            }
            return this.isAvailableF2P() == other.isAvailableF2P();
        }

        protected boolean canEqual(Object other) {
            return other instanceof NpcIdWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ImageIcon $icon = this.getIcon();
            result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
            result = result * 59 + (this.isAvailableInWilderness() ? 79 : 97);
            result = result * 59 + (this.isAvailableF2P() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "RandomEventAnalyticsUtil.NpcIdWrapper(icon=" + this.getIcon() + ", isAvailableInWilderness=" + this.isAvailableInWilderness() + ", isAvailableF2P=" + this.isAvailableF2P() + ")";
        }

        public NpcIdWrapper(ImageIcon icon, boolean isAvailableInWilderness, boolean isAvailableF2P) {
            this.icon = icon;
            this.isAvailableInWilderness = isAvailableInWilderness;
            this.isAvailableF2P = isAvailableF2P;
        }
    }
}

