/*
 * Decompiled with CFR 0.152.
 */
package com.randomEventAnalytics;

import com.google.inject.Provides;
import com.randomEventAnalytics.RandomEventAnalyticsConfig;
import com.randomEventAnalytics.RandomEventAnalyticsOverlay;
import com.randomEventAnalytics.RandomEventAnalyticsPanel;
import com.randomEventAnalytics.RandomEventAnalyticsUtil;
import com.randomEventAnalytics.TimeTracking;
import com.randomEventAnalytics.localstorage.NpcInfoRecord;
import com.randomEventAnalytics.localstorage.PlayerInfoRecord;
import com.randomEventAnalytics.localstorage.RandomEventAnalyticsLocalStorage;
import com.randomEventAnalytics.localstorage.RandomEventRecord;
import com.randomEventAnalytics.localstorage.XpInfoRecord;
import java.awt.image.BufferedImage;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.Notifier;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ClientShutdown;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.xptracker.XpTrackerPlugin;
import net.runelite.client.plugins.xptracker.XpTrackerService;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Random Event Analytics")
@PluginDependency(value=XpTrackerPlugin.class)
public class RandomEventAnalyticsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RandomEventAnalyticsPlugin.class);
    private static final int RANDOM_EVENT_TIMEOUT = 150;
    private static final int STRANGE_PLANT_SPAWN_RADIUS = 1;
    private static final String PLANT_SPAWNED_NOTIFICATION_MESSAGE = "A Strange Plant has spawned, please visit the Random Event Analytics panel to confirm the random.";
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private RandomEventAnalyticsOverlay overlay;
    @Inject
    private Client client;
    @Inject
    private RandomEventAnalyticsConfig config;
    @Inject
    private RandomEventAnalyticsLocalStorage localStorage;
    @Inject
    private TimeTracking timeTracking;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private Notifier notifier;
    @Inject
    private XpTrackerService xpTrackerService;
    private RandomEventAnalyticsPanel panel;
    private String profile;
    private int lastNotificationTick = -150;
    private NavigationButton navButton;

    @Provides
    RandomEventAnalyticsConfig provideConfig(ConfigManager configManager) {
        return (RandomEventAnalyticsConfig)configManager.getConfig(RandomEventAnalyticsConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.panel = (RandomEventAnalyticsPanel)((Object)this.injector.getInstance(RandomEventAnalyticsPanel.class));
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"random_event_analytics.png");
        this.navButton = NavigationButton.builder().tooltip("Random Event Analytics").icon(icon).panel((PluginPanel)this.panel).priority(7).build();
        this.clientToolbar.addNavigation(this.navButton);
        if (!this.isLoggedIn()) {
            return;
        }
        this.loadConfig();
        this.loadPreviousRandomEvents();
    }

    protected void shutDown() {
        this.persistTimeTrackingConfig();
        this.lastNotificationTick = 0;
        this.clientToolbar.removeNavigation(this.navButton);
        this.overlayManager.remove((Overlay)this.overlay);
    }

    private boolean isLoggedIn() {
        return this.client.getAccountHash() != -1L;
    }

    private void loadConfig() {
        this.profile = this.configManager.getRSProfileKey();
        this.timeTracking.init(Instant.now(), this.getLastRandomSpawnInstant());
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("randomeventanalytics")) {
            return;
        }
        this.panel.updateConfig();
        if (configChanged.getKey().equals("logTimeFormat")) {
            SwingUtilities.invokeLater(this.panel::updateAllRandomEventBoxes);
        }
    }

    @Subscribe
    public void onClientShutdown(ClientShutdown event) {
        this.persistTimeTrackingConfig();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState state = gameStateChanged.getGameState();
        if (state == GameState.LOGGED_IN) {
            long hash;
            if (this.timeTracking.getLoginTime() == null) {
                this.timeTracking.setLoginTime(Instant.now());
            }
            if (String.valueOf(hash = this.client.getAccountHash()).equalsIgnoreCase(this.localStorage.getUsername())) {
                return;
            }
            String username = this.client.getUsername();
            if (username != null && username.length() > 0) {
                this.localStorage.renameUsernameFolderToAccountHash(username, hash);
            }
            if (this.localStorage.setPlayerUsername(String.valueOf(hash))) {
                this.loadConfig();
                this.loadPreviousRandomEvents();
            }
        } else if (state == GameState.CONNECTION_LOST || state == GameState.UNKNOWN) {
            this.persistTimeTrackingConfig();
        } else if (state == GameState.HOPPING) {
            this.persistTimeTrackingConfig();
            this.timeTracking.setLoginTime(null);
        } else if (state == GameState.LOGIN_SCREEN) {
            this.persistTimeTrackingConfig();
            this.timeTracking.setLoginTime(null);
            this.panel.updateEstimation();
        }
    }

    private Instant getLastRandomSpawnInstant() {
        Instant spawned = this.getInstantFromProfileConfig("lastRandomSpawnInstant");
        if (spawned != null) {
            return spawned;
        }
        RandomEventRecord record = this.localStorage.getMostRecentRandom();
        if (record.spawnedTime < 0L) {
            return null;
        }
        return Instant.ofEpochMilli(record.spawnedTime);
    }

    private Instant getInstantFromProfileConfig(String key) {
        try {
            return (Instant)this.configManager.getConfiguration("randomeventanalytics", this.profile, key, Instant.class);
        }
        catch (NullPointerException e) {
            log.debug("No config loaded for: {}@{}", (Object)key, (Object)this.profile);
            return null;
        }
    }

    private synchronized void loadPreviousRandomEvents() {
        this.panel.clearAllRandomsView();
        ArrayList<RandomEventRecord> randomEvents = this.localStorage.loadRandomEventRecords();
        if (randomEvents.size() > 0) {
            randomEvents.forEach(this.panel::addRandom);
        } else {
            this.panel.clearAllRandomsView();
        }
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged event) {
        Actor source = event.getSource();
        Actor target = event.getTarget();
        Player player = this.client.getLocalPlayer();
        if (player == null || target != player || player.getInteracting() == source || !(source instanceof NPC) || !RandomEventAnalyticsUtil.getEventNpcIds().contains(((NPC)source).getId())) {
            return;
        }
        if (this.client.getTickCount() - this.lastNotificationTick > 150) {
            this.lastNotificationTick = this.client.getTickCount();
            this.handleRandomEvent((NPC)source);
        }
    }

    private void handleRandomEvent(NPC npc) {
        this.addRandomEvent(npc);
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        NPC npc = event.getNpc();
        if (!this.isStrangePlant(npc.getId())) {
            return;
        }
        Player player = this.client.getLocalPlayer();
        if (player.getWorldLocation().distanceTo(npc.getWorldLocation()) != 1) {
            return;
        }
        if (!this.timeTracking.isPossibleTimeForRandomEvent()) {
            return;
        }
        RandomEventRecord record = this.createRandomEventRecord(npc);
        this.panel.addUnconfirmedRandom(record);
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(PLANT_SPAWNED_NOTIFICATION_MESSAGE).build());
        this.notifier.notify(PLANT_SPAWNED_NOTIFICATION_MESSAGE);
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.panel.updateEstimation();
            this.timeTracking.onTick();
        }
    }

    private void persistTimeTrackingConfig() {
        this.timeTracking.persistConfig();
    }

    public void addRandomEvent(NPC npc) {
        this.addRandomEvent(this.createRandomEventRecord(npc));
    }

    public void addRandomEvent(RandomEventRecord record) {
        this.localStorage.addRandomEventRecord(record);
        this.panel.addRandom(record);
        if (this.isStrangePlant(record.npcInfoRecord.npcId)) {
            this.timeTracking.setStrangePlantSpawned(record);
        } else {
            this.timeTracking.setRandomEventSpawned();
        }
    }

    public int getNumberOfEventsLogged() {
        return this.localStorage.getNumberOfLoggedEvents();
    }

    private RandomEventRecord createRandomEventRecord(NPC npc) {
        Player player = this.client.getLocalPlayer();
        PlayerInfoRecord playerInfoRecord = PlayerInfoRecord.create(player);
        NpcInfoRecord npcInfoRecord = NpcInfoRecord.create(npc);
        XpInfoRecord xpInfoRecord = XpInfoRecord.create(this.client, this.xpTrackerService);
        RandomEventRecord record = new RandomEventRecord(Instant.now().toEpochMilli(), this.timeTracking, npcInfoRecord, playerInfoRecord, xpInfoRecord);
        return record;
    }

    private boolean isStrangePlant(int npcId) {
        return npcId == 323;
    }

    @Schedule(period=500L, unit=ChronoUnit.MILLIS)
    public void updateSchedule() {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.panel.updateEstimation();
        }
    }

    public void setPanel(RandomEventAnalyticsPanel panel) {
        this.panel = panel;
    }
}

