/*
 * Decompiled with CFR 0.152.
 */
package com.randomEventAnalytics;

import com.google.inject.Inject;
import com.randomEventAnalytics.RandomEventAnalyticsConfig;
import com.randomEventAnalytics.RandomEventAnalyticsPlugin;
import com.randomEventAnalytics.RandomEventAnalyticsUtil;
import com.randomEventAnalytics.RandomEventRecordBox;
import com.randomEventAnalytics.TimeFormat;
import com.randomEventAnalytics.TimeTracking;
import com.randomEventAnalytics.localstorage.RandomEventRecord;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.ProgressBar;
import net.runelite.client.util.ImageUtil;

public class RandomEventAnalyticsPanel
extends PluginPanel {
    private final ArrayList<RandomEventRecordBox> infoBoxes = new ArrayList();
    private final ProgressBar spawnTimeProgressBar = new ProgressBar();
    private final JPanel estimationPanel = new JPanel();
    private final JComponent eventPanel = new JPanel();
    private final RandomEventAnalyticsConfig config;
    private final Client client;
    private final JLabel estimationUntilNext = new JLabel(RandomEventAnalyticsUtil.htmlLabel("Next Event Window: ", "--:--"));
    private final JLabel countdownLabel = new JLabel(RandomEventAnalyticsUtil.htmlLabel("Next Event: ", "--:--"));
    private final JLabel numIntervals = new JLabel();
    private final JLabel inInstanceIcon = new JLabel("\u26a0");
    public SimpleDateFormat shortTimeFormat = new SimpleDateFormat("MMM dd, h:mm a");
    public SimpleDateFormat longTimeFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    TimeTracking timeTracking;
    RandomEventAnalyticsPlugin plugin;

    @Inject
    RandomEventAnalyticsPanel(RandomEventAnalyticsPlugin plugin, RandomEventAnalyticsConfig config, TimeTracking timeTracking, Client client) {
        this.timeTracking = timeTracking;
        this.plugin = plugin;
        this.config = config;
        this.client = client;
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        JPanel layoutPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(layoutPanel, 1);
        layoutPanel.setLayout(boxLayout);
        this.add(layoutPanel, "North");
        this.estimationPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.estimationPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.estimationPanel.setLayout(new BorderLayout());
        JPanel estimationInfo = new JPanel();
        estimationInfo.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        estimationInfo.setLayout(new GridLayout(3, 1));
        estimationInfo.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.estimationUntilNext.setFont(FontManager.getRunescapeSmallFont());
        this.countdownLabel.setFont(FontManager.getRunescapeSmallFont());
        this.numIntervals.setFont(FontManager.getRunescapeSmallFont());
        estimationInfo.add(new JLabel("Random Event Estimation"));
        estimationInfo.add(this.estimationUntilNext);
        estimationInfo.add(this.countdownLabel);
        this.estimationPanel.add((Component)new JLabel(new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"estimation_icon.png"))), "West");
        this.estimationPanel.add(estimationInfo);
        this.setupInInstanceIcon();
        this.estimationPanel.add((Component)this.inInstanceIcon, "East");
        JPanel progressWrapper = new JPanel();
        progressWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        progressWrapper.setBorder(new EmptyBorder(10, 0, 0, 0));
        progressWrapper.setLayout(new BorderLayout());
        this.spawnTimeProgressBar.setMaximumValue(300);
        this.spawnTimeProgressBar.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.spawnTimeProgressBar.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
        progressWrapper.add((Component)this.spawnTimeProgressBar);
        this.estimationPanel.add((Component)progressWrapper, "South");
        layoutPanel.add(this.estimationPanel);
        this.eventPanel.setLayout(new BoxLayout(this.eventPanel, 1));
        this.eventPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        layoutPanel.add((Component)this.eventPanel, "South");
        this.updateConfig();
    }

    private void setupInInstanceIcon() {
        this.inInstanceIcon.setVisible(false);
        this.inInstanceIcon.setFont(new Font("Dialog", 0, 12));
        this.inInstanceIcon.setForeground(Color.RED);
        this.inInstanceIcon.setToolTipText("You are currently in an instance where random events may not spawn.");
    }

    public void eventRecordBoxUpdated(RandomEventRecordBox randomEventRecordBox, boolean isConfirmed) {
        this.eventPanel.remove(randomEventRecordBox);
        if (isConfirmed) {
            this.plugin.addRandomEvent(randomEventRecordBox.getRandomEvent());
        }
        this.infoBoxes.remove(randomEventRecordBox);
        this.eventPanel.revalidate();
        this.eventPanel.repaint();
    }

    public void clearAllRandomsView() {
        this.eventPanel.removeAll();
        this.infoBoxes.clear();
        this.eventPanel.repaint();
    }

    public void addRandom(RandomEventRecord record) {
        SwingUtilities.invokeLater(() -> {
            RandomEventRecordBox recordBox = new RandomEventRecordBox(this, record);
            this.eventPanel.add((Component)recordBox, 0);
            this.infoBoxes.add(recordBox);
        });
    }

    public void addUnconfirmedRandom(RandomEventRecord record) {
        SwingUtilities.invokeLater(() -> {
            RandomEventRecordBox recordBox = new RandomEventRecordBox(this, record, false);
            this.eventPanel.add((Component)recordBox, 0);
            this.infoBoxes.add(recordBox);
        });
    }

    public void updateConfig() {
        this.spawnTimeProgressBar.setVisible(this.config.enableEstimation());
        this.estimationUntilNext.setVisible(this.config.enableEstimation());
        this.countdownLabel.setVisible(this.config.enableConfigCountdown());
        if (this.config.timeFormatMode() == TimeFormat.TIME_12H) {
            this.shortTimeFormat = new SimpleDateFormat("MMM dd, h:mm a");
            this.longTimeFormat = new SimpleDateFormat("yyyy-MM-dd h:mm:ss a");
        } else {
            this.shortTimeFormat = new SimpleDateFormat("MMM dd, HH:mm");
            this.longTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    }

    public void updateAllRandomEventBoxes() {
        this.infoBoxes.forEach(RandomEventRecordBox::update);
    }

    public void updateEstimation() {
        if (!this.config.enableEstimation() && !this.config.enableConfigCountdown()) {
            return;
        }
        this.spawnTimeProgressBar.setValue(Math.abs(300 - this.timeTracking.getNextRandomEventEstimation()));
        SwingUtilities.invokeLater(() -> {
            int estimatedSeconds = this.timeTracking.getNextRandomEventEstimation();
            this.inInstanceIcon.setVisible(this.client.isInInstancedRegion());
            this.estimationUntilNext.setText(RandomEventAnalyticsUtil.htmlLabel("Next Event Window: ", RandomEventAnalyticsUtil.formatSeconds(Math.abs(estimatedSeconds))));
            this.estimationUntilNext.setToolTipText("Intervals: " + this.timeTracking.getIntervalsSinceLastRandom());
            this.countdownLabel.setText(RandomEventAnalyticsUtil.htmlLabel("Next Event: ", RandomEventAnalyticsUtil.formatSeconds(Math.abs(this.timeTracking.getCountdownSeconds(this.config.countdownMinutes())))));
        });
    }

    public JComponent getEventPanel() {
        return this.eventPanel;
    }
}

