/*
 * Decompiled with CFR 0.152.
 */
package com.randomEventAnalytics;

import com.randomEventAnalytics.RandomEventAnalyticsConfig;
import com.randomEventAnalytics.RandomEventAnalyticsPlugin;
import com.randomEventAnalytics.RandomEventAnalyticsUtil;
import com.randomEventAnalytics.TimeTracking;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;

public class RandomEventAnalyticsOverlay
extends Overlay {
    private static final String TIME_UNTIL_LABEL = "Estimate: ";
    private static final String OVERESTIMATE_LABEL = "Overestimate: ";
    private static final String TITLE_LABEL = "Random Event";
    private final RandomEventAnalyticsConfig config;
    private final PanelComponent panelComponent = new PanelComponent();
    private final TimeTracking timeTracking;
    private final RandomEventAnalyticsPlugin plugin;

    @Inject
    private RandomEventAnalyticsOverlay(RandomEventAnalyticsConfig config, TimeTracking timeTracking, RandomEventAnalyticsPlugin plugin) {
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.config = config;
        this.timeTracking = timeTracking;
        this.plugin = plugin;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.enableOverlay()) {
            return null;
        }
        this.panelComponent.getChildren().clear();
        if (this.config.enableEstimation()) {
            int closestSpawnTimer = this.timeTracking.getNextRandomEventEstimation();
            this.panelComponent.getChildren().add(LineComponent.builder().left(this.timeTracking.hasLoggedInLongEnoughForSpawn() ? "Random Event Eligible In" : "Initial login countdown...").right(RandomEventAnalyticsUtil.formatSeconds(Math.abs(closestSpawnTimer))).build());
        }
        if (this.config.enableConfigCountdown()) {
            int estimatedSeconds = this.timeTracking.getCountdownSeconds(this.config.countdownMinutes());
            this.panelComponent.getChildren().add(LineComponent.builder().left(estimatedSeconds >= 0 ? TIME_UNTIL_LABEL : OVERESTIMATE_LABEL).right(RandomEventAnalyticsUtil.formatSeconds(Math.abs(estimatedSeconds))).build());
        }
        if (this.config.showDebug()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Ticks: ").right(String.valueOf(this.timeTracking.getTicksSinceLastRandomEvent())).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("Intervals: ").right(String.valueOf(this.timeTracking.getIntervalsSinceLastRandom())).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("# of Events Logged: ").right(String.valueOf(this.plugin.getNumberOfEventsLogged())).build());
        }
        return this.panelComponent.render(graphics);
    }
}

