/*
 * Decompiled with CFR 0.152.
 */
package com.randomEventAnalytics;

import com.randomEventAnalytics.TimeFormat;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;

@ConfigGroup(value="randomeventanalytics")
public interface RandomEventAnalyticsConfig
extends Config {
    public static final String CONFIG_GROUP = "randomeventanalytics";
    public static final String SECONDS_SINCE_LAST_RANDOM = "secondsSinceLastRandom";
    public static final String TICKS_SINCE_LAST_RANDOM = "ticksSinceLastRandom";
    public static final String SECONDS_IN_INSTANCE = "secondsInInstance";
    public static final String LAST_RANDOM_SPAWN_INSTANT = "lastRandomSpawnInstant";
    public static final String INTERVALS_SINCE_LAST_RANDOM = "intervalsSinceLastRandom";
    @ConfigSection(name="Countdown", description="Logged-in countdown configuration", position=1, closedByDefault=false)
    public static final String countdownSection = "countdown";
    @ConfigSection(name="Logging Panel", description="Settings related to the logging panel", position=2, closedByDefault=false)
    public static final String loggingPanelSection = "loggingPanelSection";
    @ConfigSection(name="Experimental", description="Experimental features. May have a negative impact on performance.", position=3, closedByDefault=true)
    public static final String experimentalSection = "experimental";

    @ConfigItem(keyName="enableEstimation", name="Enable Estimation", description="Shows a 5 minute sliding timer for events.")
    default public boolean enableEstimation() {
        return true;
    }

    @ConfigItem(keyName="enableOverlay", name="Enable Overlay", description="Show the Random Events overlay.")
    default public boolean enableOverlay() {
        return false;
    }

    @ConfigItem(keyName="enableConfigCountdown", name="Enable Countdown", description="Enables the time since last random countdown", section="countdown")
    default public boolean enableConfigCountdown() {
        return true;
    }

    @ConfigItem(keyName="logTimeFormat", name="Time Format", description="Configures time between 12 or 24 hour time format", section="loggingPanelSection")
    default public TimeFormat timeFormatMode() {
        return TimeFormat.TIME_24H;
    }

    @Range(min=1)
    @ConfigItem(keyName="countdownMinutes", name="Countdown (Minutes)", description="Number of minutes the countdown should last", section="countdown")
    default public int countdownMinutes() {
        return 60;
    }

    @ConfigItem(keyName="showDebug", name="Show Debug", description="Shows debug information in the overlay.", section="experimental")
    default public boolean showDebug() {
        return false;
    }
}

