/*
 * Decompiled with CFR 0.152.
 */
package com.SelfHealingNotifications;

import com.SelfHealingNotifications.SelfHealingNotificationsConfig;
import com.google.inject.Provides;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.events.StatChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Self Healing Notifications", description="Shows self healing including regen to the player")
public class SelfHealingNotificationsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SelfHealingNotificationsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private SelfHealingNotificationsConfig SelfHealingNotificationsconfig;
    @Inject
    private ConfigManager configManager;
    private final int[] lastSkillLevels = new int[Skill.values().length - 1];

    @Provides
    SelfHealingNotificationsConfig provideConfig(ConfigManager configManager) {
        return (SelfHealingNotificationsConfig)configManager.getConfig(SelfHealingNotificationsConfig.class);
    }

    protected void startUp() throws Exception {
        Arrays.fill(this.lastSkillLevels, 126);
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        Player player = this.client.getLocalPlayer();
        Skill skill = statChanged.getSkill();
        int ignoreRegen = this.SelfHealingNotificationsconfig.ignoreRegen();
        if (skill != Skill.HITPOINTS) {
            return;
        }
        int skillIdx = skill.ordinal();
        int last = this.lastSkillLevels[skillIdx];
        int cur = this.client.getBoostedSkillLevel(skill);
        int dif = cur - last;
        if (cur > last && dif > ignoreRegen) {
            SelfHealingNotificationsConfig.SendToChar sendToChar = this.SelfHealingNotificationsconfig.sendToChar();
            this.SelfHealingNotificationsconfig.sendToChar();
            if (sendToChar == SelfHealingNotificationsConfig.SendToChar.Default) {
                player.setOverheadText("You just healed for " + String.valueOf(dif) + " health.");
                player.setOverheadCycle(120);
            }
            SelfHealingNotificationsConfig.SendToChar sendToChar2 = this.SelfHealingNotificationsconfig.sendToChar();
            this.SelfHealingNotificationsconfig.sendToChar();
            if (sendToChar2 == SelfHealingNotificationsConfig.SendToChar.Simple) {
                player.setOverheadText("+" + String.valueOf(dif));
                player.setOverheadCycle(120);
            }
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "You just healed for " + String.valueOf(dif) + " health.", null);
        }
        this.lastSkillLevels[skillIdx] = cur;
    }

    public int[] getLastSkillLevels() {
        return this.lastSkillLevels;
    }
}

