/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.util;

import com.google.common.collect.ImmutableSet;
import dinkplugin.domain.AccountType;
import dinkplugin.util.Utils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.WorldType;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;
import org.jetbrains.annotations.VisibleForTesting;

public final class WorldUtils {
    private static final Set<WorldType> IGNORED_WORLDS = EnumSet.of(WorldType.PVP_ARENA, WorldType.QUEST_SPEEDRUNNING, WorldType.BETA_WORLD, WorldType.NOSAVE_MODE, WorldType.TOURNAMENT_WORLD);
    private static final Set<Integer> BA_REGIONS = ImmutableSet.of((Object)7508, (Object)7509, (Object)10322);
    private static final Set<Integer> CASTLE_WARS_REGIONS = ImmutableSet.of((Object)9520, (Object)9620);
    private static final Set<Integer> CLAN_WARS_REGIONS = ImmutableSet.of((Object)12621, (Object)12622, (Object)12623, (Object)13130, (Object)13131, (Object)13133, (Object[])new Integer[]{13134, 13135, 13386, 13387, 13390, 13641, 13642, 13643, 13644, 13645, 13646, 13647, 13899, 13900, 14155, 14156});
    private static final Set<Integer> COX_REGIONS = ImmutableSet.of((Object)12889, (Object)13136, (Object)13137, (Object)13138, (Object)13139, (Object)13140, (Object[])new Integer[]{13141, 13145, 13393, 13394, 13395, 13396, 13397, 13401});
    private static final Set<Integer> GALVEK_REGIONS = ImmutableSet.of((Object)6486, (Object)6487, (Object)6488, (Object)6489, (Object)6742, (Object)6743, (Object[])new Integer[]{6744, 6745});
    private static final Set<Integer> GAUNTLET_REGIONS = ImmutableSet.of((Object)7512, (Object)7768, (Object)12127);
    private static final Set<Integer> LMS_REGIONS = ImmutableSet.of((Object)13658, (Object)13659, (Object)13660, (Object)13914, (Object)13915, (Object)13916, (Object[])new Integer[]{13918, 13919, 13920, 14174, 14175, 14176, 14430, 14431, 14432});
    private static final Set<Integer> POH_REGIONS = ImmutableSet.of((Object)7257, (Object)7513, (Object)7514, (Object)7769, (Object)7770, (Object)8025, (Object[])new Integer[]{8026});
    private static final Set<Integer> SOUL_REGIONS = ImmutableSet.of((Object)8493, (Object)8748, (Object)8749, (Object)9005);
    private static final Set<Integer> TOA_REGIONS = ImmutableSet.of((Object)14160, (Object)14162, (Object)14164, (Object)14674, (Object)14676, (Object)15184, (Object[])new Integer[]{15186, 15188, 15696, 15698, 15700});
    private static final int BURTHORPE_REGION = 8781;
    private static final int INFERNO_REGION = 9043;
    private static final int NMZ_REGION = 9033;
    private static final int TZHAAR_CAVE = 9551;
    @VisibleForTesting
    public static final int TZHAAR_PIT = 9552;
    private static final int DRAGON_SLAYER_II_PROGRESS = 6104;
    private static final int DRAGON_SLAYER_II_COMPLETED = 215;

    public static WorldPoint getLocation(Client client) {
        return WorldUtils.getLocation(client, (Actor)client.getLocalPlayer());
    }

    public static WorldPoint getLocation(Client client, Actor actor) {
        if (client.isInInstancedRegion()) {
            return WorldPoint.fromLocalInstance((Client)client, (LocalPoint)actor.getLocalLocation());
        }
        return actor.getWorldLocation();
    }

    public static boolean isIgnoredWorld(Set<WorldType> worldType) {
        return !Collections.disjoint(IGNORED_WORLDS, worldType);
    }

    public static boolean isPvpWorld(Set<WorldType> worldType) {
        return worldType.contains(WorldType.PVP) || worldType.contains(WorldType.DEADMAN);
    }

    public static boolean isPvpSafeZone(Client client) {
        Widget widget = client.getWidget(5898287);
        return widget != null && !widget.isHidden();
    }

    public static boolean isBarbarianAssault(int regionId) {
        return BA_REGIONS.contains(regionId);
    }

    public static boolean isBurthorpeGameRoom(int regionId) {
        return regionId == 8781;
    }

    public static boolean isCastleWars(int regionId) {
        return CASTLE_WARS_REGIONS.contains(regionId);
    }

    public static boolean isChambersOfXeric(int regionId) {
        return COX_REGIONS.contains(regionId);
    }

    public static boolean isClanWars(int regionId) {
        return CLAN_WARS_REGIONS.contains(regionId);
    }

    public static boolean isGalvekRematch(Client client, int regionId) {
        return GALVEK_REGIONS.contains(regionId) && client.getVarbitValue(6104) >= 215;
    }

    public static boolean isGauntlet(int regionId) {
        return GAUNTLET_REGIONS.contains(regionId);
    }

    public static boolean isInferno(int regionId) {
        return regionId == 9043;
    }

    public static boolean isLastManStanding(Client client) {
        if (LMS_REGIONS.contains(WorldUtils.getLocation(client).getRegionID())) {
            return true;
        }
        Widget widget = client.getWidget(21495812);
        return widget != null && !widget.isHidden();
    }

    public static boolean isNightmareZone(int regionId) {
        return regionId == 9033;
    }

    public static boolean isPestControl(Client client) {
        Widget widget = client.getWidget(26738702);
        return widget != null && !widget.isHidden();
    }

    public static boolean isPlayerOwnedHouse(int regionId) {
        return POH_REGIONS.contains(regionId);
    }

    public static boolean isSafeArea(Client client) {
        int regionId = WorldUtils.getLocation(client).getRegionID();
        if (WorldUtils.isAmascutTombs(regionId)) {
            return !Utils.getAccountType(client).isHardcore();
        }
        if (WorldUtils.isGauntlet(regionId)) {
            return !Utils.getAccountType(client).isHardcore();
        }
        if (WorldUtils.isBarbarianAssault(regionId) || WorldUtils.isChambersOfXeric(regionId) || WorldUtils.isInferno(regionId) || WorldUtils.isNightmareZone(regionId) || WorldUtils.isTzHaarFightCave(regionId) || WorldUtils.isPestControl(client) || WorldUtils.isGalvekRematch(client, regionId)) {
            return Utils.getAccountType(client) != AccountType.HARDCORE_GROUP_IRONMAN;
        }
        return WorldUtils.isCastleWars(regionId) || WorldUtils.isClanWars(regionId) || WorldUtils.isSoulWars(regionId) || WorldUtils.isPlayerOwnedHouse(regionId) || WorldUtils.isLastManStanding(client) || WorldUtils.isTzHaarFightPit(regionId);
    }

    public static boolean isSoulWars(int regionId) {
        return SOUL_REGIONS.contains(regionId);
    }

    public static boolean isAmascutTombs(int regionId) {
        return TOA_REGIONS.contains(regionId);
    }

    public static boolean isTzHaarFightCave(int regionId) {
        return regionId == 9551;
    }

    public static boolean isTzHaarFightPit(int regionId) {
        return regionId == 9552;
    }

    private WorldUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

