/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.util;

import com.google.common.hash.HashCode;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import dinkplugin.domain.AccountType;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    public static final String WIKI_IMG_BASE_URL = "https://oldschool.runescape.wiki/images/";
    public static final Color GREEN = ColorUtil.fromHex((String)"006c4c");
    public static final Color PINK = ColorUtil.fromHex((String)"#f40098");
    public static final Color RED = ColorUtil.fromHex((String)"#ca2a2d");
    private static final char ELLIPSIS = '\u2026';
    private static final byte[] DINK_HASH_PADDING = "JennaRaidingDreamSeedZeroPercentOptionsForAnts!".getBytes(StandardCharsets.UTF_8);

    public static String truncate(String text, int maxLength) {
        if (text.length() <= maxLength) {
            return text;
        }
        int lastSpace = text.lastIndexOf(32, maxLength - 1);
        if (lastSpace <= 0) {
            return text.substring(0, maxLength - 1) + "\u2026";
        }
        return text.substring(0, lastSpace) + "\u2026";
    }

    public static String sanitize(String str) {
        if (str == null || str.isEmpty()) {
            return "";
        }
        return Text.removeTags((String)str.replace("<br>", "\n")).replace('\u00a0', ' ').trim();
    }

    public static String ucFirst(@NotNull String text) {
        if (text.length() < 2) {
            return text.toUpperCase();
        }
        return Character.toUpperCase(text.charAt(0)) + text.substring(1).toLowerCase();
    }

    public static Pattern regexify(@NotNull String pattern) {
        int i;
        int len = pattern.length();
        StringBuilder sb = new StringBuilder(len + 2 + 4);
        int startIndex = 0;
        if (!pattern.startsWith("*")) {
            sb.append('^');
        } else {
            ++startIndex;
        }
        while ((i = pattern.indexOf(42, startIndex)) >= 0) {
            String section = pattern.substring(startIndex, i);
            sb.append(Pattern.quote(section));
            sb.append(".*");
            startIndex = i + 1;
        }
        if (startIndex < len) {
            sb.append(Pattern.quote(pattern.substring(startIndex)));
            sb.append('$');
        }
        return Pattern.compile(sb.toString(), 2);
    }

    public static boolean containsEither(@NotNull String a, @NotNull String b) {
        if (a.length() >= b.length()) {
            return a.contains(b);
        }
        return b.contains(a);
    }

    public static String getPlayerName(Client client) {
        return client.getLocalPlayer().getName();
    }

    public static AccountType getAccountType(@NotNull Client client) {
        return AccountType.get(client.getVarbitValue(1777));
    }

    @Nullable
    public static String getChatBadge(@NotNull AccountType type, boolean seasonal) {
        if (seasonal) {
            return "https://oldschool.runescape.wiki/images/Leagues_chat_badge.png";
        }
        switch (type) {
            case IRONMAN: {
                return "https://oldschool.runescape.wiki/images/Ironman_chat_badge.png";
            }
            case ULTIMATE_IRONMAN: {
                return "https://oldschool.runescape.wiki/images/Ultimate_ironman_chat_badge.png";
            }
            case HARDCORE_IRONMAN: {
                return "https://oldschool.runescape.wiki/images/Hardcore_ironman_chat_badge.png";
            }
            case GROUP_IRONMAN: {
                return "https://oldschool.runescape.wiki/images/Group_ironman_chat_badge.png";
            }
            case HARDCORE_GROUP_IRONMAN: {
                return "https://oldschool.runescape.wiki/images/Hardcore_group_ironman_chat_badge.png";
            }
            case UNRANKED_GROUP_IRONMAN: {
                return "https://oldschool.runescape.wiki/images/Unranked_group_ironman_chat_badge.png";
            }
        }
        return null;
    }

    public static int packWidget(int groupId, int childId) {
        return groupId << 16 | childId;
    }

    public static BufferedImage rescale(BufferedImage input, double percent) {
        if (percent + Math.ulp(1.0) >= 1.0) {
            return input;
        }
        AffineTransform rescale = AffineTransform.getScaleInstance(percent, percent);
        AffineTransformOp operation = new AffineTransformOp(rescale, 1);
        BufferedImage output = new BufferedImage((int)((double)input.getWidth() * percent), (int)((double)input.getHeight() * percent), input.getType());
        operation.filter(input, output);
        return output;
    }

    public static byte[] convertImageToByteArray(BufferedImage bufferedImage, String format) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean foundWriter = ImageIO.write((RenderedImage)bufferedImage, format, byteArrayOutputStream);
        if (!foundWriter) {
            throw new IllegalArgumentException(String.format("Specified format '%s' was not in supported formats: %s", format, Arrays.toString(ImageIO.getWriterFormatNames())));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static boolean hasImage(@NotNull MultipartBody body) {
        return body.parts().stream().anyMatch(part -> {
            MediaType type = part.body().contentType();
            return type != null && "image".equals(type.type());
        });
    }

    public static CompletableFuture<String> readClipboard() {
        CompletableFuture<String> future = new CompletableFuture<String>();
        SwingUtilities.invokeLater(() -> {
            try {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                String data = (String)clipboard.getData(DataFlavor.stringFlavor);
                future.complete(data);
            }
            catch (Exception e) {
                log.warn("Failed to read from clipboard", (Throwable)e);
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public static CompletableFuture<Void> copyToClipboard(String text) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        SwingUtilities.invokeLater(() -> {
            try {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection content = new StringSelection(text);
                clipboard.setContents(content, content);
                future.complete(null);
            }
            catch (Exception e) {
                log.warn("Failed to copy to clipboard", (Throwable)e);
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public static <T> CompletableFuture<T> readJson(@NotNull OkHttpClient httpClient, @NotNull Gson gson, @NotNull String url, @NotNull TypeToken<T> type) {
        return Utils.readUrl(httpClient, url, reader -> gson.fromJson(reader, type.getType()));
    }

    public static <T> CompletableFuture<T> readUrl(@NotNull OkHttpClient httpClient, @NotNull String url, final @NotNull Function<Reader, T> transformer) {
        final CompletableFuture future = new CompletableFuture();
        Request request = new Request.Builder().url(url).build();
        httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) {
                assert (response.body() != null);
                try (Reader reader = response.body().charStream();){
                    future.complete(transformer.apply(reader));
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
                finally {
                    response.close();
                }
            }
        });
        return future;
    }

    public static String dinkHash(long l) {
        MessageDigest hash;
        try {
            hash = MessageDigest.getInstance("SHA-224");
        }
        catch (NoSuchAlgorithmException e) {
            log.warn("Account hash will not be included in notification metadata", (Throwable)e);
            return null;
        }
        byte[] input = ByteBuffer.allocate(8 + DINK_HASH_PADDING.length).putLong(l).put(DINK_HASH_PADDING).array();
        return HashCode.fromBytes((byte[])hash.digest(input)).toString();
    }

    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

