/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import dinkplugin.util.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ItemSearcher {
    private static final Logger log = LoggerFactory.getLogger(ItemSearcher.class);
    private final Map<String, Integer> itemIdByName = Collections.synchronizedMap(new HashMap(16384));
    @Inject
    private OkHttpClient httpClient;
    @Inject
    private Gson gson;

    @Nullable
    public Integer findItemId(@NotNull String name) {
        return this.itemIdByName.get(name);
    }

    @Inject
    void init() {
        ((CompletableFuture)this.queryNamesById().thenAcceptBothAsync(this.queryNotedItemIds().exceptionally(e -> {
            log.error("Failed to read noted items", e);
            return Collections.emptySet();
        }), this::populate)).exceptionally(e -> {
            log.error("Failed to read item names", e);
            return null;
        });
    }

    @VisibleForTesting
    void populate(@NotNull Map<Integer, String> namesById, @NotNull Set<Integer> notedIds) {
        namesById.forEach((id, name) -> {
            if (!notedIds.contains(id)) {
                this.itemIdByName.putIfAbsent((String)name, (Integer)id);
            }
        });
        log.debug("Completed initialization of item cache with {} entries", (Object)this.itemIdByName.size());
    }

    private CompletableFuture<Map<Integer, String>> queryNamesById() {
        return this.queryCache("names.json", new TypeToken<Map<Integer, String>>(){});
    }

    private CompletableFuture<Set<Integer>> queryNotedItemIds() {
        return this.queryCache("notes.json", new TypeToken<Map<Integer, Integer>>(){}).thenApply(Map::keySet);
    }

    private <T> CompletableFuture<T> queryCache(@NotNull String fileName, @NotNull TypeToken<T> type) {
        return Utils.readJson(this.httpClient, this.gson, "https://static.runelite.net/cache/item/" + fileName, type);
    }
}

