/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.util;

import java.awt.Color;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.client.util.ColorUtil;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigUtil {
    private static final Pattern DELIM = Pattern.compile("[,;\\n]");

    public static Stream<String> readDelimited(String value) {
        if (value == null) {
            return Stream.empty();
        }
        return DELIM.splitAsStream(value).map(String::trim).filter(StringUtils::isNotEmpty);
    }

    @Nullable
    public static Object convertTypeFromJson(@NotNull Type type, @NotNull Object in) {
        if (in instanceof Boolean) {
            return type == Boolean.TYPE || type == Boolean.class ? in : null;
        }
        if (in instanceof Number) {
            Number n = (Number)in;
            if (type == Integer.TYPE || type == Integer.class) {
                return n.intValue();
            }
            if (type == Long.TYPE || type == Long.class) {
                return n.longValue();
            }
            if (type == Float.TYPE || type == Float.class) {
                return Float.valueOf(n.floatValue());
            }
            if (type == Double.TYPE || type == Double.class) {
                return n.doubleValue();
            }
            if (type == Byte.TYPE || type == Byte.class) {
                return n.byteValue();
            }
            if (type == Short.TYPE || type == Short.class) {
                return n.shortValue();
            }
            if (type == Instant.class) {
                return Instant.ofEpochMilli(n.longValue());
            }
            if (type == Duration.class) {
                return Duration.ofMillis(n.longValue());
            }
            return null;
        }
        if (in instanceof String) {
            String s = (String)in;
            if (type == String.class) {
                return s;
            }
            if (type == Color.class) {
                return ColorUtil.fromString((String)s);
            }
            if (type instanceof Class && ((Class)type).isEnum()) {
                try {
                    return Enum.valueOf((Class)type, s);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (type == Instant.class) {
                try {
                    return Instant.parse(s);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (type == Duration.class) {
                try {
                    return Duration.parse(s);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }

    public static boolean isSettingsOpen(@NotNull Client client) {
        Widget widget = client.getWidget(8781825);
        return widget != null && !widget.isHidden();
    }

    public static boolean isKillCountFilterInvalid(int varbitValue) {
        return varbitValue > 0;
    }

    public static boolean isCollectionLogInvalid(int varbitValue) {
        return varbitValue == 0;
    }

    public static boolean isRepeatPopupInvalid(int varbitValue) {
        return varbitValue > 0;
    }

    public static boolean isPetLootInvalid(int varbitValue) {
        return varbitValue < 1;
    }

    private ConfigUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

