/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers.data;

import dinkplugin.message.Field;
import dinkplugin.notifiers.data.NotificationData;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;

public final class LevelNotificationData
extends NotificationData {
    private final Map<String, Integer> levelledSkills;
    private final Map<String, Integer> allSkills;
    private final CombatLevel combatLevel;

    @Override
    public List<Field> getFields() {
        if (this.levelledSkills.containsValue(99)) {
            return Collections.singletonList(new Field("Total Skills at Level 99+", this.collectMaxedSkills(99)));
        }
        if (this.levelledSkills.containsValue(127)) {
            return Collections.singletonList(new Field("Total Skills at Max XP", this.collectMaxedSkills(127)));
        }
        return super.getFields();
    }

    private String collectMaxedSkills(int minLevel) {
        Collection maxed = this.allSkills.entrySet().stream().filter(e -> (Integer)e.getValue() >= minLevel).map(Map.Entry::getKey).collect(Collectors.toCollection(TreeSet::new));
        return Field.formatBlock("", maxed.size() + ": " + String.join((CharSequence)", ", maxed));
    }

    public LevelNotificationData(Map<String, Integer> levelledSkills, Map<String, Integer> allSkills, CombatLevel combatLevel) {
        this.levelledSkills = levelledSkills;
        this.allSkills = allSkills;
        this.combatLevel = combatLevel;
    }

    public Map<String, Integer> getLevelledSkills() {
        return this.levelledSkills;
    }

    public Map<String, Integer> getAllSkills() {
        return this.allSkills;
    }

    public CombatLevel getCombatLevel() {
        return this.combatLevel;
    }

    public String toString() {
        return "LevelNotificationData(levelledSkills=" + this.getLevelledSkills() + ", allSkills=" + this.getAllSkills() + ", combatLevel=" + this.getCombatLevel() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LevelNotificationData)) {
            return false;
        }
        LevelNotificationData other = (LevelNotificationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Integer> this$levelledSkills = this.getLevelledSkills();
        Map<String, Integer> other$levelledSkills = other.getLevelledSkills();
        if (this$levelledSkills == null ? other$levelledSkills != null : !((Object)this$levelledSkills).equals(other$levelledSkills)) {
            return false;
        }
        Map<String, Integer> this$allSkills = this.getAllSkills();
        Map<String, Integer> other$allSkills = other.getAllSkills();
        if (this$allSkills == null ? other$allSkills != null : !((Object)this$allSkills).equals(other$allSkills)) {
            return false;
        }
        CombatLevel this$combatLevel = this.getCombatLevel();
        CombatLevel other$combatLevel = other.getCombatLevel();
        return !(this$combatLevel == null ? other$combatLevel != null : !((Object)this$combatLevel).equals(other$combatLevel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LevelNotificationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Integer> $levelledSkills = this.getLevelledSkills();
        result = result * 59 + ($levelledSkills == null ? 43 : ((Object)$levelledSkills).hashCode());
        Map<String, Integer> $allSkills = this.getAllSkills();
        result = result * 59 + ($allSkills == null ? 43 : ((Object)$allSkills).hashCode());
        CombatLevel $combatLevel = this.getCombatLevel();
        result = result * 59 + ($combatLevel == null ? 43 : ((Object)$combatLevel).hashCode());
        return result;
    }

    public static final class CombatLevel {
        private final int value;
        private final Boolean increased;

        public CombatLevel(int value, Boolean increased) {
            this.value = value;
            this.increased = increased;
        }

        public int getValue() {
            return this.value;
        }

        public Boolean getIncreased() {
            return this.increased;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CombatLevel)) {
                return false;
            }
            CombatLevel other = (CombatLevel)o;
            if (this.getValue() != other.getValue()) {
                return false;
            }
            Boolean this$increased = this.getIncreased();
            Boolean other$increased = other.getIncreased();
            return !(this$increased == null ? other$increased != null : !((Object)this$increased).equals(other$increased));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getValue();
            Boolean $increased = this.getIncreased();
            result = result * 59 + ($increased == null ? 43 : ((Object)$increased).hashCode());
            return result;
        }

        public String toString() {
            return "LevelNotificationData.CombatLevel(value=" + this.getValue() + ", increased=" + this.getIncreased() + ")";
        }
    }
}

