/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers.data;

import dinkplugin.message.Field;
import dinkplugin.notifiers.data.NotificationData;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LeaguesRelicNotificationData
extends NotificationData {
    @NotNull
    private final String relic;
    private final Integer tier;
    private final Integer requiredPoints;
    private final int totalPoints;
    @Nullable
    private final Integer pointsUntilNextTier;

    @Override
    public List<Field> getFields() {
        ArrayList<Field> fields = new ArrayList<Field>(2);
        fields.add(new Field("Total Points", Field.formatBlock("", String.valueOf(this.totalPoints))));
        if (this.pointsUntilNextTier != null) {
            fields.add(new Field("Points until next Relic", Field.formatBlock("", String.valueOf(this.pointsUntilNextTier))));
        }
        return fields;
    }

    public LeaguesRelicNotificationData(@NotNull String relic, Integer tier, Integer requiredPoints, int totalPoints, @Nullable Integer pointsUntilNextTier) {
        if (relic == null) {
            throw new NullPointerException("relic is marked non-null but is null");
        }
        this.relic = relic;
        this.tier = tier;
        this.requiredPoints = requiredPoints;
        this.totalPoints = totalPoints;
        this.pointsUntilNextTier = pointsUntilNextTier;
    }

    @NotNull
    public String getRelic() {
        return this.relic;
    }

    public Integer getTier() {
        return this.tier;
    }

    public Integer getRequiredPoints() {
        return this.requiredPoints;
    }

    public int getTotalPoints() {
        return this.totalPoints;
    }

    @Nullable
    public Integer getPointsUntilNextTier() {
        return this.pointsUntilNextTier;
    }

    public String toString() {
        return "LeaguesRelicNotificationData(relic=" + this.getRelic() + ", tier=" + this.getTier() + ", requiredPoints=" + this.getRequiredPoints() + ", totalPoints=" + this.getTotalPoints() + ", pointsUntilNextTier=" + this.getPointsUntilNextTier() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeaguesRelicNotificationData)) {
            return false;
        }
        LeaguesRelicNotificationData other = (LeaguesRelicNotificationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalPoints() != other.getTotalPoints()) {
            return false;
        }
        Integer this$tier = this.getTier();
        Integer other$tier = other.getTier();
        if (this$tier == null ? other$tier != null : !((Object)this$tier).equals(other$tier)) {
            return false;
        }
        Integer this$requiredPoints = this.getRequiredPoints();
        Integer other$requiredPoints = other.getRequiredPoints();
        if (this$requiredPoints == null ? other$requiredPoints != null : !((Object)this$requiredPoints).equals(other$requiredPoints)) {
            return false;
        }
        Integer this$pointsUntilNextTier = this.getPointsUntilNextTier();
        Integer other$pointsUntilNextTier = other.getPointsUntilNextTier();
        if (this$pointsUntilNextTier == null ? other$pointsUntilNextTier != null : !((Object)this$pointsUntilNextTier).equals(other$pointsUntilNextTier)) {
            return false;
        }
        String this$relic = this.getRelic();
        String other$relic = other.getRelic();
        return !(this$relic == null ? other$relic != null : !this$relic.equals(other$relic));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LeaguesRelicNotificationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalPoints();
        Integer $tier = this.getTier();
        result = result * 59 + ($tier == null ? 43 : ((Object)$tier).hashCode());
        Integer $requiredPoints = this.getRequiredPoints();
        result = result * 59 + ($requiredPoints == null ? 43 : ((Object)$requiredPoints).hashCode());
        Integer $pointsUntilNextTier = this.getPointsUntilNextTier();
        result = result * 59 + ($pointsUntilNextTier == null ? 43 : ((Object)$pointsUntilNextTier).hashCode());
        String $relic = this.getRelic();
        result = result * 59 + ($relic == null ? 43 : $relic.hashCode());
        return result;
    }
}

