/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers.data;

import dinkplugin.message.Field;
import dinkplugin.notifiers.data.NotificationData;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LeaguesAreaNotificationData
extends NotificationData {
    @NotNull
    private final String area;
    private final int index;
    private final int tasksCompleted;
    @Nullable
    private final Integer tasksUntilNextArea;

    @Override
    public List<Field> getFields() {
        ArrayList<Field> fields = new ArrayList<Field>(2);
        fields.add(new Field("Tasks Completed", Field.formatBlock("", String.valueOf(this.tasksCompleted))));
        if (this.tasksUntilNextArea != null) {
            fields.add(new Field("Tasks until next Area", Field.formatBlock("", String.valueOf(this.tasksUntilNextArea))));
        }
        return fields;
    }

    public LeaguesAreaNotificationData(@NotNull String area, int index, int tasksCompleted, @Nullable Integer tasksUntilNextArea) {
        if (area == null) {
            throw new NullPointerException("area is marked non-null but is null");
        }
        this.area = area;
        this.index = index;
        this.tasksCompleted = tasksCompleted;
        this.tasksUntilNextArea = tasksUntilNextArea;
    }

    @NotNull
    public String getArea() {
        return this.area;
    }

    public int getIndex() {
        return this.index;
    }

    public int getTasksCompleted() {
        return this.tasksCompleted;
    }

    @Nullable
    public Integer getTasksUntilNextArea() {
        return this.tasksUntilNextArea;
    }

    public String toString() {
        return "LeaguesAreaNotificationData(area=" + this.getArea() + ", index=" + this.getIndex() + ", tasksCompleted=" + this.getTasksCompleted() + ", tasksUntilNextArea=" + this.getTasksUntilNextArea() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeaguesAreaNotificationData)) {
            return false;
        }
        LeaguesAreaNotificationData other = (LeaguesAreaNotificationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (this.getTasksCompleted() != other.getTasksCompleted()) {
            return false;
        }
        Integer this$tasksUntilNextArea = this.getTasksUntilNextArea();
        Integer other$tasksUntilNextArea = other.getTasksUntilNextArea();
        if (this$tasksUntilNextArea == null ? other$tasksUntilNextArea != null : !((Object)this$tasksUntilNextArea).equals(other$tasksUntilNextArea)) {
            return false;
        }
        String this$area = this.getArea();
        String other$area = other.getArea();
        return !(this$area == null ? other$area != null : !this$area.equals(other$area));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LeaguesAreaNotificationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        result = result * 59 + this.getTasksCompleted();
        Integer $tasksUntilNextArea = this.getTasksUntilNextArea();
        result = result * 59 + ($tasksUntilNextArea == null ? 43 : ((Object)$tasksUntilNextArea).hashCode());
        String $area = this.getArea();
        result = result * 59 + ($area == null ? 43 : $area.hashCode());
        return result;
    }
}

