/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers;

import dinkplugin.message.NotificationBody;
import dinkplugin.message.NotificationType;
import dinkplugin.message.templating.Evaluable;
import dinkplugin.message.templating.Replacements;
import dinkplugin.message.templating.Template;
import dinkplugin.message.templating.impl.JoiningReplacement;
import dinkplugin.notifiers.BaseNotifier;
import dinkplugin.notifiers.data.SlayerNotificationData;
import dinkplugin.util.Utils;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class SlayerNotifier
extends BaseNotifier {
    private static final Pattern BOSS_REGEX = Pattern.compile("You are granted .+ Slayer XP for completing your boss task against(?: the)? (?<name>.+)\\.$");
    @VisibleForTesting
    static final Pattern SLAYER_TASK_REGEX = Pattern.compile("You have completed your task! You killed (?<task>[\\d,]+ [^.]+)\\..*");
    private static final Pattern SLAYER_COMPLETE_REGEX = Pattern.compile("You've completed (?:at least )?(?<taskCount>[\\d,]+) (?:Wilderness )?tasks?(?: and received (?<points>[\\d,]+) points, giving you a total of [\\d,]+|\\.You'll be eligible to earn reward points if you complete tasks from a more advanced Slayer Master\\.| and reached the maximum amount of Slayer points \\((?<points2>[\\d,]+)\\))?");
    private static final Pattern TASK_MONSTER_REGEX = Pattern.compile("^(?<count>\\d*)\\s*(?<monster>.+)$");
    private final AtomicReference<String> slayerTask = new AtomicReference<String>("");
    private final AtomicInteger badTicks = new AtomicInteger();

    @Override
    public boolean isEnabled() {
        return this.config.notifySlayer() && super.isEnabled();
    }

    @Override
    protected String getWebhookUrl() {
        return this.config.slayerWebhook();
    }

    public void onChatMessage(String chatMessage) {
        if (this.isEnabled()) {
            Matcher bossMatcher;
            if (this.slayerTask.get().isEmpty() && (bossMatcher = BOSS_REGEX.matcher(chatMessage)).find()) {
                String name = bossMatcher.group("name");
                this.slayerTask.set(name.endsWith(" boss") ? name.substring(0, name.length() - " boss".length()) : name);
                return;
            }
            Matcher taskMatcher = SLAYER_TASK_REGEX.matcher(chatMessage);
            if (taskMatcher.find()) {
                String task = taskMatcher.group("task");
                this.slayerTask.getAndUpdate(old -> {
                    if (old == null || old.isEmpty()) {
                        return task;
                    }
                    return String.format("%s %s", task.substring(0, task.indexOf(32)), old);
                });
                return;
            }
            if (this.slayerTask.get().isEmpty()) {
                return;
            }
            Matcher pointsMatcher = SLAYER_COMPLETE_REGEX.matcher(chatMessage);
            if (pointsMatcher.find()) {
                String slayerPoints = pointsMatcher.group("points");
                String slayerTasksCompleted = pointsMatcher.group("taskCount");
                if (slayerPoints == null) {
                    slayerPoints = pointsMatcher.group("points2");
                }
                if (slayerPoints == null) {
                    slayerPoints = "0";
                }
                this.handleNotify(slayerPoints, slayerTasksCompleted);
            }
        }
    }

    public void onTick() {
        if (!this.slayerTask.get().isEmpty()) {
            this.badTicks.getAndIncrement();
        }
        if (this.badTicks.get() > 1) {
            this.reset();
        }
    }

    private void handleNotify(String slayerPoints, String slayerCompleted) {
        String task = this.slayerTask.get();
        if (task.isEmpty() || slayerPoints.isEmpty() || slayerCompleted.isEmpty()) {
            return;
        }
        int threshold = this.config.slayerPointThreshold();
        if (threshold <= 0 || Integer.parseInt(slayerPoints.replace(",", "")) >= threshold) {
            Optional<Pair<Integer, String>> parsedTask = SlayerNotifier.parseTask(task);
            Integer marginalKillCount = parsedTask.map(Pair::getLeft).orElse(null);
            String monster = parsedTask.map(Pair::getRight).orElse(null);
            Template notifyMessage = Template.builder().template(this.config.slayerNotifyMessage()).replacementBoundary("%").replacement("%USERNAME%", Replacements.ofText(Utils.getPlayerName(this.client))).replacement("%TASK%", SlayerNotifier.buildTask(task, monster, marginalKillCount)).replacement("%TASKCOUNT%", Replacements.ofText(slayerCompleted)).replacement("%POINTS%", Replacements.ofText(slayerPoints)).build();
            this.createMessage(this.config.slayerSendImage(), NotificationBody.builder().text(notifyMessage).extra(new SlayerNotificationData(task, slayerCompleted, slayerPoints, marginalKillCount, monster)).type(NotificationType.SLAYER).build());
        }
        this.reset();
    }

    public void reset() {
        this.slayerTask.set("");
        this.badTicks.set(0);
    }

    @NotNull
    private static Evaluable buildTask(@NotNull String rawTask, @Nullable String monster, @Nullable Integer count) {
        if (count == null || monster == null) {
            return Replacements.ofText(rawTask);
        }
        return JoiningReplacement.builder().component(Replacements.ofText(String.valueOf(count))).delimiter(" ").component(Replacements.ofWiki(monster)).build();
    }

    @NotNull
    private static Optional<Pair<Integer, String>> parseTask(@NotNull String task) {
        Matcher m = TASK_MONSTER_REGEX.matcher(task);
        if (!m.find()) {
            return Optional.empty();
        }
        return Optional.of(Pair.of((Object)Integer.parseInt(m.group("count")), (Object)m.group("monster")));
    }
}

