/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers;

import dinkplugin.message.NotificationBody;
import dinkplugin.message.NotificationType;
import dinkplugin.message.templating.Replacements;
import dinkplugin.message.templating.Template;
import dinkplugin.notifiers.BaseNotifier;
import dinkplugin.notifiers.data.QuestNotificationData;
import dinkplugin.util.QuestUtils;
import dinkplugin.util.Utils;
import javax.inject.Inject;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import org.jetbrains.annotations.VisibleForTesting;

public class QuestNotifier
extends BaseNotifier {
    public static final int COMPLETED_ID = 6347;
    public static final int TOTAL_ID = 11877;
    @VisibleForTesting
    static final int QP_TOTAL_ID = 1782;
    @Inject
    private ClientThread clientThread;

    @Override
    public boolean isEnabled() {
        return this.config.notifyQuest() && super.isEnabled();
    }

    @Override
    protected String getWebhookUrl() {
        return this.config.questWebhook();
    }

    public void onWidgetLoaded(WidgetLoaded event) {
        Widget quest;
        if (event.getGroupId() == 153 && this.isEnabled() && (quest = this.client.getWidget(0x990004)) != null) {
            String questText = quest.getText();
            this.clientThread.invokeLater(() -> this.handleNotify(questText));
        }
    }

    private void handleNotify(String questText) {
        int completedQuests = this.client.getVarbitValue(6347);
        int totalQuests = this.client.getVarbitValue(11877);
        boolean validQuests = completedQuests > 0 && totalQuests > 0;
        int questPoints = this.client.getVarpValue(101);
        int totalQuestPoints = this.client.getVarbitValue(1782);
        boolean validPoints = questPoints > 0 && totalQuestPoints > 0;
        String parsed = QuestUtils.parseQuestWidget(questText);
        if (parsed == null) {
            return;
        }
        Template notifyMessage = Template.builder().template(this.config.questNotifyMessage()).replacementBoundary("%").replacement("%USERNAME%", Replacements.ofText(Utils.getPlayerName(this.client))).replacement("%QUEST%", Replacements.ofWiki(parsed)).build();
        QuestNotificationData extra = new QuestNotificationData(parsed, validQuests ? Integer.valueOf(completedQuests) : null, validQuests ? Integer.valueOf(totalQuests) : null, validPoints ? Integer.valueOf(questPoints) : null, validPoints ? Integer.valueOf(totalQuestPoints) : null);
        this.createMessage(this.config.questSendImage(), NotificationBody.builder().text(notifyMessage).extra(extra).type(NotificationType.QUEST).build());
    }
}

