/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers;

import com.google.common.collect.ImmutableSet;
import dinkplugin.message.NotificationBody;
import dinkplugin.message.NotificationType;
import dinkplugin.message.templating.Replacements;
import dinkplugin.message.templating.Template;
import dinkplugin.notifiers.BaseNotifier;
import dinkplugin.notifiers.CollectionNotifier;
import dinkplugin.notifiers.data.PetNotificationData;
import dinkplugin.util.ItemSearcher;
import dinkplugin.util.ItemUtils;
import dinkplugin.util.Utils;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class PetNotifier
extends BaseNotifier {
    public static final int LOOT_DROP_NOTIFICATIONS = 5399;
    public static final int UNTRADEABLE_LOOT_DROPS = 5402;
    public static final String UNTRADEABLE_WARNING = "Pet Notifier cannot reliably identify pet names unless you enable the game setting: Untradeable loot notifications";
    @VisibleForTesting
    static final Pattern PET_REGEX = Pattern.compile("You (?:have a funny feeling like you|feel something weird sneaking).*");
    @VisibleForTesting
    static final Pattern CLAN_REGEX = Pattern.compile("\\b(?<user>[\\w\\s]+) (?:has a funny feeling like .+ followed|feels something weird sneaking into .+ backpack): (?<pet>.+) at (?<milestone>.+)");
    private static final Pattern UNTRADEABLE_REGEX = Pattern.compile("Untradeable drop: (.+)");
    private static final Set<String> PET_NAMES = ImmutableSet.of((Object)"Abyssal orphan", (Object)"Abyssal protector", (Object)"Baby chinchompa", (Object)"Baby mole", (Object)"Baron", (Object)"Butch", (Object[])new String[]{"Beaver", "Bloodhound", "Callisto cub", "Chompy chick", "Giant squirrel", "Hellcat", "Hellpuppy", "Herbi", "Heron", "Ikkle hydra", "Jal-nib-rek", "Kalphite princess", "Lil' creator", "Lil' zik", "Lil'viathan", "Little nightmare", "Muphin", "Nexling", "Noon", "Olmlet", "Phoenix", "Prince black dragon", "Rift guardian", "Rock golem", "Rocky", "Scorpia's offspring", "Skotos", "Smolcano", "Sraracha", "Tangleroot", "Tiny tempor", "Tumeken's guardian", "Tzrek-jad", "Venenatis spiderling", "Vet'ion jr.", "Vorki", "Wisp", "Youngllef"});
    private static final String PRIMED_NAME = "";
    @VisibleForTesting
    static final int MAX_TICKS_WAIT = 5;
    private final AtomicInteger ticksWaited = new AtomicInteger();
    @Inject
    private ItemSearcher itemSearcher;
    private volatile String petName = null;
    private volatile String milestone = null;
    private volatile boolean duplicate = false;
    private volatile boolean backpack = false;
    private volatile boolean collection = false;

    @Override
    public boolean isEnabled() {
        return this.config.notifyPet() && super.isEnabled();
    }

    @Override
    protected String getWebhookUrl() {
        return this.config.petWebhook();
    }

    public void onChatMessage(String chatMessage) {
        if (this.isEnabled()) {
            if (this.petName == null) {
                if (PET_REGEX.matcher(chatMessage).matches()) {
                    this.petName = PRIMED_NAME;
                    this.duplicate = chatMessage.contains("would have been");
                    this.backpack = chatMessage.contains(" backpack");
                }
            } else if (PRIMED_NAME.equals(this.petName) || !this.collection) {
                PetNotifier.parseItemFromGameMessage(chatMessage).filter(item -> item.getItemName().startsWith("Pet ") || PET_NAMES.contains(Utils.ucFirst(item.getItemName()))).ifPresent(parseResult -> {
                    this.setPetName(parseResult.getItemName());
                    if (parseResult.isCollectionLog()) {
                        this.collection = true;
                    }
                });
            }
        }
    }

    public void onClanNotification(String message) {
        String user;
        if (this.petName == null) {
            return;
        }
        Matcher matcher = CLAN_REGEX.matcher(message);
        if (matcher.find() && (user = matcher.group("user").trim()).equals(Utils.getPlayerName(this.client))) {
            this.petName = matcher.group("pet");
            this.milestone = StringUtils.removeEnd((String)matcher.group("milestone"), (String)".");
        }
    }

    public void onTick() {
        if (this.petName == null) {
            return;
        }
        if (this.milestone != null || this.ticksWaited.incrementAndGet() > 5) {
            if (this.isEnabled()) {
                this.handleNotify();
            }
            this.reset();
        }
    }

    public void reset() {
        this.petName = null;
        this.milestone = null;
        this.duplicate = false;
        this.backpack = false;
        this.collection = false;
        this.ticksWaited.set(0);
    }

    private void handleNotify() {
        Boolean previouslyOwned = this.duplicate ? Boolean.valueOf(true) : (this.client.getVarbitValue(11959) % 2 == 1 ? Boolean.valueOf(!this.collection) : null);
        String gameMessage = this.backpack ? "feels something weird sneaking into their backpack" : (previouslyOwned != null && previouslyOwned != false ? "has a funny feeling like they would have been followed..." : "has a funny feeling like they're being followed");
        Template notifyMessage = Template.builder().template(this.config.petNotifyMessage()).replacementBoundary("%").replacement("%USERNAME%", Replacements.ofText(Utils.getPlayerName(this.client))).replacement("%GAME_MESSAGE%", Replacements.ofText(gameMessage)).build();
        String thumbnail = Optional.ofNullable(this.petName).filter(s -> !s.isEmpty()).map(Utils::ucFirst).map(this.itemSearcher::findItemId).map(ItemUtils::getItemImageUrl).orElse(null);
        PetNotificationData extra = new PetNotificationData((String)StringUtils.defaultIfEmpty((CharSequence)this.petName, null), this.milestone, this.duplicate, previouslyOwned);
        this.createMessage(this.config.petSendImage(), NotificationBody.builder().extra(extra).text(notifyMessage).thumbnailUrl(thumbnail).type(NotificationType.PET).build());
    }

    private static Optional<ParseResult> parseItemFromGameMessage(String message) {
        Matcher untradeableMatcher = UNTRADEABLE_REGEX.matcher(message);
        if (untradeableMatcher.find()) {
            return Optional.of(new ParseResult(untradeableMatcher.group(1), false));
        }
        Matcher collectionMatcher = CollectionNotifier.COLLECTION_LOG_REGEX.matcher(message);
        if (collectionMatcher.find()) {
            return Optional.of(new ParseResult(collectionMatcher.group("itemName"), true));
        }
        return Optional.empty();
    }

    private void setPetName(String petName) {
        this.petName = petName;
    }

    private static final class ParseResult {
        private final String itemName;
        private final boolean collectionLog;

        public ParseResult(String itemName, boolean collectionLog) {
            this.itemName = itemName;
            this.collectionLog = collectionLog;
        }

        public String getItemName() {
            return this.itemName;
        }

        public boolean isCollectionLog() {
            return this.collectionLog;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParseResult)) {
                return false;
            }
            ParseResult other = (ParseResult)o;
            if (this.isCollectionLog() != other.isCollectionLog()) {
                return false;
            }
            String this$itemName = this.getItemName();
            String other$itemName = other.getItemName();
            return !(this$itemName == null ? other$itemName != null : !this$itemName.equals(other$itemName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCollectionLog() ? 79 : 97);
            String $itemName = this.getItemName();
            result = result * 59 + ($itemName == null ? 43 : $itemName.hashCode());
            return result;
        }

        public String toString() {
            return "PetNotifier.ParseResult(itemName=" + this.getItemName() + ", collectionLog=" + this.isCollectionLog() + ")";
        }
    }
}

