/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers;

import dinkplugin.domain.LeagueRelicTier;
import dinkplugin.domain.LeagueTaskDifficulty;
import dinkplugin.message.NotificationBody;
import dinkplugin.message.NotificationType;
import dinkplugin.message.templating.Replacements;
import dinkplugin.message.templating.Template;
import dinkplugin.notifiers.BaseNotifier;
import dinkplugin.notifiers.data.LeaguesAreaNotificationData;
import dinkplugin.notifiers.data.LeaguesRelicNotificationData;
import dinkplugin.notifiers.data.LeaguesTaskNotificationData;
import dinkplugin.util.Utils;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.WorldType;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaguesNotifier
extends BaseNotifier {
    private static final Logger log = LoggerFactory.getLogger(LeaguesNotifier.class);
    private static final String AREA_UNLOCK_PREFIX = "Congratulations, you've unlocked a new area: ";
    private static final String RELIC_UNLOCK_PREFIX = "Congratulations, you've unlocked a new Relic: ";
    private static final Pattern TASK_REGEX = Pattern.compile("Congratulations, you've completed an? (?<tier>\\w+) task: (?<task>.+)\\.");
    @VisibleForTesting
    static final int TASKS_COMPLETED_ID = 10046;
    @VisibleForTesting
    static final int POINTS_EARNED_ID = 2614;
    @VisibleForTesting
    static final int FIVE_AREAS = 10666;
    @VisibleForTesting
    static final int FOUR_AREAS = 10665;
    @VisibleForTesting
    static final int THREE_AREAS = 10664;
    @VisibleForTesting
    static final int TWO_AREAS = 10663;
    private static final NavigableMap<Integer, String> TROPHY_BY_POINTS;
    private static final Map<String, LeagueRelicTier> TIER_BY_RELIC;
    private static final NavigableMap<Integer, Integer> AREA_BY_TASKS;

    @Override
    public boolean isEnabled() {
        return this.config.notifyLeagues() && this.client.getWorldType().contains(WorldType.SEASONAL) && this.settingsManager.isNamePermitted(this.client.getLocalPlayer().getName());
    }

    @Override
    protected String getWebhookUrl() {
        return this.config.leaguesWebhook();
    }

    public void onGameMessage(String message) {
        LeagueTaskDifficulty tier;
        Matcher matcher;
        if (!this.isEnabled()) {
            return;
        }
        if (message.startsWith(AREA_UNLOCK_PREFIX)) {
            if (this.config.leaguesAreaUnlock()) {
                String area = message.substring(AREA_UNLOCK_PREFIX.length(), message.length() - 1);
                this.notifyAreaUnlock(area);
            }
        } else if (message.startsWith(RELIC_UNLOCK_PREFIX)) {
            if (this.config.leaguesRelicUnlock()) {
                String relic = message.substring(RELIC_UNLOCK_PREFIX.length(), message.length() - 1);
                this.notifyRelicUnlock(relic);
            }
        } else if (this.config.leaguesTaskCompletion() && (matcher = TASK_REGEX.matcher(message)).find() && (tier = LeagueTaskDifficulty.TIER_BY_LOWER_NAME.get(matcher.group("tier"))) != null && tier.ordinal() >= this.config.leaguesTaskMinTier().ordinal()) {
            this.notifyTaskCompletion(tier, matcher.group("task"));
        }
    }

    private void notifyAreaUnlock(String area) {
        Integer tasksUntilNextArea;
        Map.Entry<Integer, String> unlocked = this.numAreasUnlocked();
        int tasksCompleted = this.client.getVarbitValue(10046);
        Integer tasksForNextArea = AREA_BY_TASKS.ceilingKey(tasksCompleted + 1);
        Integer n = tasksUntilNextArea = tasksForNextArea != null ? Integer.valueOf(tasksForNextArea - tasksCompleted) : null;
        if (unlocked == null) {
            int i = AREA_BY_TASKS.floorEntry(Math.max(tasksCompleted, 0)).getValue();
            unlocked = Map.entry(i, LeaguesNotifier.ith(i));
        }
        String playerName = Utils.getPlayerName(this.client);
        Template text = Template.builder().template("%USERNAME% selected their %I_TH% region: %AREA%.").replacementBoundary("%").replacement("%USERNAME%", Replacements.ofText(playerName)).replacement("%I_TH%", Replacements.ofText(unlocked.getValue())).replacement("%AREA%", Replacements.ofWiki(area, "Trailblazer Reloaded League/Areas/" + area)).build();
        this.createMessage(this.config.leaguesSendImage(), NotificationBody.builder().type(NotificationType.LEAGUES_AREA).text(text).extra(new LeaguesAreaNotificationData(area, unlocked.getKey(), tasksCompleted, tasksUntilNextArea)).playerName(playerName).seasonalWorld(true).build());
    }

    private void notifyRelicUnlock(String relic) {
        int points = this.client.getVarpValue(2614);
        Integer pointsOfNextTier = LeagueRelicTier.TIER_BY_POINTS.ceilingKey(points + 1);
        Integer pointsUntilNextTier = pointsOfNextTier != null ? Integer.valueOf(pointsOfNextTier - points) : null;
        LeagueRelicTier relicTier = TIER_BY_RELIC.get(relic);
        if (relicTier == null) {
            log.warn("Unknown relic encountered: {}", (Object)relic);
            if (points >= 0) {
                relicTier = LeagueRelicTier.TIER_BY_POINTS.floorEntry(points).getValue();
            }
        }
        Integer tier = relicTier != null ? Integer.valueOf(relicTier.ordinal() + 1) : null;
        Integer requiredPoints = relicTier != null ? Integer.valueOf(relicTier.getPoints()) : null;
        String playerName = Utils.getPlayerName(this.client);
        Template text = Template.builder().template("%USERNAME% unlocked a Tier %TIER% Relic: %RELIC%.").replacementBoundary("%").replacement("%USERNAME%", Replacements.ofText(playerName)).replacement("%TIER%", Replacements.ofText(tier != null ? tier.toString() : "?")).replacement("%RELIC%", Replacements.ofWiki(relic)).build();
        this.createMessage(this.config.leaguesSendImage(), NotificationBody.builder().type(NotificationType.LEAGUES_RELIC).text(text).extra(new LeaguesRelicNotificationData(relic, tier, requiredPoints, points, pointsUntilNextTier)).playerName(playerName).seasonalWorld(true).build());
    }

    private void notifyTaskCompletion(LeagueTaskDifficulty tier, String task) {
        int taskPoints = tier.getPoints();
        int totalPoints = this.client.getVarpValue(2614);
        int tasksCompleted = this.client.getVarbitValue(10046);
        String playerName = Utils.getPlayerName(this.client);
        Integer nextAreaTasks = AREA_BY_TASKS.ceilingKey(tasksCompleted + 1);
        Integer tasksUntilNextArea = nextAreaTasks != null ? Integer.valueOf(nextAreaTasks - tasksCompleted) : null;
        Map.Entry<Integer, String> trophy = TROPHY_BY_POINTS.floorEntry(totalPoints);
        Integer prevTrophyPoints = trophy != null ? TROPHY_BY_POINTS.floorKey(totalPoints - taskPoints) : null;
        boolean newTrophy = trophy != null && (prevTrophyPoints == null || trophy.getKey() > prevTrophyPoints);
        String justEarnedTrophy = newTrophy ? trophy.getValue() : null;
        Integer nextTrophyPoints = TROPHY_BY_POINTS.ceilingKey(totalPoints + 1);
        Integer pointsUntilNextTrophy = nextTrophyPoints != null ? Integer.valueOf(nextTrophyPoints - totalPoints) : null;
        Integer nextRelicPoints = LeagueRelicTier.TIER_BY_POINTS.ceilingKey(totalPoints + 1);
        Integer pointsUntilNextRelic = nextRelicPoints != null ? Integer.valueOf(nextRelicPoints - totalPoints) : null;
        Template text = Template.builder().template(newTrophy ? "%USERNAME% completed a %TIER% task, %TASK%, unlocking the %TROPHY% trophy!" : "%USERNAME% completed a %TIER% task: %TASK%.").replacementBoundary("%").replacement("%USERNAME%", Replacements.ofText(playerName)).replacement("%TIER%", Replacements.ofText(tier.getDisplayName())).replacement("%TASK%", Replacements.ofWiki(task, "Trailblazer_Reloaded_League/Tasks")).replacement("%TROPHY%", newTrophy ? Replacements.ofWiki(trophy.getValue(), String.format("Trailblazer reloaded %s trophy", trophy.getValue().toLowerCase())) : Replacements.ofText("?")).build();
        this.createMessage(this.config.leaguesSendImage(), NotificationBody.builder().type(NotificationType.LEAGUES_TASK).text(text).extra(new LeaguesTaskNotificationData(task, tier, taskPoints, totalPoints, tasksCompleted, tasksUntilNextArea, pointsUntilNextRelic, pointsUntilNextTrophy, justEarnedTrophy)).playerName(playerName).seasonalWorld(true).build());
    }

    private Map.Entry<Integer, String> numAreasUnlocked() {
        if (this.client.getVarbitValue(10666) > 0) {
            return Map.entry(3, LeaguesNotifier.ith(3));
        }
        if (this.client.getVarbitValue(10665) > 0) {
            return Map.entry(2, LeaguesNotifier.ith(2));
        }
        if (this.client.getVarbitValue(10664) > 0) {
            return Map.entry(1, LeaguesNotifier.ith(1));
        }
        if (this.client.getVarbitValue(10663) > 0) {
            return Map.entry(0, LeaguesNotifier.ith(0));
        }
        return null;
    }

    private static String ith(int i) {
        if (i == 0) {
            return "zeroth";
        }
        if (i == 1) {
            return "first";
        }
        if (i == 2) {
            return "second";
        }
        if (i == 3) {
            return "third";
        }
        if (i == 4) {
            return "fourth";
        }
        if (i == 5) {
            return "fifth";
        }
        return String.valueOf(i);
    }

    static {
        AREA_BY_TASKS = Collections.unmodifiableNavigableMap(new TreeMap<Integer, Integer>(Map.of(0, 0, 60, 1, 140, 2, 300, 3)));
        TreeMap<Integer, String> thresholds = new TreeMap<Integer, String>();
        thresholds.put(2500, "Bronze");
        thresholds.put(5000, "Iron");
        thresholds.put(10000, "Steel");
        thresholds.put(18000, "Mithril");
        thresholds.put(28000, "Adamant");
        thresholds.put(42000, "Rune");
        thresholds.put(56000, "Dragon");
        TROPHY_BY_POINTS = Collections.unmodifiableNavigableMap(thresholds);
        TIER_BY_RELIC = Map.ofEntries(Map.entry("Endless Harvest", LeagueRelicTier.ONE), Map.entry("Production Prodigy", LeagueRelicTier.ONE), Map.entry("Trickster", LeagueRelicTier.ONE), Map.entry("Fairy's Flight", LeagueRelicTier.TWO), Map.entry("Globetrotter", LeagueRelicTier.TWO), Map.entry("Banker's Note", LeagueRelicTier.THREE), Map.entry("Fire Sale", LeagueRelicTier.THREE), Map.entry("Archer's Embrace", LeagueRelicTier.FOUR), Map.entry("Brawler's Resolve", LeagueRelicTier.FOUR), Map.entry("Superior Sorcerer", LeagueRelicTier.FOUR), Map.entry("Bloodthirsty", LeagueRelicTier.FIVE), Map.entry("Infernal Gathering", LeagueRelicTier.FIVE), Map.entry("Treasure Seeker", LeagueRelicTier.FIVE), Map.entry("Equilibrium", LeagueRelicTier.SIX), Map.entry("Farmer's Fortune", LeagueRelicTier.SIX), Map.entry("Ruinous Powers", LeagueRelicTier.SIX), Map.entry("Berserker", LeagueRelicTier.SEVEN), Map.entry("Soul Stealer", LeagueRelicTier.SEVEN), Map.entry("Weapon Master", LeagueRelicTier.SEVEN), Map.entry("Guardian", LeagueRelicTier.EIGHT), Map.entry("Executioner", LeagueRelicTier.EIGHT), Map.entry("Undying Retribution", LeagueRelicTier.EIGHT));
    }
}

