/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import dinkplugin.message.NotificationBody;
import dinkplugin.message.NotificationType;
import dinkplugin.message.templating.Replacements;
import dinkplugin.message.templating.Template;
import dinkplugin.notifiers.BaseNotifier;
import dinkplugin.notifiers.data.GrandExchangeNotificationData;
import dinkplugin.notifiers.data.SerializedItemStack;
import dinkplugin.util.ItemUtils;
import dinkplugin.util.SerializedOffer;
import dinkplugin.util.Utils;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import net.runelite.api.GameState;
import net.runelite.api.GrandExchangeOffer;
import net.runelite.api.GrandExchangeOfferState;
import net.runelite.api.ItemComposition;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.grandexchange.GrandExchangePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrandExchangeNotifier
extends BaseNotifier {
    private static final Logger log = LoggerFactory.getLogger(GrandExchangeNotifier.class);
    private static final Set<Integer> TAX_EXEMPT_ITEMS;
    private static final int LOGIN_DELAY = 2;
    private static final String RL_GE_PLUGIN_NAME;
    private final AtomicInteger initTicks = new AtomicInteger();
    private final Map<Integer, Instant> progressNotificationTimeBySlot = new HashMap<Integer, Instant>();
    @Inject
    private Gson gson;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ItemManager itemManager;

    @Override
    public boolean isEnabled() {
        return this.config.notifyGrandExchange() && super.isEnabled();
    }

    @Override
    protected String getWebhookUrl() {
        return this.config.grandExchangeWebhook();
    }

    public void onAccountChange() {
        this.progressNotificationTimeBySlot.clear();
    }

    public void onGameStateChange(GameStateChanged event) {
        if (event.getGameState() != GameState.LOGGED_IN) {
            this.initTicks.set(2);
        }
    }

    public void onTick() {
        this.initTicks.updateAndGet(i -> Math.max(i - 1, 0));
    }

    public void onOfferChange(int slot, GrandExchangeOffer offer) {
        if (this.shouldNotify(slot, offer)) {
            this.handleNotify(slot, offer);
        }
    }

    private void handleNotify(int slot, GrandExchangeOffer offer) {
        log.debug("Notifying for slot={}, item={}, quantity={}, targetPrice={}, spent={}, state={}", new Object[]{slot, offer.getItemId(), offer.getQuantitySold(), offer.getPrice(), offer.getSpent(), offer.getState()});
        ItemComposition comp = this.itemManager.getItemComposition(offer.getItemId());
        SerializedItemStack item = new SerializedItemStack(offer.getItemId(), offer.getQuantitySold(), GrandExchangeNotifier.getUnitPrice(offer), comp.getMembersName());
        long marketPrice = ItemUtils.getPrice(this.itemManager, offer.getItemId());
        OfferType type = GrandExchangeNotifier.getType(offer.getState());
        Long tax = type == OfferType.SELL ? Long.valueOf(GrandExchangeNotifier.calculateTax(item.getPriceEach(), item.getQuantity(), item.getId())) : null;
        List<Object> embeds = this.config.grandExchangeSendImage() ? Collections.emptyList() : ItemUtils.buildEmbeds(new int[]{offer.getItemId()});
        String playerName = Utils.getPlayerName(this.client);
        Template message = Template.builder().template(this.config.grandExchangeNotifyMessage()).replacementBoundary("%").replacement("%USERNAME%", Replacements.ofText(playerName)).replacement("%TYPE%", Replacements.ofText(type.getDisplayName())).replacement("%ITEM%", ItemUtils.templateStack(item, true)).replacement("%STATUS%", Replacements.ofText(GrandExchangeNotifier.getHumanStatus(offer.getState()))).build();
        this.createMessage(this.config.grandExchangeSendImage(), NotificationBody.builder().type(NotificationType.GRAND_EXCHANGE).text(message).embeds(embeds).extra(new GrandExchangeNotificationData(slot + 1, offer.getState(), item, marketPrice, offer.getPrice(), offer.getTotalQuantity(), tax)).playerName(playerName).build());
    }

    private boolean shouldNotify(int slot, GrandExchangeOffer offer) {
        if (this.initTicks.get() > 0) {
            if (offer.getState() != GrandExchangeOfferState.BOUGHT && offer.getState() != GrandExchangeOfferState.SOLD) {
                return false;
            }
            if ("false".equals(this.configManager.getConfiguration("runelite", RL_GE_PLUGIN_NAME))) {
                return false;
            }
            if (this.getSavedOffer(slot).filter(saved -> saved.equals(offer)).isPresent()) {
                return false;
            }
        }
        if (!this.isEnabled()) {
            return false;
        }
        boolean valuable = GrandExchangeNotifier.getTransactedValue(offer) >= (long)this.config.grandExchangeMinValue();
        switch (offer.getState()) {
            case EMPTY: {
                if (this.client.getGameState() == GameState.LOGGED_IN) {
                    this.progressNotificationTimeBySlot.remove(slot);
                }
                return false;
            }
            case BOUGHT: 
            case SOLD: {
                this.progressNotificationTimeBySlot.remove(slot);
                return valuable;
            }
            case CANCELLED_BUY: 
            case CANCELLED_SELL: {
                this.progressNotificationTimeBySlot.remove(slot);
                return valuable && this.config.grandExchangeIncludeCancelled();
            }
            case BUYING: 
            case SELLING: {
                if (!valuable || offer.getQuantitySold() <= 0) {
                    return false;
                }
                if (offer.getQuantitySold() >= offer.getTotalQuantity()) {
                    return false;
                }
                int spacing = this.config.grandExchangeProgressSpacingMinutes();
                if (spacing < 0) {
                    return false;
                }
                if (this.getSavedOffer(slot).filter(saved -> saved.equals(offer)).isPresent()) {
                    return false;
                }
                long spacingSeconds = spacing > 0 ? (long)spacing * 60L : 2L;
                Instant now = Instant.now();
                Instant prior = this.progressNotificationTimeBySlot.get(slot);
                if (prior == null || Duration.between(prior, now).getSeconds() >= spacingSeconds) {
                    return this.progressNotificationTimeBySlot.put(slot, now) == prior;
                }
                return false;
            }
        }
        return false;
    }

    private Optional<SerializedOffer> getSavedOffer(int slot) {
        return Optional.ofNullable(this.configManager.getRSProfileConfiguration("geoffer", String.valueOf(slot))).map(json -> {
            try {
                return (SerializedOffer)this.gson.fromJson(json, SerializedOffer.class);
            }
            catch (JsonSyntaxException e) {
                log.warn("Failed to read saved GE offer", (Throwable)e);
                return null;
            }
        });
    }

    public static String getHumanStatus(GrandExchangeOfferState state) {
        switch (state) {
            case CANCELLED_BUY: 
            case CANCELLED_SELL: {
                return "Cancelled";
            }
            case BUYING: 
            case SELLING: {
                return "In Progress";
            }
            case BOUGHT: 
            case SOLD: {
                return "Completed";
            }
        }
        return null;
    }

    private static OfferType getType(GrandExchangeOfferState state) {
        switch (state) {
            case BOUGHT: 
            case CANCELLED_BUY: 
            case BUYING: {
                return OfferType.BUY;
            }
            case SOLD: 
            case CANCELLED_SELL: 
            case SELLING: {
                return OfferType.SELL;
            }
        }
        return null;
    }

    private static long getTransactedValue(GrandExchangeOffer offer) {
        long spent = offer.getSpent();
        return spent > 0L ? spent : (long)offer.getQuantitySold() * (long)offer.getPrice();
    }

    private static int getUnitPrice(GrandExchangeOffer offer) {
        int quantity = offer.getQuantitySold();
        int spent = offer.getSpent();
        return quantity > 0 && spent > 0 ? spent / quantity : offer.getPrice();
    }

    private static long calculateTax(int unitPrice, int quantity, int itemId) {
        if (unitPrice < 100 || TAX_EXEMPT_ITEMS.contains(itemId)) {
            return 0L;
        }
        int price = Math.min(unitPrice, 500000000);
        int unitTax = (int)Math.floor((double)price * 0.01);
        return (long)unitTax * (long)quantity;
    }

    static {
        RL_GE_PLUGIN_NAME = GrandExchangePlugin.class.getSimpleName().toLowerCase();
        TAX_EXEMPT_ITEMS = ImmutableSet.of((Object)1755, (Object)5343, (Object)5325, (Object)1785, (Object)2347, (Object)1733, (Object[])new Integer[]{233, 5341, 8794, 5329, 1735, 952, 5331, 13190});
    }

    private static enum OfferType {
        BUY("bought"),
        SELL("sold");

        private final String displayName;

        public String getDisplayName() {
            return this.displayName;
        }

        private OfferType(String displayName) {
            this.displayName = displayName;
        }
    }
}

