/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers;

import com.google.common.collect.ImmutableSet;
import dinkplugin.message.NotificationBody;
import dinkplugin.message.NotificationType;
import dinkplugin.message.templating.Evaluable;
import dinkplugin.message.templating.Replacements;
import dinkplugin.message.templating.Template;
import dinkplugin.message.templating.impl.JoiningReplacement;
import dinkplugin.notifiers.BaseNotifier;
import dinkplugin.notifiers.data.GambleNotificationData;
import dinkplugin.notifiers.data.SerializedItemStack;
import dinkplugin.util.ItemSearcher;
import dinkplugin.util.ItemUtils;
import dinkplugin.util.Utils;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import lombok.NonNull;
import net.runelite.client.game.ItemManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GambleNotifier
extends BaseNotifier {
    private static final Logger log = LoggerFactory.getLogger(GambleNotifier.class);
    private static final Pattern GAMBLE_REGEX = Pattern.compile("^(.+?)!\\s*(.+!)?\\s+High level gamble count: (\\d+).*");
    private static final Pattern ITEM_QUANTITY_REGEX = Pattern.compile("^(.+?)\\(x (\\d+)\\)$");
    private static final Collection<String> RARE_LOOT = ImmutableSet.of((Object)"dragon chainbody", (Object)"dragon med helm", (Object)"pet penance queen");
    @Inject
    private ItemSearcher itemSearcher;
    @Inject
    private ItemManager itemManager;

    @Override
    public boolean isEnabled() {
        return this.config.notifyGamble() && super.isEnabled();
    }

    @Override
    protected String getWebhookUrl() {
        return this.config.gambleWebhook();
    }

    public void onMesBoxNotification(String message) {
        if (!this.isEnabled()) {
            return;
        }
        ParsedData data = GambleNotifier.parse(message);
        if (data != null) {
            this.handleNotify(data);
        }
    }

    private void handleNotify(ParsedData data) {
        String messageFormat;
        if (this.config.gambleRareLoot() && RARE_LOOT.contains(data.itemName.toLowerCase())) {
            messageFormat = this.config.gambleRareNotifyMessage();
        } else if (data.gambleCount % this.config.gambleInterval() == 0) {
            messageFormat = this.config.gambleNotifyMessage();
        } else {
            return;
        }
        String player = Utils.getPlayerName(this.client);
        List<SerializedItemStack> items = this.serializeItems(data);
        Template message = Template.builder().template(messageFormat).replacementBoundary("%").replacement("%USERNAME%", Replacements.ofText(player)).replacement("%COUNT%", Replacements.ofText(String.valueOf(data.gambleCount))).replacement("%LOOT%", GambleNotifier.lootSummary(items)).build();
        this.createMessage(this.config.gambleSendImage(), NotificationBody.builder().text(message).extra(new GambleNotificationData(data.gambleCount, items)).type(NotificationType.BARBARIAN_ASSAULT_GAMBLE).build());
    }

    private static Evaluable lootSummary(List<SerializedItemStack> items) {
        JoiningReplacement.JoiningReplacementBuilder builder = JoiningReplacement.builder().delimiter("\n");
        items.forEach(item -> builder.component(ItemUtils.templateStack(item, true)));
        return builder.build();
    }

    private List<SerializedItemStack> serializeItems(ParsedData data) {
        return Stream.of(Pair.of((Object)data.itemName, (Object)data.itemQuantity), Pair.of((Object)data.tertiaryItem, (Object)1)).filter(p -> p.getLeft() != null).map(p -> Pair.of((Object)this.itemSearcher.findItemId((String)p.getLeft()), (Object)((Integer)p.getRight()))).filter(p -> p.getLeft() != null).map(p -> ItemUtils.stackFromItem(this.itemManager, (Integer)p.getLeft(), (Integer)p.getRight())).collect(Collectors.toList());
    }

    @Nullable
    @VisibleForTesting
    static ParsedData parse(String message) {
        String tertiary;
        String rawItem;
        Matcher matcher = GAMBLE_REGEX.matcher(message);
        if (!matcher.matches()) {
            return null;
        }
        String itemName = rawItem = matcher.group(1).trim();
        int itemQuantity = 1;
        Matcher quantityMatcher = ITEM_QUANTITY_REGEX.matcher(rawItem);
        if (quantityMatcher.matches()) {
            itemName = quantityMatcher.group(1).trim();
            itemQuantity = Integer.parseInt(quantityMatcher.group(2));
        }
        if ((tertiary = matcher.group(2)) != null) {
            tertiary = StringUtils.removeEnd((String)tertiary, (String)"!").trim();
        }
        int gambleCount = Integer.parseInt(matcher.group(3));
        return new ParsedData(itemName, itemQuantity, tertiary, gambleCount);
    }

    @VisibleForTesting
    static final class ParsedData {
        @NonNull
        private final String itemName;
        private final int itemQuantity;
        @Nullable
        private final String tertiaryItem;
        private final int gambleCount;

        public ParsedData(@NonNull String itemName, int itemQuantity, @Nullable String tertiaryItem, int gambleCount) {
            if (itemName == null) {
                throw new NullPointerException("itemName is marked non-null but is null");
            }
            this.itemName = itemName;
            this.itemQuantity = itemQuantity;
            this.tertiaryItem = tertiaryItem;
            this.gambleCount = gambleCount;
        }

        @NonNull
        public String getItemName() {
            return this.itemName;
        }

        public int getItemQuantity() {
            return this.itemQuantity;
        }

        @Nullable
        public String getTertiaryItem() {
            return this.tertiaryItem;
        }

        public int getGambleCount() {
            return this.gambleCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParsedData)) {
                return false;
            }
            ParsedData other = (ParsedData)o;
            if (this.getItemQuantity() != other.getItemQuantity()) {
                return false;
            }
            if (this.getGambleCount() != other.getGambleCount()) {
                return false;
            }
            String this$itemName = this.getItemName();
            String other$itemName = other.getItemName();
            if (this$itemName == null ? other$itemName != null : !this$itemName.equals(other$itemName)) {
                return false;
            }
            String this$tertiaryItem = this.getTertiaryItem();
            String other$tertiaryItem = other.getTertiaryItem();
            return !(this$tertiaryItem == null ? other$tertiaryItem != null : !this$tertiaryItem.equals(other$tertiaryItem));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getItemQuantity();
            result = result * 59 + this.getGambleCount();
            String $itemName = this.getItemName();
            result = result * 59 + ($itemName == null ? 43 : $itemName.hashCode());
            String $tertiaryItem = this.getTertiaryItem();
            result = result * 59 + ($tertiaryItem == null ? 43 : $tertiaryItem.hashCode());
            return result;
        }

        public String toString() {
            return "GambleNotifier.ParsedData(itemName=" + this.getItemName() + ", itemQuantity=" + this.getItemQuantity() + ", tertiaryItem=" + this.getTertiaryItem() + ", gambleCount=" + this.getGambleCount() + ")";
        }
    }
}

