/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers;

import com.google.common.collect.ImmutableMap;
import dinkplugin.domain.CombatAchievementTier;
import dinkplugin.message.NotificationBody;
import dinkplugin.message.NotificationType;
import dinkplugin.message.templating.Replacements;
import dinkplugin.message.templating.Template;
import dinkplugin.notifiers.BaseNotifier;
import dinkplugin.notifiers.data.CombatAchievementData;
import dinkplugin.util.Utils;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.client.callback.ClientThread;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.VisibleForTesting;

public class CombatTaskNotifier
extends BaseNotifier {
    private static final Pattern ACHIEVEMENT_PATTERN = Pattern.compile("Congratulations, you've completed an? (?<tier>\\w+) combat task: (?<task>.+)\\.");
    private static final Pattern TASK_POINTS = Pattern.compile("\\s+\\(\\d+ points?\\)$");
    public static final String REPEAT_WARNING = "Combat Task notifier will fire duplicates unless you disable the game setting: Combat Achievement Tasks - Repeat completion";
    public static final int COMBAT_TASK_REPEAT_POPUP = 12456;
    public static final int TOTAL_POINTS_ID = 14815;
    public static final int GRANDMASTER_TOTAL_POINTS_ID = 14814;
    @VisibleForTesting
    public static final Map<CombatAchievementTier, Integer> CUM_POINTS_VARBIT_BY_TIER = ImmutableMap.builderWithExpectedSize((int)6).put((Object)CombatAchievementTier.EASY, (Object)4132).put((Object)CombatAchievementTier.MEDIUM, (Object)10660).put((Object)CombatAchievementTier.HARD, (Object)10661).put((Object)CombatAchievementTier.ELITE, (Object)14812).put((Object)CombatAchievementTier.MASTER, (Object)14813).put((Object)CombatAchievementTier.GRANDMASTER, (Object)14814).build();
    private final NavigableMap<Integer, CombatAchievementTier> cumulativeUnlockPoints = new TreeMap<Integer, CombatAchievementTier>();
    @Inject
    private ClientThread clientThread;

    @Override
    public boolean isEnabled() {
        return this.config.notifyCombatTask() && super.isEnabled();
    }

    @Override
    protected String getWebhookUrl() {
        return this.config.combatTaskWebhook();
    }

    public void onTick() {
        if (this.cumulativeUnlockPoints.size() < CUM_POINTS_VARBIT_BY_TIER.size()) {
            this.initThresholds();
        }
    }

    public void onGameMessage(String message) {
        if (this.isEnabled()) {
            CombatTaskNotifier.parse(message).ifPresent(pair -> this.handle((CombatAchievementTier)((Object)((Object)pair.getLeft())), (String)pair.getRight()));
        }
    }

    private void handle(CombatAchievementTier tier, String task) {
        if (tier.ordinal() < this.config.minCombatAchievementTier().ordinal()) {
            return;
        }
        this.clientThread.invokeAtTickEnd(() -> {
            Integer tierTotalPoints;
            Integer tierProgress;
            int prevThreshold;
            int taskPoints = tier.getPoints();
            int totalPoints = this.client.getVarbitValue(14815);
            Integer nextUnlockPointsThreshold = this.cumulativeUnlockPoints.ceilingKey(totalPoints + 1);
            Map.Entry<Integer, CombatAchievementTier> prev = this.cumulativeUnlockPoints.floorEntry(totalPoints);
            int n = prevThreshold = prev != null ? prev.getKey() : 0;
            if (nextUnlockPointsThreshold != null) {
                tierProgress = totalPoints - prevThreshold;
                tierTotalPoints = nextUnlockPointsThreshold - prevThreshold;
            } else {
                tierTotalPoints = null;
                tierProgress = null;
            }
            boolean crossedThreshold = prevThreshold > 0 && totalPoints - taskPoints < prevThreshold;
            CombatAchievementTier completedTier = crossedThreshold ? prev.getValue() : null;
            String completedTierName = completedTier != null ? completedTier.getDisplayName() : "N/A";
            String player = Utils.getPlayerName(this.client);
            Template message = Template.builder().template(crossedThreshold ? this.config.combatTaskUnlockMessage() : this.config.combatTaskMessage()).replacementBoundary("%").replacement("%USERNAME%", Replacements.ofText(player)).replacement("%TIER%", Replacements.ofText(tier.toString())).replacement("%TASK%", Replacements.ofWiki(task)).replacement("%POINTS%", Replacements.ofText(String.valueOf(taskPoints))).replacement("%TOTAL_POINTS%", Replacements.ofText(String.valueOf(totalPoints))).replacement("%COMPLETED%", Replacements.ofText(completedTierName)).build();
            this.createMessage(this.config.combatTaskSendImage(), NotificationBody.builder().type(NotificationType.COMBAT_ACHIEVEMENT).text(message).playerName(player).extra(new CombatAchievementData(tier, task, taskPoints, totalPoints, tierProgress, tierTotalPoints, completedTier)).build());
        });
    }

    private void initThresholds() {
        CUM_POINTS_VARBIT_BY_TIER.forEach((tier, varbitId) -> {
            int cumulativePoints = this.client.getVarbitValue(varbitId.intValue());
            if (cumulativePoints > 0) {
                this.cumulativeUnlockPoints.put(cumulativePoints, (CombatAchievementTier)((Object)tier));
            }
        });
    }

    @VisibleForTesting
    static Optional<Pair<CombatAchievementTier, String>> parse(String message) {
        Matcher matcher = ACHIEVEMENT_PATTERN.matcher(message);
        if (!matcher.find()) {
            return Optional.empty();
        }
        return Optional.of(matcher.group("tier")).map(CombatAchievementTier.TIER_BY_LOWER_NAME::get).map(tier -> Pair.of((Object)tier, (Object)TASK_POINTS.matcher(matcher.group("task")).replaceFirst("")));
    }
}

