/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers;

import dinkplugin.DinkPluginConfig;
import dinkplugin.SettingsManager;
import dinkplugin.message.DiscordMessageHandler;
import dinkplugin.message.NotificationBody;
import dinkplugin.util.WorldUtils;
import java.util.EnumSet;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.WorldType;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseNotifier {
    @Inject
    protected DinkPluginConfig config;
    @Inject
    protected SettingsManager settingsManager;
    @Inject
    protected Client client;
    @Inject
    private DiscordMessageHandler messageHandler;

    public boolean isEnabled() {
        EnumSet world = this.client.getWorldType();
        if (this.config.ignoreSeasonal() && world.contains(WorldType.SEASONAL)) {
            return false;
        }
        if (WorldUtils.isIgnoredWorld(world)) {
            return false;
        }
        return this.settingsManager.isNamePermitted(this.client.getLocalPlayer().getName());
    }

    protected abstract String getWebhookUrl();

    protected final void createMessage(boolean sendImage, NotificationBody<?> body) {
        String overrideUrl = this.getWebhookUrl();
        String url = StringUtils.isNotBlank((CharSequence)overrideUrl) ? overrideUrl : this.config.primaryWebhook();
        this.messageHandler.createMessage(url, sendImage, body);
    }
}

