/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.message.templating.impl;

import dinkplugin.message.templating.Evaluable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class JoiningReplacement
implements Evaluable {
    private final List<Evaluable> components;
    private final String delimiter;

    @Override
    public String evaluate(boolean rich) {
        if (this.components.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Evaluable> it = this.components.iterator();
        sb.append(it.next().evaluate(rich));
        while (it.hasNext()) {
            sb.append(this.delimiter);
            sb.append(it.next().evaluate(rich));
        }
        return sb.toString();
    }

    private static String $default$delimiter() {
        return "";
    }

    JoiningReplacement(List<Evaluable> components, String delimiter) {
        this.components = components;
        this.delimiter = delimiter;
    }

    public static JoiningReplacementBuilder builder() {
        return new JoiningReplacementBuilder();
    }

    public List<Evaluable> getComponents() {
        return this.components;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JoiningReplacement)) {
            return false;
        }
        JoiningReplacement other = (JoiningReplacement)o;
        List<Evaluable> this$components = this.getComponents();
        List<Evaluable> other$components = other.getComponents();
        if (this$components == null ? other$components != null : !((Object)this$components).equals(other$components)) {
            return false;
        }
        String this$delimiter = this.getDelimiter();
        String other$delimiter = other.getDelimiter();
        return !(this$delimiter == null ? other$delimiter != null : !this$delimiter.equals(other$delimiter));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Evaluable> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        String $delimiter = this.getDelimiter();
        result = result * 59 + ($delimiter == null ? 43 : $delimiter.hashCode());
        return result;
    }

    public String toString() {
        return "JoiningReplacement(components=" + this.getComponents() + ", delimiter=" + this.getDelimiter() + ")";
    }

    public static class JoiningReplacementBuilder {
        private ArrayList<Evaluable> components;
        private boolean delimiter$set;
        private String delimiter$value;

        JoiningReplacementBuilder() {
        }

        public JoiningReplacementBuilder component(Evaluable component) {
            if (this.components == null) {
                this.components = new ArrayList();
            }
            this.components.add(component);
            return this;
        }

        public JoiningReplacementBuilder components(Collection<? extends Evaluable> components) {
            if (components == null) {
                throw new NullPointerException("components cannot be null");
            }
            if (this.components == null) {
                this.components = new ArrayList();
            }
            this.components.addAll(components);
            return this;
        }

        public JoiningReplacementBuilder clearComponents() {
            if (this.components != null) {
                this.components.clear();
            }
            return this;
        }

        public JoiningReplacementBuilder delimiter(String delimiter) {
            this.delimiter$value = delimiter;
            this.delimiter$set = true;
            return this;
        }

        public JoiningReplacement build() {
            List<Evaluable> components;
            switch (this.components == null ? 0 : this.components.size()) {
                case 0: {
                    components = Collections.emptyList();
                    break;
                }
                case 1: {
                    components = Collections.singletonList(this.components.get(0));
                    break;
                }
                default: {
                    components = Collections.unmodifiableList(new ArrayList<Evaluable>(this.components));
                }
            }
            String delimiter$value = this.delimiter$value;
            if (!this.delimiter$set) {
                delimiter$value = JoiningReplacement.$default$delimiter();
            }
            return new JoiningReplacement(components, delimiter$value);
        }

        public String toString() {
            return "JoiningReplacement.JoiningReplacementBuilder(components=" + this.components + ", delimiter$value=" + this.delimiter$value + ")";
        }
    }
}

