/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.message.templating;

import com.google.common.net.UrlEscapers;
import dinkplugin.message.Field;
import dinkplugin.message.templating.Evaluable;
import dinkplugin.message.templating.impl.JoiningReplacement;
import java.util.Arrays;

public final class Replacements {
    public static Evaluable ofText(String text) {
        return new Text(text);
    }

    public static Evaluable ofLink(String text, String link) {
        return link != null ? new TextWithLink(text, link) : Replacements.ofText(text);
    }

    public static Evaluable ofWiki(String text, String searchPhrase) {
        return Replacements.ofLink(text, "https://oldschool.runescape.wiki/w/Special:Search?search=" + UrlEscapers.urlPathSegmentEscaper().escape(searchPhrase));
    }

    public static Evaluable ofWiki(String phrase) {
        return Replacements.ofWiki(phrase, phrase);
    }

    public static Evaluable ofBlock(String language, String content) {
        return new CodeBlock(language, content);
    }

    public static Evaluable ofMultiple(String delim, Evaluable ... components) {
        return JoiningReplacement.builder().delimiter(delim).components(Arrays.asList(components)).build();
    }

    private Replacements() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class CodeBlock
    implements Evaluable {
        private final String language;
        private final String text;

        @Override
        public String evaluate(boolean rich) {
            return rich ? Field.formatBlock(this.language, this.text) : this.text;
        }

        public CodeBlock(String language, String text) {
            this.language = language;
            this.text = text;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getText() {
            return this.text;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CodeBlock)) {
                return false;
            }
            CodeBlock other = (CodeBlock)o;
            String this$language = this.getLanguage();
            String other$language = other.getLanguage();
            if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $language = this.getLanguage();
            result = result * 59 + ($language == null ? 43 : $language.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        public String toString() {
            return "Replacements.CodeBlock(language=" + this.getLanguage() + ", text=" + this.getText() + ")";
        }
    }

    private static final class TextWithLink
    implements Evaluable {
        private final String text;
        private final String link;

        @Override
        public String evaluate(boolean rich) {
            return rich ? String.format("[%s](%s)", this.text, this.link) : this.text;
        }

        public TextWithLink(String text, String link) {
            this.text = text;
            this.link = link;
        }

        public String getText() {
            return this.text;
        }

        public String getLink() {
            return this.link;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TextWithLink)) {
                return false;
            }
            TextWithLink other = (TextWithLink)o;
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            String this$link = this.getLink();
            String other$link = other.getLink();
            return !(this$link == null ? other$link != null : !this$link.equals(other$link));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            String $link = this.getLink();
            result = result * 59 + ($link == null ? 43 : $link.hashCode());
            return result;
        }

        public String toString() {
            return "Replacements.TextWithLink(text=" + this.getText() + ", link=" + this.getLink() + ")";
        }
    }

    private static final class Text
    implements Evaluable {
        private final String text;

        @Override
        public String evaluate(boolean rich) {
            return this.text;
        }

        public Text(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Text)) {
                return false;
            }
            Text other = (Text)o;
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        public String toString() {
            return "Replacements.Text(text=" + this.getText() + ")";
        }
    }
}

