/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.message;

import com.google.gson.annotations.SerializedName;
import dinkplugin.domain.AccountType;
import dinkplugin.message.Embed;
import dinkplugin.message.NotificationType;
import dinkplugin.message.templating.Template;
import dinkplugin.notifiers.data.NotificationData;
import dinkplugin.util.DiscordProfile;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NotificationBody<T extends NotificationData> {
    static final int MAX_THREAD_NAME_LENGTH = 100;
    @NotNull
    private final NotificationType type;
    private final String playerName;
    private final AccountType accountType;
    private final String dinkAccountHash;
    @Nullable
    private final String clanName;
    @Nullable
    private final String groupIronClanName;
    private final boolean seasonalWorld;
    @Nullable
    private final T extra;
    @NotNull
    private final transient Template text;
    @Nullable
    private final DiscordProfile discordUser;
    @SerializedName(value="content")
    @Nullable
    private final String computedDiscordContent;
    @Nullable
    private final transient String thumbnailUrl;
    private final List<Embed> embeds;
    @SerializedName(value="thread_name")
    @Nullable
    private final String threadName;

    private static <T extends NotificationData> List<Embed> $default$embeds() {
        return new LinkedList<Embed>();
    }

    public static <T extends NotificationData> NotificationBodyBuilder<T> builder() {
        return new NotificationBodyBuilder();
    }

    public NotificationBodyBuilder<T> toBuilder() {
        return new NotificationBodyBuilder().type(this.type).playerName(this.playerName).accountType(this.accountType).dinkAccountHash(this.dinkAccountHash).clanName(this.clanName).groupIronClanName(this.groupIronClanName).seasonalWorld(this.seasonalWorld).extra(this.extra).text(this.text).discordUser(this.discordUser).computedDiscordContent(this.computedDiscordContent).thumbnailUrl(this.thumbnailUrl).embeds(this.embeds).threadName(this.threadName);
    }

    @NotNull
    public NotificationType getType() {
        return this.type;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public AccountType getAccountType() {
        return this.accountType;
    }

    public String getDinkAccountHash() {
        return this.dinkAccountHash;
    }

    @Nullable
    public String getClanName() {
        return this.clanName;
    }

    @Nullable
    public String getGroupIronClanName() {
        return this.groupIronClanName;
    }

    public boolean isSeasonalWorld() {
        return this.seasonalWorld;
    }

    @Nullable
    public T getExtra() {
        return this.extra;
    }

    @NotNull
    public Template getText() {
        return this.text;
    }

    @Nullable
    public DiscordProfile getDiscordUser() {
        return this.discordUser;
    }

    @Nullable
    public String getComputedDiscordContent() {
        return this.computedDiscordContent;
    }

    @Nullable
    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public List<Embed> getEmbeds() {
        return this.embeds;
    }

    @Nullable
    public String getThreadName() {
        return this.threadName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotificationBody)) {
            return false;
        }
        NotificationBody other = (NotificationBody)o;
        if (this.isSeasonalWorld() != other.isSeasonalWorld()) {
            return false;
        }
        NotificationType this$type = this.getType();
        NotificationType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$playerName = this.getPlayerName();
        String other$playerName = other.getPlayerName();
        if (this$playerName == null ? other$playerName != null : !this$playerName.equals(other$playerName)) {
            return false;
        }
        AccountType this$accountType = this.getAccountType();
        AccountType other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !((Object)((Object)this$accountType)).equals((Object)other$accountType)) {
            return false;
        }
        String this$dinkAccountHash = this.getDinkAccountHash();
        String other$dinkAccountHash = other.getDinkAccountHash();
        if (this$dinkAccountHash == null ? other$dinkAccountHash != null : !this$dinkAccountHash.equals(other$dinkAccountHash)) {
            return false;
        }
        String this$clanName = this.getClanName();
        String other$clanName = other.getClanName();
        if (this$clanName == null ? other$clanName != null : !this$clanName.equals(other$clanName)) {
            return false;
        }
        String this$groupIronClanName = this.getGroupIronClanName();
        String other$groupIronClanName = other.getGroupIronClanName();
        if (this$groupIronClanName == null ? other$groupIronClanName != null : !this$groupIronClanName.equals(other$groupIronClanName)) {
            return false;
        }
        T this$extra = this.getExtra();
        T other$extra = other.getExtra();
        if (this$extra == null ? other$extra != null : !this$extra.equals(other$extra)) {
            return false;
        }
        Template this$text = this.getText();
        Template other$text = other.getText();
        if (this$text == null ? other$text != null : !((Object)this$text).equals(other$text)) {
            return false;
        }
        DiscordProfile this$discordUser = this.getDiscordUser();
        DiscordProfile other$discordUser = other.getDiscordUser();
        if (this$discordUser == null ? other$discordUser != null : !((Object)this$discordUser).equals(other$discordUser)) {
            return false;
        }
        String this$computedDiscordContent = this.getComputedDiscordContent();
        String other$computedDiscordContent = other.getComputedDiscordContent();
        if (this$computedDiscordContent == null ? other$computedDiscordContent != null : !this$computedDiscordContent.equals(other$computedDiscordContent)) {
            return false;
        }
        List<Embed> this$embeds = this.getEmbeds();
        List<Embed> other$embeds = other.getEmbeds();
        if (this$embeds == null ? other$embeds != null : !((Object)this$embeds).equals(other$embeds)) {
            return false;
        }
        String this$threadName = this.getThreadName();
        String other$threadName = other.getThreadName();
        return !(this$threadName == null ? other$threadName != null : !this$threadName.equals(other$threadName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSeasonalWorld() ? 79 : 97);
        NotificationType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $playerName = this.getPlayerName();
        result = result * 59 + ($playerName == null ? 43 : $playerName.hashCode());
        AccountType $accountType = this.getAccountType();
        result = result * 59 + ($accountType == null ? 43 : ((Object)((Object)$accountType)).hashCode());
        String $dinkAccountHash = this.getDinkAccountHash();
        result = result * 59 + ($dinkAccountHash == null ? 43 : $dinkAccountHash.hashCode());
        String $clanName = this.getClanName();
        result = result * 59 + ($clanName == null ? 43 : $clanName.hashCode());
        String $groupIronClanName = this.getGroupIronClanName();
        result = result * 59 + ($groupIronClanName == null ? 43 : $groupIronClanName.hashCode());
        T $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : $extra.hashCode());
        Template $text = this.getText();
        result = result * 59 + ($text == null ? 43 : ((Object)$text).hashCode());
        DiscordProfile $discordUser = this.getDiscordUser();
        result = result * 59 + ($discordUser == null ? 43 : ((Object)$discordUser).hashCode());
        String $computedDiscordContent = this.getComputedDiscordContent();
        result = result * 59 + ($computedDiscordContent == null ? 43 : $computedDiscordContent.hashCode());
        List<Embed> $embeds = this.getEmbeds();
        result = result * 59 + ($embeds == null ? 43 : ((Object)$embeds).hashCode());
        String $threadName = this.getThreadName();
        result = result * 59 + ($threadName == null ? 43 : $threadName.hashCode());
        return result;
    }

    public String toString() {
        return "NotificationBody(type=" + this.getType() + ", playerName=" + this.getPlayerName() + ", accountType=" + this.getAccountType() + ", dinkAccountHash=" + this.getDinkAccountHash() + ", clanName=" + this.getClanName() + ", groupIronClanName=" + this.getGroupIronClanName() + ", seasonalWorld=" + this.isSeasonalWorld() + ", extra=" + this.getExtra() + ", text=" + this.getText() + ", discordUser=" + this.getDiscordUser() + ", computedDiscordContent=" + this.getComputedDiscordContent() + ", thumbnailUrl=" + this.getThumbnailUrl() + ", embeds=" + this.getEmbeds() + ", threadName=" + this.getThreadName() + ")";
    }

    public NotificationBody<T> withType(@NotNull NotificationType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.type == type ? this : new NotificationBody<T>(type, this.playerName, this.accountType, this.dinkAccountHash, this.clanName, this.groupIronClanName, this.seasonalWorld, this.extra, this.text, this.discordUser, this.computedDiscordContent, this.thumbnailUrl, this.embeds, this.threadName);
    }

    public NotificationBody<T> withPlayerName(String playerName) {
        return this.playerName == playerName ? this : new NotificationBody<T>(this.type, playerName, this.accountType, this.dinkAccountHash, this.clanName, this.groupIronClanName, this.seasonalWorld, this.extra, this.text, this.discordUser, this.computedDiscordContent, this.thumbnailUrl, this.embeds, this.threadName);
    }

    public NotificationBody<T> withAccountType(AccountType accountType) {
        return this.accountType == accountType ? this : new NotificationBody<T>(this.type, this.playerName, accountType, this.dinkAccountHash, this.clanName, this.groupIronClanName, this.seasonalWorld, this.extra, this.text, this.discordUser, this.computedDiscordContent, this.thumbnailUrl, this.embeds, this.threadName);
    }

    public NotificationBody<T> withDinkAccountHash(String dinkAccountHash) {
        return this.dinkAccountHash == dinkAccountHash ? this : new NotificationBody<T>(this.type, this.playerName, this.accountType, dinkAccountHash, this.clanName, this.groupIronClanName, this.seasonalWorld, this.extra, this.text, this.discordUser, this.computedDiscordContent, this.thumbnailUrl, this.embeds, this.threadName);
    }

    public NotificationBody<T> withClanName(@Nullable String clanName) {
        return this.clanName == clanName ? this : new NotificationBody<T>(this.type, this.playerName, this.accountType, this.dinkAccountHash, clanName, this.groupIronClanName, this.seasonalWorld, this.extra, this.text, this.discordUser, this.computedDiscordContent, this.thumbnailUrl, this.embeds, this.threadName);
    }

    public NotificationBody<T> withGroupIronClanName(@Nullable String groupIronClanName) {
        return this.groupIronClanName == groupIronClanName ? this : new NotificationBody<T>(this.type, this.playerName, this.accountType, this.dinkAccountHash, this.clanName, groupIronClanName, this.seasonalWorld, this.extra, this.text, this.discordUser, this.computedDiscordContent, this.thumbnailUrl, this.embeds, this.threadName);
    }

    public NotificationBody<T> withSeasonalWorld(boolean seasonalWorld) {
        return this.seasonalWorld == seasonalWorld ? this : new NotificationBody<T>(this.type, this.playerName, this.accountType, this.dinkAccountHash, this.clanName, this.groupIronClanName, seasonalWorld, this.extra, this.text, this.discordUser, this.computedDiscordContent, this.thumbnailUrl, this.embeds, this.threadName);
    }

    public NotificationBody<T> withExtra(@Nullable T extra) {
        return this.extra == extra ? this : new NotificationBody<T>(this.type, this.playerName, this.accountType, this.dinkAccountHash, this.clanName, this.groupIronClanName, this.seasonalWorld, extra, this.text, this.discordUser, this.computedDiscordContent, this.thumbnailUrl, this.embeds, this.threadName);
    }

    public NotificationBody<T> withText(@NotNull Template text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return this.text == text ? this : new NotificationBody<T>(this.type, this.playerName, this.accountType, this.dinkAccountHash, this.clanName, this.groupIronClanName, this.seasonalWorld, this.extra, text, this.discordUser, this.computedDiscordContent, this.thumbnailUrl, this.embeds, this.threadName);
    }

    public NotificationBody<T> withDiscordUser(@Nullable DiscordProfile discordUser) {
        return this.discordUser == discordUser ? this : new NotificationBody<T>(this.type, this.playerName, this.accountType, this.dinkAccountHash, this.clanName, this.groupIronClanName, this.seasonalWorld, this.extra, this.text, discordUser, this.computedDiscordContent, this.thumbnailUrl, this.embeds, this.threadName);
    }

    public NotificationBody<T> withComputedDiscordContent(@Nullable String computedDiscordContent) {
        return this.computedDiscordContent == computedDiscordContent ? this : new NotificationBody<T>(this.type, this.playerName, this.accountType, this.dinkAccountHash, this.clanName, this.groupIronClanName, this.seasonalWorld, this.extra, this.text, this.discordUser, computedDiscordContent, this.thumbnailUrl, this.embeds, this.threadName);
    }

    public NotificationBody<T> withThumbnailUrl(@Nullable String thumbnailUrl) {
        return this.thumbnailUrl == thumbnailUrl ? this : new NotificationBody<T>(this.type, this.playerName, this.accountType, this.dinkAccountHash, this.clanName, this.groupIronClanName, this.seasonalWorld, this.extra, this.text, this.discordUser, this.computedDiscordContent, thumbnailUrl, this.embeds, this.threadName);
    }

    public NotificationBody<T> withEmbeds(List<Embed> embeds) {
        return this.embeds == embeds ? this : new NotificationBody<T>(this.type, this.playerName, this.accountType, this.dinkAccountHash, this.clanName, this.groupIronClanName, this.seasonalWorld, this.extra, this.text, this.discordUser, this.computedDiscordContent, this.thumbnailUrl, embeds, this.threadName);
    }

    public NotificationBody<T> withThreadName(@Nullable String threadName) {
        return this.threadName == threadName ? this : new NotificationBody<T>(this.type, this.playerName, this.accountType, this.dinkAccountHash, this.clanName, this.groupIronClanName, this.seasonalWorld, this.extra, this.text, this.discordUser, this.computedDiscordContent, this.thumbnailUrl, this.embeds, threadName);
    }

    public NotificationBody(@NotNull NotificationType type, String playerName, AccountType accountType, String dinkAccountHash, @Nullable String clanName, @Nullable String groupIronClanName, boolean seasonalWorld, @Nullable T extra, @NotNull Template text, @Nullable DiscordProfile discordUser, @Nullable String computedDiscordContent, @Nullable String thumbnailUrl, List<Embed> embeds, @Nullable String threadName) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.type = type;
        this.playerName = playerName;
        this.accountType = accountType;
        this.dinkAccountHash = dinkAccountHash;
        this.clanName = clanName;
        this.groupIronClanName = groupIronClanName;
        this.seasonalWorld = seasonalWorld;
        this.extra = extra;
        this.text = text;
        this.discordUser = discordUser;
        this.computedDiscordContent = computedDiscordContent;
        this.thumbnailUrl = thumbnailUrl;
        this.embeds = embeds;
        this.threadName = threadName;
    }

    public static class NotificationBodyBuilder<T extends NotificationData> {
        private NotificationType type;
        private String playerName;
        private AccountType accountType;
        private String dinkAccountHash;
        private String clanName;
        private String groupIronClanName;
        private boolean seasonalWorld;
        private T extra;
        private Template text;
        private DiscordProfile discordUser;
        private String computedDiscordContent;
        private String thumbnailUrl;
        private boolean embeds$set;
        private List<Embed> embeds$value;
        private String threadName;

        NotificationBodyBuilder() {
        }

        public NotificationBodyBuilder<T> type(@NotNull NotificationType type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        public NotificationBodyBuilder<T> playerName(String playerName) {
            this.playerName = playerName;
            return this;
        }

        public NotificationBodyBuilder<T> accountType(AccountType accountType) {
            this.accountType = accountType;
            return this;
        }

        public NotificationBodyBuilder<T> dinkAccountHash(String dinkAccountHash) {
            this.dinkAccountHash = dinkAccountHash;
            return this;
        }

        public NotificationBodyBuilder<T> clanName(@Nullable String clanName) {
            this.clanName = clanName;
            return this;
        }

        public NotificationBodyBuilder<T> groupIronClanName(@Nullable String groupIronClanName) {
            this.groupIronClanName = groupIronClanName;
            return this;
        }

        public NotificationBodyBuilder<T> seasonalWorld(boolean seasonalWorld) {
            this.seasonalWorld = seasonalWorld;
            return this;
        }

        public NotificationBodyBuilder<T> extra(@Nullable T extra) {
            this.extra = extra;
            return this;
        }

        public NotificationBodyBuilder<T> text(@NotNull Template text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
            return this;
        }

        public NotificationBodyBuilder<T> discordUser(@Nullable DiscordProfile discordUser) {
            this.discordUser = discordUser;
            return this;
        }

        public NotificationBodyBuilder<T> computedDiscordContent(@Nullable String computedDiscordContent) {
            this.computedDiscordContent = computedDiscordContent;
            return this;
        }

        public NotificationBodyBuilder<T> thumbnailUrl(@Nullable String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
            return this;
        }

        public NotificationBodyBuilder<T> embeds(List<Embed> embeds) {
            this.embeds$value = embeds;
            this.embeds$set = true;
            return this;
        }

        public NotificationBodyBuilder<T> threadName(@Nullable String threadName) {
            this.threadName = threadName;
            return this;
        }

        public NotificationBody<T> build() {
            List<Embed> embeds$value = this.embeds$value;
            if (!this.embeds$set) {
                embeds$value = NotificationBody.$default$embeds();
            }
            return new NotificationBody<T>(this.type, this.playerName, this.accountType, this.dinkAccountHash, this.clanName, this.groupIronClanName, this.seasonalWorld, this.extra, this.text, this.discordUser, this.computedDiscordContent, this.thumbnailUrl, embeds$value, this.threadName);
        }

        public String toString() {
            return "NotificationBody.NotificationBodyBuilder(type=" + this.type + ", playerName=" + this.playerName + ", accountType=" + this.accountType + ", dinkAccountHash=" + this.dinkAccountHash + ", clanName=" + this.clanName + ", groupIronClanName=" + this.groupIronClanName + ", seasonalWorld=" + this.seasonalWorld + ", extra=" + this.extra + ", text=" + this.text + ", discordUser=" + this.discordUser + ", computedDiscordContent=" + this.computedDiscordContent + ", thumbnailUrl=" + this.thumbnailUrl + ", embeds$value=" + this.embeds$value + ", threadName=" + this.threadName + ")";
        }
    }
}

