/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.message;

import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Field {
    @NotNull
    private final String name;
    @NotNull
    private final String value;
    @Nullable
    private final Boolean inline;

    public Field(String name, String value) {
        this(name, value, true);
    }

    public static String formatBlock(String codeBlockLanguage, String content) {
        return String.format("```%s\n%s\n```", StringUtils.defaultString((String)codeBlockLanguage), content);
    }

    public static String formatProgress(int completed, int total) {
        assert (total != 0);
        double percent = 100.0 * (double)completed / (double)total;
        return Field.formatBlock("", String.format("%d/%d (%.1f%%)", completed, total, percent));
    }

    public static FieldBuilder builder() {
        return new FieldBuilder();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getValue() {
        return this.value;
    }

    @Nullable
    public Boolean getInline() {
        return this.inline;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Field)) {
            return false;
        }
        Field other = (Field)o;
        Boolean this$inline = this.getInline();
        Boolean other$inline = other.getInline();
        if (this$inline == null ? other$inline != null : !((Object)this$inline).equals(other$inline)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $inline = this.getInline();
        result = result * 59 + ($inline == null ? 43 : ((Object)$inline).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "Field(name=" + this.getName() + ", value=" + this.getValue() + ", inline=" + this.getInline() + ")";
    }

    public Field(@NotNull String name, @NotNull String value, @Nullable Boolean inline) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.name = name;
        this.value = value;
        this.inline = inline;
    }

    public static class FieldBuilder {
        private String name;
        private String value;
        private Boolean inline;

        FieldBuilder() {
        }

        public FieldBuilder name(@NotNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public FieldBuilder value(@NotNull String value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
            return this;
        }

        public FieldBuilder inline(@Nullable Boolean inline) {
            this.inline = inline;
            return this;
        }

        public Field build() {
            return new Field(this.name, this.value, this.inline);
        }

        public String toString() {
            return "Field.FieldBuilder(name=" + this.name + ", value=" + this.value + ", inline=" + this.inline + ")";
        }
    }
}

