/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.message;

import com.google.gson.annotations.JsonAdapter;
import dinkplugin.message.Author;
import dinkplugin.message.Field;
import dinkplugin.message.Footer;
import dinkplugin.util.ColorAdapter;
import dinkplugin.util.InstantAdapter;
import java.awt.Color;
import java.time.Instant;
import java.util.List;

public final class Embed {
    public static final int MAX_IMAGE_SIZE = 8000000;
    public static final int MAX_DESCRIPTION_LENGTH = 4096;
    public static final int MAX_FOOTER_LENGTH = 2048;
    private final String title;
    private final String description;
    private final Author author;
    @JsonAdapter(value=ColorAdapter.class)
    private final Color color;
    private final UrlEmbed image;
    private final UrlEmbed thumbnail;
    private final List<Field> fields;
    private final Footer footer;
    @JsonAdapter(value=InstantAdapter.class)
    private final Instant timestamp;

    public static Embed ofImage(String url) {
        return Embed.builder().image(new UrlEmbed(url)).build();
    }

    Embed(String title, String description, Author author, Color color, UrlEmbed image, UrlEmbed thumbnail, List<Field> fields, Footer footer, Instant timestamp) {
        this.title = title;
        this.description = description;
        this.author = author;
        this.color = color;
        this.image = image;
        this.thumbnail = thumbnail;
        this.fields = fields;
        this.footer = footer;
        this.timestamp = timestamp;
    }

    public static EmbedBuilder builder() {
        return new EmbedBuilder();
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public Author getAuthor() {
        return this.author;
    }

    public Color getColor() {
        return this.color;
    }

    public UrlEmbed getImage() {
        return this.image;
    }

    public UrlEmbed getThumbnail() {
        return this.thumbnail;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public Footer getFooter() {
        return this.footer;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Embed)) {
            return false;
        }
        Embed other = (Embed)o;
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Author this$author = this.getAuthor();
        Author other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !((Object)this$author).equals(other$author)) {
            return false;
        }
        Color this$color = this.getColor();
        Color other$color = other.getColor();
        if (this$color == null ? other$color != null : !((Object)this$color).equals(other$color)) {
            return false;
        }
        UrlEmbed this$image = this.getImage();
        UrlEmbed other$image = other.getImage();
        if (this$image == null ? other$image != null : !((Object)this$image).equals(other$image)) {
            return false;
        }
        UrlEmbed this$thumbnail = this.getThumbnail();
        UrlEmbed other$thumbnail = other.getThumbnail();
        if (this$thumbnail == null ? other$thumbnail != null : !((Object)this$thumbnail).equals(other$thumbnail)) {
            return false;
        }
        List<Field> this$fields = this.getFields();
        List<Field> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        Footer this$footer = this.getFooter();
        Footer other$footer = other.getFooter();
        if (this$footer == null ? other$footer != null : !((Object)this$footer).equals(other$footer)) {
            return false;
        }
        Instant this$timestamp = this.getTimestamp();
        Instant other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Author $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : ((Object)$author).hashCode());
        Color $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
        UrlEmbed $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : ((Object)$image).hashCode());
        UrlEmbed $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : ((Object)$thumbnail).hashCode());
        List<Field> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        Footer $footer = this.getFooter();
        result = result * 59 + ($footer == null ? 43 : ((Object)$footer).hashCode());
        Instant $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        return result;
    }

    public String toString() {
        return "Embed(title=" + this.getTitle() + ", description=" + this.getDescription() + ", author=" + this.getAuthor() + ", color=" + this.getColor() + ", image=" + this.getImage() + ", thumbnail=" + this.getThumbnail() + ", fields=" + this.getFields() + ", footer=" + this.getFooter() + ", timestamp=" + this.getTimestamp() + ")";
    }

    public static class EmbedBuilder {
        private String title;
        private String description;
        private Author author;
        private Color color;
        private UrlEmbed image;
        private UrlEmbed thumbnail;
        private List<Field> fields;
        private Footer footer;
        private Instant timestamp;

        EmbedBuilder() {
        }

        public EmbedBuilder title(String title) {
            this.title = title;
            return this;
        }

        public EmbedBuilder description(String description) {
            this.description = description;
            return this;
        }

        public EmbedBuilder author(Author author) {
            this.author = author;
            return this;
        }

        public EmbedBuilder color(Color color) {
            this.color = color;
            return this;
        }

        public EmbedBuilder image(UrlEmbed image) {
            this.image = image;
            return this;
        }

        public EmbedBuilder thumbnail(UrlEmbed thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        public EmbedBuilder fields(List<Field> fields) {
            this.fields = fields;
            return this;
        }

        public EmbedBuilder footer(Footer footer) {
            this.footer = footer;
            return this;
        }

        public EmbedBuilder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Embed build() {
            return new Embed(this.title, this.description, this.author, this.color, this.image, this.thumbnail, this.fields, this.footer, this.timestamp);
        }

        public String toString() {
            return "Embed.EmbedBuilder(title=" + this.title + ", description=" + this.description + ", author=" + this.author + ", color=" + this.color + ", image=" + this.image + ", thumbnail=" + this.thumbnail + ", fields=" + this.fields + ", footer=" + this.footer + ", timestamp=" + this.timestamp + ")";
        }
    }

    public static final class UrlEmbed {
        private final String url;

        public UrlEmbed(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UrlEmbed)) {
                return false;
            }
            UrlEmbed other = (UrlEmbed)o;
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        public String toString() {
            return "Embed.UrlEmbed(url=" + this.getUrl() + ")";
        }
    }
}

