/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.message;

import com.google.gson.Gson;
import dinkplugin.DinkPlugin;
import dinkplugin.DinkPluginConfig;
import dinkplugin.domain.PlayerLookupService;
import dinkplugin.message.Author;
import dinkplugin.message.DiscordErrorMessage;
import dinkplugin.message.Embed;
import dinkplugin.message.Footer;
import dinkplugin.message.NotificationBody;
import dinkplugin.message.NotificationType;
import dinkplugin.message.templating.Replacements;
import dinkplugin.message.templating.Template;
import dinkplugin.notifiers.data.NotificationData;
import dinkplugin.util.DiscordProfile;
import dinkplugin.util.Utils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.WorldType;
import net.runelite.api.clan.ClanChannel;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.discord.DiscordService;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.util.ImageUtil;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DiscordMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(DiscordMessageHandler.class);
    private final Gson gson;
    private final Client client;
    private final DrawManager drawManager;
    private final OkHttpClient httpClient;
    private final DinkPluginConfig config;
    private final ScheduledExecutorService executor;
    private final ClientThread clientThread;
    private final DiscordService discordService;

    @Inject
    @VisibleForTesting
    public DiscordMessageHandler(Gson gson, Client client, DrawManager drawManager, OkHttpClient httpClient, DinkPluginConfig config, ScheduledExecutorService executor, ClientThread clientThread, DiscordService discordService) {
        this.gson = gson;
        this.client = client;
        this.drawManager = drawManager;
        this.config = config;
        this.executor = executor;
        this.clientThread = clientThread;
        this.discordService = discordService;
        this.httpClient = httpClient.newBuilder().addInterceptor(chain -> {
            Request request = chain.request().newBuilder().header("User-Agent", DinkPlugin.USER_AGENT).build();
            Interceptor.Chain updatedChain = chain;
            if (request.body() instanceof MultipartBody && Utils.hasImage((MultipartBody)request.body())) {
                updatedChain = chain.withWriteTimeout(Math.max(config.imageWriteTimeout(), 0), TimeUnit.SECONDS);
            }
            return updatedChain.proceed(request);
        }).build();
    }

    public void createMessage(String webhookUrl, boolean sendImage, @NonNull NotificationBody<?> inputBody) {
        if (inputBody == null) {
            throw new NullPointerException("inputBody is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)webhookUrl)) {
            return;
        }
        Collection urlList = Arrays.stream(StringUtils.split((String)webhookUrl, (char)'\n')).filter(StringUtils::isNotBlank).map(HttpUrl::parse).filter(Objects::nonNull).collect(Collectors.toList());
        if (urlList.isEmpty()) {
            return;
        }
        NotificationBody<?> mBody = this.enrichBody(inputBody, sendImage);
        if (sendImage) {
            boolean chatHidden = DiscordMessageHandler.hideWidget(this.config.screenshotHideChat(), this.client, 0xA20022);
            boolean whispersHidden = DiscordMessageHandler.hideWidget(this.config.screenshotHideChat(), this.client, Utils.packWidget(163, 0));
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)DiscordMessageHandler.captureScreenshot(this.drawManager, (double)this.config.screenshotScale() / 100.0).thenApply(image -> RequestBody.create((MediaType)MediaType.parse((String)("image/" + (String)image.getKey())), (byte[])((byte[])image.getValue())))).exceptionally(e -> {
                log.warn("There was an error creating bytes from captured image", e);
                return null;
            })).thenApply(image -> {
                DiscordMessageHandler.unhideWidget(chatHidden, this.client, this.clientThread, 0xA20022);
                DiscordMessageHandler.unhideWidget(whispersHidden, this.client, this.clientThread, Utils.packWidget(163, 0));
                return image;
            })).thenAccept(image -> this.sendToMultiple(urlList, mBody, (RequestBody)image));
        } else {
            this.sendToMultiple(urlList, mBody, null);
        }
    }

    private void sendToMultiple(Collection<HttpUrl> urls, NotificationBody<?> body, @Nullable RequestBody image) {
        urls.forEach(url -> this.sendMessage((HttpUrl)url, this.injectThreadName((HttpUrl)url, body, false), image, 0));
    }

    private void sendMessage(HttpUrl url, NotificationBody<?> mBody, @Nullable RequestBody image, int attempt) {
        BiConsumer<NotificationBody, Throwable> retry = (body, e) -> {
            int maxRetries;
            log.trace(String.format("Failed to send webhook message to %s on attempt %d", url, attempt), e);
            if (attempt == 0) {
                log.warn("There was an error sending the webhook message", e);
            }
            if (attempt < (maxRetries = this.config.maxRetries())) {
                long baseDelay = this.config.baseRetryDelay();
                if (baseDelay > 0L) {
                    long delay = baseDelay * (1L << Math.min(attempt, 16));
                    this.executor.schedule(() -> this.sendMessage(url, (NotificationBody<?>)body, image, attempt + 1), delay, TimeUnit.MILLISECONDS);
                    log.debug("Scheduled webhook message for retry in {} milliseconds", (Object)delay);
                } else {
                    log.debug("Skipping retry attempts for failed webhook since base delay is not positive");
                }
            } else if (maxRetries > 0) {
                log.warn("Exhausted retry attempts when sending the webhook message", e);
            } else {
                log.debug("Skipping retry attempts for failed webhook since max retries is not positive");
            }
        };
        this.executor.execute(() -> {
            Request request = new Request.Builder().url(url).post((RequestBody)this.createBody(mBody, image)).build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (response.isSuccessful()) {
                    log.trace("Successfully sent webhook message to {} after {} attempts", (Object)url, (Object)(attempt + 1));
                } else {
                    String body;
                    String string = body = response.body() != null ? response.body().string() : null;
                    if (response.code() == 400 && "application/json".equals(response.header("Content-Type"))) {
                        DiscordErrorMessage error = (DiscordErrorMessage)this.gson.fromJson(body, DiscordErrorMessage.class);
                        if (error.getCode() == 220001) {
                            retry.accept(this.injectThreadName(url, mBody, true), new RuntimeException(error.getMessage()));
                            return;
                        }
                        if (error.getCode() == 220003) {
                            retry.accept(mBody.withThreadName(null), new RuntimeException(error.getMessage()));
                            return;
                        }
                    }
                    retry.accept(mBody, new RuntimeException(String.format("Received unsuccessful http response: %d - %s - %s", response.code(), response.message(), body)));
                }
            }
            catch (Exception e) {
                retry.accept(mBody, e);
            }
        });
    }

    private NotificationBody<?> enrichBody(NotificationBody<?> mBody, boolean sendImage) {
        ClanChannel gim;
        ClanChannel clan;
        long id;
        if (mBody.getPlayerName() == null) {
            mBody = mBody.withPlayerName(Utils.getPlayerName(this.client));
        }
        if (mBody.getAccountType() == null) {
            mBody = mBody.withAccountType(Utils.getAccountType(this.client));
        }
        if (mBody.getDinkAccountHash() == null && (id = this.client.getAccountHash()) != -1L) {
            mBody = mBody.withDinkAccountHash(Utils.dinkHash(id));
        }
        if (!this.config.ignoreSeasonal() && !mBody.isSeasonalWorld() && this.client.getWorldType().contains(WorldType.SEASONAL)) {
            mBody = mBody.withSeasonalWorld(true);
        }
        NotificationBody.NotificationBodyBuilder<?> builder = mBody.toBuilder();
        if (this.config.sendDiscordUser()) {
            builder.discordUser(DiscordProfile.of(this.discordService.getCurrentUser()));
        }
        if (this.config.sendClanName() && (clan = this.client.getClanChannel(0)) != null) {
            builder.clanName(clan.getName());
        }
        if (this.config.sendGroupIronClanName() && (gim = this.client.getClanChannel(1)) != null) {
            builder.groupIronClanName(gim.getName());
        }
        if (this.config.discordRichEmbeds()) {
            builder.embeds(DiscordMessageHandler.computeEmbeds(mBody, sendImage, this.config));
        } else {
            builder.computedDiscordContent(mBody.getText().evaluate(false));
        }
        return builder.build();
    }

    private NotificationBody<?> injectThreadName(HttpUrl url, NotificationBody<?> mBody, boolean force) {
        Set queryParams = url.queryParameterNames();
        if (force || queryParams.contains("forum") && !queryParams.contains("thread_id")) {
            Object type = mBody.isSeasonalWorld() ? "Seasonal - " + mBody.getType().getTitle() : mBody.getType().getTitle();
            String threadName = Template.builder().template(this.config.threadNameTemplate()).replacementBoundary("%").replacement("%TYPE%", Replacements.ofText((String)type)).replacement("%MESSAGE%", mBody.getText()).replacement("%USERNAME%", Replacements.ofText(mBody.getPlayerName())).build().evaluate(false);
            return mBody.withThreadName(Utils.truncate(StringUtils.normalizeSpace((String)threadName), 100));
        }
        return mBody;
    }

    private MultipartBody createBody(NotificationBody<?> mBody, @Nullable RequestBody image) {
        MultipartBody.Builder requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", this.gson.toJson(mBody));
        if (image != null) {
            String screenshotFileName = mBody.getType().getScreenshot();
            requestBody.addFormDataPart("file", screenshotFileName, image);
        }
        return requestBody.build();
    }

    private static CompletableFuture<Map.Entry<String, byte[]>> captureScreenshot(DrawManager drawManager, double scalePercent) {
        CompletableFuture future = new CompletableFuture();
        drawManager.requestNextFrameListener(future::complete);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)future.thenApply(ImageUtil::bufferedImageFromImage)).thenApply(input -> Utils.rescale(input, scalePercent))).thenApply(image -> {
            try {
                String format = "png";
                return Pair.of((Object)format, (Object)Utils.convertImageToByteArray(image, format));
            }
            catch (IOException e) {
                throw new CompletionException("Could not convert image to byte array", e);
            }
        })).thenApply(pair -> {
            Pair pair2;
            byte[] bytes = (byte[])pair.getValue();
            int n = bytes.length;
            if (n <= 8000000) {
                return pair;
            }
            double factor = Math.sqrt(8000000.0 / (double)n);
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            try {
                String format = "jpeg";
                BufferedImage rescaled = Utils.rescale(ImageIO.read(is), factor);
                pair2 = Pair.of((Object)format, (Object)Utils.convertImageToByteArray(rescaled, format));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CompletionException("Failed to resize image below Discord size limit", e);
                }
            }
            ((InputStream)is).close();
            return pair2;
        });
    }

    private static List<Embed> computeEmbeds(@NotNull NotificationBody<?> body, boolean screenshot, DinkPluginConfig config) {
        NotificationType type = body.getType();
        Object extra = body.getExtra();
        String footerText = config.embedFooterText();
        String footerIcon = config.embedFooterIcon();
        PlayerLookupService playerLookupService = config.playerLookupService();
        Author author = Author.builder().name(body.getPlayerName()).url(playerLookupService.getPlayerUrl(body.getPlayerName())).iconUrl(Utils.getChatBadge(body.getAccountType(), body.isSeasonalWorld())).build();
        Footer footer = StringUtils.isBlank((CharSequence)footerText) ? null : Footer.builder().text(Utils.truncate(footerText, 2048)).iconUrl(StringUtils.isBlank((CharSequence)footerIcon) ? null : footerIcon).build();
        String thumbnail = body.getThumbnailUrl() != null ? body.getThumbnailUrl() : type.getThumbnail();
        ArrayList<Embed> embeds = new ArrayList<Embed>(body.getEmbeds() != null ? body.getEmbeds() : Collections.emptyList());
        embeds.add(0, Embed.builder().author(author).color(Utils.PINK).title((String)(body.isSeasonalWorld() ? "[Seasonal] " + type.getTitle() : type.getTitle())).description(Utils.truncate(body.getText().evaluate(config.discordRichEmbeds()), 4096)).image(screenshot ? new Embed.UrlEmbed("attachment://" + type.getScreenshot()) : null).thumbnail(new Embed.UrlEmbed(thumbnail)).fields(extra != null ? ((NotificationData)extra).getFields() : Collections.emptyList()).footer(footer).timestamp(footer != null ? Instant.now() : null).build());
        return embeds;
    }

    private static boolean hideWidget(boolean shouldHide, Client client, int info) {
        if (!shouldHide) {
            return false;
        }
        Widget widget = client.getWidget(info);
        if (widget == null || widget.isHidden()) {
            return false;
        }
        widget.setHidden(true);
        return true;
    }

    private static void unhideWidget(boolean shouldUnhide, Client client, ClientThread clientThread, int info) {
        if (!shouldUnhide) {
            return;
        }
        clientThread.invoke(() -> {
            Widget widget = client.getWidget(info);
            if (widget != null) {
                widget.setHidden(false);
            }
        });
    }
}

