/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.domain;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum LeagueTaskDifficulty {
    EASY(10),
    MEDIUM(40),
    HARD(80),
    ELITE(200),
    MASTER(400);

    private final int points;
    private final String displayName = this.name().charAt(0) + this.name().substring(1).toLowerCase();
    public static final Map<String, LeagueTaskDifficulty> TIER_BY_LOWER_NAME;

    public String toString() {
        return this.displayName;
    }

    public int getPoints() {
        return this.points;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    private LeagueTaskDifficulty(int points) {
        this.points = points;
    }

    static {
        TIER_BY_LOWER_NAME = Collections.unmodifiableMap(Arrays.stream(LeagueTaskDifficulty.values()).collect(Collectors.toMap(t -> t.name().toLowerCase(), Function.identity())));
    }
}

