/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.domain;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum AchievementDiary {
    ARDOUGNE_EASY(4458, 1, "Ardougne", Difficulty.EASY),
    ARDOUGNE_MEDIUM(4459, 1, "Ardougne", Difficulty.MEDIUM),
    ARDOUGNE_HARD(4460, 1, "Ardougne", Difficulty.HARD),
    ARDOUGNE_ELITE(4461, 1, "Ardougne", Difficulty.ELITE),
    DESERT_EASY(4483, 5, "Desert", Difficulty.EASY),
    DESERT_MEDIUM(4484, 5, "Desert", Difficulty.MEDIUM),
    DESERT_HARD(4485, 5, "Desert", Difficulty.HARD),
    DESERT_ELITE(4486, 5, "Desert", Difficulty.ELITE),
    FALADOR_EASY(4462, 2, "Falador", Difficulty.EASY),
    FALADOR_MEDIUM(4463, 2, "Falador", Difficulty.MEDIUM),
    FALADOR_HARD(4464, 2, "Falador", Difficulty.HARD),
    FALADOR_ELITE(4465, 2, "Falador", Difficulty.ELITE),
    FREMENNIK_EASY(4491, 3, "Fremennik", Difficulty.EASY),
    FREMENNIK_MEDIUM(4492, 3, "Fremennik", Difficulty.MEDIUM),
    FREMENNIK_HARD(4493, 3, "Fremennik", Difficulty.HARD),
    FREMENNIK_ELITE(4494, 3, "Fremennik", Difficulty.ELITE),
    KANDARIN_EASY(4475, 4, "Kandarin", Difficulty.EASY),
    KANDARIN_MEDIUM(4476, 4, "Kandarin", Difficulty.MEDIUM),
    KANDARIN_HARD(4477, 4, "Kandarin", Difficulty.HARD),
    KANDARIN_ELITE(4478, 4, "Kandarin", Difficulty.ELITE),
    KARAMJA_EASY(3578, 0, "Karamja", Difficulty.EASY),
    KARAMJA_MEDIUM(3599, 0, "Karamja", Difficulty.MEDIUM),
    KARAMJA_HARD(3611, 0, "Karamja", Difficulty.HARD),
    KARAMJA_ELITE(4566, 0, "Karamja", Difficulty.ELITE),
    KOUREND_EASY(7925, 11, "Kourend & Kebos", Difficulty.EASY),
    KOUREND_MEDIUM(7926, 11, "Kourend & Kebos", Difficulty.MEDIUM),
    KOUREND_HARD(7927, 11, "Kourend & Kebos", Difficulty.HARD),
    KOUREND_ELITE(7928, 11, "Kourend & Kebos", Difficulty.ELITE),
    LUMBRIDGE_EASY(4495, 6, "Lumbridge & Draynor", Difficulty.EASY),
    LUMBRIDGE_MEDIUM(4496, 6, "Lumbridge & Draynor", Difficulty.MEDIUM),
    LUMBRIDGE_HARD(4497, 6, "Lumbridge & Draynor", Difficulty.HARD),
    LUMBRIDGE_ELITE(4498, 6, "Lumbridge & Draynor", Difficulty.ELITE),
    MORYTANIA_EASY(4487, 7, "Morytania", Difficulty.EASY),
    MORYTANIA_MEDIUM(4488, 7, "Morytania", Difficulty.MEDIUM),
    MORYTANIA_HARD(4489, 7, "Morytania", Difficulty.HARD),
    MORYTANIA_ELITE(4490, 7, "Morytania", Difficulty.ELITE),
    VARROCK_EASY(4479, 8, "Varrock", Difficulty.EASY),
    VARROCK_MEDIUM(4480, 8, "Varrock", Difficulty.MEDIUM),
    VARROCK_HARD(4481, 8, "Varrock", Difficulty.HARD),
    VARROCK_ELITE(4482, 8, "Varrock", Difficulty.ELITE),
    WESTERN_EASY(4471, 10, "Western Provinces", Difficulty.EASY),
    WESTERN_MEDIUM(4472, 10, "Western Provinces", Difficulty.MEDIUM),
    WESTERN_HARD(4473, 10, "Western Provinces", Difficulty.HARD),
    WESTERN_ELITE(4474, 10, "Western Provinces", Difficulty.ELITE),
    WILDERNESS_EASY(4466, 9, "Wilderness", Difficulty.EASY),
    WILDERNESS_MEDIUM(4467, 9, "Wilderness", Difficulty.MEDIUM),
    WILDERNESS_HARD(4468, 9, "Wilderness", Difficulty.HARD),
    WILDERNESS_ELITE(4469, 9, "Wilderness", Difficulty.ELITE);

    public static final Map<Integer, AchievementDiary> DIARIES;
    private final int id;
    private final int areaId;
    private final String area;
    private final Difficulty difficulty;

    public int getId() {
        return this.id;
    }

    public int getAreaId() {
        return this.areaId;
    }

    public String getArea() {
        return this.area;
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    private AchievementDiary(int id, int areaId, String area, Difficulty difficulty) {
        this.id = id;
        this.areaId = areaId;
        this.area = area;
        this.difficulty = difficulty;
    }

    static {
        DIARIES = Collections.unmodifiableMap(Arrays.stream(AchievementDiary.values()).collect(Collectors.toMap(AchievementDiary::getId, Function.identity())));
    }

    public static enum Difficulty {
        EASY,
        MEDIUM,
        HARD,
        ELITE;

        private final String displayName = this.name().charAt(0) + this.name().substring(1).toLowerCase();

        public String toString() {
            return this.displayName;
        }
    }
}

