/*
 * Decompiled with CFR 0.152.
 */
package com.chrono.regionlocker;

import com.chrono.ChronoConfig;
import com.chrono.ChronoPlugin;
import com.chrono.regionlocker.RegionTypes;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.util.Text;

public class RegionLocker {
    private final Client client;
    private final ChronoConfig config;
    private final ConfigManager configManager;
    private static Map<String, RegionTypes> regions = new HashMap<String, RegionTypes>();
    private ChronoPlugin chronoPlugin;
    public static boolean renderLockedRegions;
    public static Color grayColor;
    public static int grayAmount;
    public static boolean hardBorder;
    public static boolean invertShader;

    public RegionLocker(Client client, ChronoConfig config, ConfigManager configManager, ChronoPlugin plugin) {
        this.client = client;
        this.config = config;
        this.configManager = configManager;
        this.chronoPlugin = plugin;
        this.readConfig();
    }

    private List<String> StringToList(String s) {
        ArrayList<String> regs = s.isEmpty() ? new ArrayList<String>() : new ArrayList(Text.fromCSV((String)s));
        return regs;
    }

    public void readConfig() {
        renderLockedRegions = this.config.renderLockedRegions();
        grayColor = this.config.shaderGrayColor();
        grayAmount = this.config.shaderGrayAmount().getAlpha();
        hardBorder = this.config.hardBorder();
        regions.clear();
    }

    private void setConfig() {
        ArrayList unlockedRegions = new ArrayList();
        ArrayList unlockableRegions = new ArrayList();
        ArrayList blacklistedRegions = new ArrayList();
        this.chronoPlugin.getCurrentRelease().getRegions().forEach(e -> unlockedRegions.add("" + e));
        String csv = Text.toCSV(unlockedRegions);
        this.configManager.setConfiguration("chrono", "unlockedRegions", csv);
    }

    public void setRegions(List<Integer> regs, RegionTypes type) {
        for (int id : regs) {
            regions.put("" + id, type);
        }
    }

    public void addRegion(int regionId) {
        String id = Integer.toString(regionId);
        RegionTypes type = regions.get(id);
        if (type == null) {
            regions.put(id, RegionTypes.UNLOCKABLE);
        } else if (type == RegionTypes.UNLOCKABLE) {
            regions.put(id, RegionTypes.UNLOCKED);
        } else {
            regions.remove(id);
        }
        this.setConfig();
    }

    public static RegionTypes getType(int regionId) {
        String id = Integer.toString(regionId);
        int y = RegionLocker.getY(regionId);
        if (y >= 4160 && y < 5952) {
            return RegionTypes.UNLOCKED;
        }
        if (y >= 8960) {
            return RegionTypes.UNLOCKED;
        }
        if (regions == null) {
            return null;
        }
        return regions.get(id);
    }

    public static boolean hasRegion(int regionId) {
        RegionTypes type = RegionLocker.getType(regionId);
        if (type == null) {
            return false;
        }
        return type == RegionTypes.UNLOCKED;
    }

    public static boolean isUnlockable(int regionId) {
        RegionTypes type = RegionLocker.getType(regionId);
        if (type == null) {
            return false;
        }
        return type == RegionTypes.UNLOCKABLE;
    }

    public static boolean isBlacklisted(int regionId) {
        RegionTypes type = RegionLocker.getType(regionId);
        if (type == null) {
            return false;
        }
        return type == RegionTypes.BLACKLISTED;
    }

    public static int getX(int id) {
        return id >> 8 << 6;
    }

    public static int getY(int id) {
        return (id & 0xFF) << 6;
    }

    public static Map<String, RegionTypes> getRegions() {
        return regions;
    }
}

