/*
 * Decompiled with CFR 0.152.
 */
package com.chrono.regionlocker;

import com.chrono.ChronoConfig;
import com.google.inject.Inject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

public class RegionBorderOverlay
extends Overlay {
    private static final int LOCAL_TILE_SIZE = 128;
    private static final int CHUNK_SIZE = 8;
    private static final int MAP_SQUARE_SIZE = 64;
    private static final int CULL_CHUNK_BORDERS_RANGE = 16;
    private final Client client;
    private final ChronoConfig config;

    @Inject
    private RegionBorderOverlay(Client client, ChronoConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGH);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.renderRegionBorders()) {
            this.renderMapSquares(graphics);
        }
        return null;
    }

    private void renderMapSquares(Graphics2D graphics) {
        Point p;
        boolean first;
        LocalPoint lp2;
        LocalPoint lp1;
        WorldPoint wp = this.client.getLocalPlayer().getWorldLocation();
        int startX = (wp.getX() - 16 + 64 - 1) / 64 * 64;
        int startY = (wp.getY() - 16 + 64 - 1) / 64 * 64;
        int endX = (wp.getX() + 16) / 64 * 64;
        int endY = (wp.getY() + 16) / 64 * 64;
        graphics.setStroke(new BasicStroke(this.config.regionBorderWidth()));
        Color c = this.config.regionBorderColor();
        graphics.setColor(c);
        GeneralPath path = new GeneralPath();
        for (int x = startX; x <= endX; x += 64) {
            lp1 = LocalPoint.fromWorld((Client)this.client, (int)x, (int)(wp.getY() - 16));
            lp2 = LocalPoint.fromWorld((Client)this.client, (int)x, (int)(wp.getY() + 16));
            first = true;
            for (int y = lp1.getY(); y <= lp2.getY(); y += 128) {
                p = Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(lp1.getX() - 64, y - 64), (int)this.client.getPlane());
                if (p == null) continue;
                if (first) {
                    path.moveTo(p.getX(), p.getY());
                    first = false;
                    continue;
                }
                path.lineTo(p.getX(), p.getY());
            }
        }
        for (int y = startY; y <= endY; y += 64) {
            lp1 = LocalPoint.fromWorld((Client)this.client, (int)(wp.getX() - 16), (int)y);
            lp2 = LocalPoint.fromWorld((Client)this.client, (int)(wp.getX() + 16), (int)y);
            first = true;
            for (int x = lp1.getX(); x <= lp2.getX(); x += 128) {
                p = Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(x - 64, lp1.getY() - 64), (int)this.client.getPlane());
                if (p == null) continue;
                if (first) {
                    path.moveTo(p.getX(), p.getY());
                    first = false;
                    continue;
                }
                path.lineTo(p.getX(), p.getY());
            }
        }
        graphics.draw(path);
    }
}

