/*
 * Decompiled with CFR 0.152.
 */
package com.chrono;

import com.chrono.ChronoSpell;
import com.chrono.ReleaseDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.runelite.api.Prayer;
import net.runelite.api.Quest;
import net.runelite.api.Skill;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Release {
    private static final Logger log = LoggerFactory.getLogger(Release.class);
    private static List<Release> RELEASES = new ArrayList<Release>();
    private ReleaseDate date;
    private List<Integer> regions;
    private List<Skill> skills;
    private List<Prayer> prayers;
    private List<Quest> quests;
    private List<ChronoSpell> spells;
    private String description;

    public Release(ReleaseDate date, List<Integer> regions, List<Skill> skills, List<Prayer> prayers, List<Quest> quests, List<ChronoSpell> spells, String description) {
        this.date = date;
        this.skills = skills;
        this.regions = regions;
        this.prayers = prayers;
        this.quests = quests;
        this.spells = spells;
        this.description = description;
    }

    public static void setReleases(Release[] releases) {
        RELEASES = Arrays.asList(releases);
    }

    public static Release getReleaseByDate(ReleaseDate date) {
        for (Release r : RELEASES) {
            if (!r.getDate().equals((Object)date)) continue;
            return r;
        }
        return null;
    }

    public static List<Skill> getSkills(Release release) {
        ArrayList<Skill> skills = new ArrayList<Skill>();
        for (Release r : RELEASES) {
            if (r.skills != null) {
                skills.addAll(r.getSkills());
            }
            if (!r.equals(release)) continue;
            break;
        }
        return skills;
    }

    public static List<Prayer> getPrayers(Release release) {
        ArrayList<Prayer> prayers = new ArrayList<Prayer>();
        for (Release r : RELEASES) {
            if (r.prayers != null) {
                prayers.addAll(r.getPrayers());
            }
            if (!r.equals(release)) continue;
            break;
        }
        return prayers;
    }

    public static List<Quest> getQuests(Release release) {
        ArrayList<Quest> quests = new ArrayList<Quest>();
        for (Release r : RELEASES) {
            if (r.quests != null) {
                quests.addAll(r.getQuests());
            }
            if (!r.equals(release)) continue;
            break;
        }
        return quests;
    }

    public static List<ChronoSpell> getSpells(Release release) {
        ArrayList<ChronoSpell> spells = new ArrayList<ChronoSpell>();
        for (Release r : RELEASES) {
            if (r.spells != null) {
                spells.addAll(r.getSpells());
            }
            if (!r.equals(release)) continue;
            break;
        }
        return spells;
    }

    public static List<Release> getRELEASES() {
        return RELEASES;
    }

    public ReleaseDate getDate() {
        return this.date;
    }

    public List<Integer> getRegions() {
        return this.regions;
    }

    public List<Skill> getSkills() {
        return this.skills;
    }

    public List<Prayer> getPrayers() {
        return this.prayers;
    }

    public List<Quest> getQuests() {
        return this.quests;
    }

    public List<ChronoSpell> getSpells() {
        return this.spells;
    }

    public String getDescription() {
        return this.description;
    }
}

