/*
 * Decompiled with CFR 0.152.
 */
package com.chrono;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityDefinition {
    private static final Logger log = LoggerFactory.getLogger(EntityDefinition.class);
    private int id;
    private String name;
    private String releaseDate;
    private String lastUpdated;
    static Map<Integer, EntityDefinition> itemDefinitions;
    static Map<Integer, EntityDefinition> monsterDefinition;

    public static boolean isItemUnlocked(int itemId, Date release) throws ParseException {
        EntityDefinition def = itemDefinitions.get(itemId);
        if (def == null) {
            return false;
        }
        Date releaseDate = new SimpleDateFormat("yyyy-MM-dd").parse(def.getReleaseDate());
        return releaseDate.before(release);
    }

    public static boolean isMonsterUnlocked(int npcId, Date release) throws ParseException {
        EntityDefinition def = monsterDefinition.get(npcId);
        if (def == null) {
            return true;
        }
        Date releaseDate = new SimpleDateFormat("yyyy-MM-dd").parse(def.getReleaseDate());
        return releaseDate.before(release);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }
}

