/*
 * Decompiled with CFR 0.152.
 */
package com.chrono;

import com.chrono.ChronoConfig;
import com.chrono.ChronoItemOverlay;
import com.chrono.ChronoPrayer;
import com.chrono.ChronoSkill;
import com.chrono.ChronoSpell;
import com.chrono.EntityDefinition;
import com.chrono.Release;
import com.chrono.ReleaseDate;
import com.chrono.regionlocker.RegionBorderOverlay;
import com.chrono.regionlocker.RegionLocker;
import com.chrono.regionlocker.RegionLockerOverlay;
import com.chrono.regionlocker.RegionTypes;
import com.chrono.ui.UIButton;
import com.chrono.ui.UILabel;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import java.awt.Color;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.Prayer;
import net.runelite.api.Quest;
import net.runelite.api.QuestState;
import net.runelite.api.Renderable;
import net.runelite.api.Skill;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.callback.Hooks;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Chrono", description="Travel back in time", tags={"time traveler", "by release"}, conflicts={"Region Locker"})
public class ChronoPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ChronoPlugin.class);
    public static final String CONFIG_GROUP_KEY = "chrono";
    public static final String CONFIG_RELEASE_DATE_KEY = "releasedate";
    private static final int SOUND_EFFECT_FAIL = 2277;
    private static final int SOUND_EFFECT_INACTIVE = 2673;
    private static final List<String> MENU_BLACKLIST = Arrays.asList("Use", "Take", "Wield", "Empty", "Eat", "Wear", "Read", "Check", "Teleport", "Commune", "Drink", "Bury");
    private static final int PRAYER_TAB = 35454979;
    private static final int PRAYER_ORB = 0xA00011;
    private static final int QUICK_PRAYER = 10485779;
    private static final List<Integer> PRAYER_VARBITS = Arrays.asList(4116);
    @Inject
    private Client client;
    @Inject
    private ChronoConfig config;
    @Inject
    private RegionLockerOverlay regionLockerOverlay;
    @Inject
    private RegionBorderOverlay regionBorderOverlay;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ChronoItemOverlay itemOverlay;
    @Inject
    private Gson gson;
    @Inject
    private Hooks hooks;
    private Release currentRelease;
    private int hoveredRegion = -1;
    private RegionLocker regionLocker;
    private Map<String, List<Widget>> skillOverlays;
    private boolean mapEnabled;
    private UILabel prayerLocked;
    private UIButton quickPrayer;
    private final Hooks.RenderableDrawListener drawListener = this::shouldDraw;

    @Provides
    ChronoConfig provideConfig(ConfigManager configManager) {
        return (ChronoConfig)configManager.getConfig(ChronoConfig.class);
    }

    protected void startUp() {
        this.loadDefinitions();
        this.currentRelease = Release.getReleaseByDate(this.config.release());
        this.overlayManager.add((Overlay)this.itemOverlay);
        this.regionLocker = new RegionLocker(this.client, this.config, this.configManager, this);
        this.regionLocker.setRegions(this.currentRelease.getRegions(), RegionTypes.UNLOCKED);
        this.overlayManager.add((Overlay)this.regionLockerOverlay);
        this.overlayManager.add((Overlay)this.regionBorderOverlay);
        this.hooks.registerRenderableDrawListener(this.drawListener);
    }

    protected void shutDown() {
        RegionLocker.renderLockedRegions = false;
        this.overlayManager.remove((Overlay)this.itemOverlay);
        this.overlayManager.remove((Overlay)this.regionLockerOverlay);
        this.overlayManager.remove((Overlay)this.regionBorderOverlay);
        this.hooks.unregisterRenderableDrawListener(this.drawListener);
    }

    private void loadDefinitions() {
        Type defMapType = new TypeToken<Map<Integer, EntityDefinition>>(){}.getType();
        EntityDefinition.itemDefinitions = (Map)this.loadDefinitionResource(defMapType, "items.json");
        EntityDefinition.monsterDefinition = (Map)this.loadDefinitionResource(defMapType, "monsters.json");
        Release.setReleases((Release[])this.loadDefinitionResource((Type)((Object)Release[].class), "releases.json"));
    }

    private <T> T loadDefinitionResource(Type type, String resource) {
        InputStream resourceStream = ChronoPlugin.class.getResourceAsStream(resource);
        assert (resourceStream != null);
        InputStreamReader definitionReader = new InputStreamReader(resourceStream);
        return (T)this.gson.fromJson((Reader)definitionReader, type);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        if (!e.getGroup().equals(CONFIG_GROUP_KEY)) {
            return;
        }
        if (e.getKey().equals(CONFIG_RELEASE_DATE_KEY)) {
            this.currentRelease = Release.getReleaseByDate(this.config.release());
            this.clientThread.invokeLater(() -> this.updatePrayers());
            this.clientThread.invokeLater(() -> this.updateQuests());
            this.clientThread.invokeLater(() -> this.updateSkillOverlays());
            this.clientThread.invokeLater(() -> {
                Widget w = this.client.getWidget(0xDA0000);
                Object[] onLoadListener = w.getOnInvTransmitListener();
                if (onLoadListener == null) {
                    return;
                }
                this.client.runScript(onLoadListener);
            });
            this.regionLocker.readConfig();
            this.regionLocker.setRegions(this.currentRelease.getRegions(), RegionTypes.UNLOCKED);
            this.configManager.setConfiguration(CONFIG_GROUP_KEY, "description", this.currentRelease.getDescription());
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged e) {
        if (e.getGameState().equals((Object)GameState.LOGGED_IN)) {
            // empty if block
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked e) throws ParseException {
        List<ChronoSpell> unlockedSpells;
        List validSpells;
        List<Prayer> unlockedPrayers;
        List prayers;
        if (e.getMenuOption().equals("Activate") && (prayers = Arrays.stream(ChronoPrayer.values()).filter(p -> e.getMenuTarget().contains(p.getName())).collect(Collectors.toList())).size() > 0 && !(unlockedPrayers = Release.getPrayers(this.currentRelease)).contains(((ChronoPrayer)((Object)prayers.get(0))).getPrayer())) {
            e.consume();
            this.client.playSoundEffect(2673);
        }
        if (e.getMenuOption().equals("Cast") && (validSpells = (unlockedSpells = Release.getSpells(this.currentRelease)).stream().filter(s -> e.getMenuTarget().contains(s.getName())).collect(Collectors.toList())).size() == 0) {
            e.consume();
            this.client.playSoundEffect(2673);
        }
        if (MENU_BLACKLIST.contains(e.getMenuOption())) {
            if (e.getItemId() < 0) {
                return;
            }
            if (e.getItemId() == 0 && !e.getMenuTarget().equals("Dwarf Remains")) {
                return;
            }
            int id = e.getItemId();
            if (!this.isItemUnlocked(id)) {
                EntityDefinition def = EntityDefinition.itemDefinitions.get(id);
                if (def == null) {
                    return;
                }
                e.consume();
                String was = def.getName().endsWith("s") ? "were" : "was";
                this.addWarningMessage(def.getName() + " " + was + " released after " + this.config.release().getName() + ".", true);
            }
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded e) {
        if (e.getGroupId() == WidgetInfo.SKILLS_CONTAINER.getGroupId()) {
            this.createLockedSkillOverlays();
        } else if (e.getGroupId() == WidgetInfo.RESIZABLE_VIEWPORT_PRAYER_TAB.getGroupId() || e.getGroupId() == WidgetInfo.FIXED_VIEWPORT_PRAYER_TAB.getGroupId()) {
            this.createPrayerLockWidgets();
            this.updatePrayers();
        } else if (e.getGroupId() == WidgetInfo.QUESTLIST_BOX.getGroupId()) {
            this.updateQuests();
        } else if (e.getGroupId() == 218) {
            this.updateSpells();
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired e) {
        if (e.getScriptId() == 1340) {
            this.clientThread.invokeLater(this::updateQuests);
        } else if (e.getScriptId() == 2610) {
            this.clientThread.invokeLater(this::updateSpells);
        } else if ((e.getScriptId() == 2760 || e.getScriptId() == 461) && this.client.getWidget(35454979) != null) {
            this.updatePrayers();
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged e) {
        if (PRAYER_VARBITS.contains(e.getVarbitId())) {
            this.updatePrayers();
        }
    }

    @VisibleForTesting
    boolean shouldDraw(Renderable renderable, boolean drawingUI) {
        if (renderable instanceof NPC) {
            NPC npc = (NPC)renderable;
            if (npc.getInteracting() == this.client.getLocalPlayer()) {
                return true;
            }
            try {
                return EntityDefinition.isMonsterUnlocked(npc.getId(), this.config.release().getDate());
            }
            catch (ParseException e) {
                e.printStackTrace();
                return true;
            }
        }
        return true;
    }

    private void addWarningMessage(String message, boolean playSound) {
        ChatMessageBuilder chatMessage = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(message).append(ChatColorType.NORMAL);
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage.build()).build());
        this.client.playSoundEffect(2277);
    }

    public boolean isItemUnlocked(int itemId) throws ParseException {
        return EntityDefinition.isItemUnlocked(itemId, this.config.release().getDate());
    }

    private void createLockedSkillOverlays() {
        List<ChronoSkill> skillWidgets = Arrays.asList(ChronoSkill.values());
        this.skillOverlays = new HashMap<String, List<Widget>>();
        skillWidgets.forEach(skill -> this.addSkillOverlay(skill.getSkill(), skill.getWidgetID()));
    }

    private void addSkillOverlay(Skill skill, int widgetID) {
        Widget skillWidget = this.client.getWidget(widgetID);
        if (skillWidget == null) {
            return;
        }
        boolean isUnlocked = Release.getSkills(this.currentRelease).contains(skill);
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        Widget icon = skillWidget.createChild(-1, 5);
        Widget level = skillWidget.createChild(-1, 5);
        level.setSpriteId(176);
        level.setSize(36, 36);
        level.setPos(28, -2);
        level.setOpacity(90);
        level.setHidden(isUnlocked);
        icon.setSpriteId(174);
        icon.setSize(36, 36);
        icon.setPos(-2, -2);
        icon.setOpacity(90);
        icon.setHidden(isUnlocked);
        widgets.add(icon);
        widgets.add(level);
        this.skillOverlays.put(skill.getName(), widgets);
    }

    private void createPrayerLockWidgets() {
        Widget prayerOrb = this.client.getWidget(0xA00011);
        Widget orbWidget = prayerOrb.createChild(-1, 5);
        this.quickPrayer = new UIButton(orbWidget);
        this.quickPrayer.setSize(prayerOrb.getWidth(), prayerOrb.getHeight());
        this.quickPrayer.addAction("Disabled", () -> this.client.playSoundEffect(2277));
        this.quickPrayer.setVisibility(false);
        Widget container = this.client.getWidget(35454976);
        Widget prayerLabel = container.createChild(-1, 4);
        this.prayerLocked = new UILabel(prayerLabel);
        this.prayerLocked.setText("Prayers have not been released yet.");
        this.prayerLocked.setColour(ColorScheme.BRAND_ORANGE.getRGB());
        this.prayerLocked.setSize(150, 75);
        this.prayerLocked.setPosition(ChronoPlugin.getCenterX(container, 150), ChronoPlugin.getCenterY(container, 75));
        this.prayerLocked.setVisibility(false);
    }

    private void updatePrayers() {
        if (this.prayerLocked == null) {
            return;
        }
        if (this.currentRelease.getDate().getDate().before(ReleaseDate.MAY_2001.getDate())) {
            this.client.getWidget(10485779).setHidden(true);
            this.client.getWidget(35454979).setHidden(true);
            this.prayerLocked.setVisibility(true);
            this.quickPrayer.setVisibility(true);
        } else {
            this.client.getWidget(10485779).setHidden(false);
            this.client.getWidget(35454979).setHidden(false);
            this.prayerLocked.setVisibility(false);
            this.quickPrayer.setVisibility(false);
            List<Prayer> unlockedPrayers = Release.getPrayers(this.currentRelease);
            int offset = 4;
            for (ChronoPrayer prayer : ChronoPrayer.values()) {
                Widget parent = this.client.getWidget(prayer.getPackedID() + offset);
                Widget original = parent.getChild(1);
                if (original == null) continue;
                if (unlockedPrayers.contains(prayer.getPrayer())) {
                    original.setSpriteId(prayer.getUnlockedSpriteID());
                } else {
                    original.setSpriteId(prayer.getLockedSpriteID());
                }
                original.revalidate();
            }
        }
    }

    private void updateSpells() {
        Widget parent = this.client.getWidget(14286851);
        if (parent == null) {
            return;
        }
        List<ChronoSpell> unlockedSpells = Release.getSpells(this.currentRelease);
        for (ChronoSpell spell : ChronoSpell.values()) {
            Widget spellWidget;
            if (unlockedSpells.contains((Object)spell) || (spellWidget = this.client.getWidget(spell.getPackedID())) == null) continue;
            spellWidget.setSpriteId(spell.getLockedSpriteID());
        }
    }

    private void updateQuests() {
        Widget parent = this.client.getWidget(26148871);
        if (parent == null) {
            return;
        }
        Widget[] quests = parent.getChildren();
        List<Quest> unlockedQuests = Release.getQuests(this.currentRelease);
        for (Widget questWidget : quests) {
            List validQuests = unlockedQuests.stream().filter(q -> q.getName().contains(questWidget.getText())).collect(Collectors.toList());
            if (validQuests.size() == 0 && questWidget.getFontId() == 494) {
                questWidget.setHasListener(false);
                questWidget.setTextColor(Color.GRAY.getRGB());
                continue;
            }
            if (questWidget.getFontId() != 494 || questWidget.getTextColor() != Color.GRAY.getRGB()) continue;
            questWidget.setHasListener(false);
            int color = ((Quest)validQuests.get(0)).getState(this.client) == QuestState.FINISHED ? Integer.parseInt("dc10d", 16) : Integer.parseInt("ff0000", 16);
            questWidget.setTextColor(color);
        }
    }

    private void updateSkillOverlays() {
        if (this.skillOverlays == null) {
            return;
        }
        List<Skill> unlocked = Release.getSkills(this.currentRelease);
        for (Skill skill : Skill.values()) {
            boolean hide = unlocked.contains(skill);
            List<Widget> overlay = this.skillOverlays.get(skill.getName());
            if (overlay == null || overlay.size() <= 0) continue;
            overlay.forEach(widget -> widget.setHidden(hide));
        }
    }

    public static int getCenterX(Widget window, int width) {
        return window.getWidth() / 2 - width / 2;
    }

    public static int getCenterY(Widget window, int height) {
        return window.getHeight() / 2 - height / 2;
    }

    public ChronoConfig getConfig() {
        return this.config;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public Release getCurrentRelease() {
        return this.currentRelease;
    }

    public int getHoveredRegion() {
        return this.hoveredRegion;
    }

    public void setHoveredRegion(int hoveredRegion) {
        this.hoveredRegion = hoveredRegion;
    }

    public boolean isMapEnabled() {
        return this.mapEnabled;
    }
}

