/*
 * Decompiled with CFR 0.152.
 */
package com.chrono;

import com.chrono.ChronoPlugin;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.text.ParseException;
import javax.inject.Inject;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;

public class ChronoItemOverlay
extends WidgetItemOverlay {
    private final ItemManager itemManager;
    private ChronoPlugin chronoPlugin;
    private final Cache<Long, Image> fillCache;

    @Inject
    private ChronoItemOverlay(ItemManager itemManager, ChronoPlugin plugin) {
        this.itemManager = itemManager;
        this.chronoPlugin = plugin;
        this.showOnEquipment();
        this.showOnInventory();
        this.fillCache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(32L).build();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem widgetItem) {
        Color color = Color.GRAY;
        try {
            if (!this.chronoPlugin.isItemUnlocked(itemId)) {
                Rectangle bounds = widgetItem.getCanvasBounds();
                Image image = this.getFillImage(color, widgetItem.getId(), widgetItem.getQuantity());
                graphics.drawImage(image, (int)bounds.getX(), (int)bounds.getY(), null);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private Image getFillImage(Color color, int itemId, int qty) {
        long key = (long)itemId << 32 | (long)qty;
        Image image = (Image)this.fillCache.getIfPresent((Object)key);
        if (image == null) {
            Color fillColor = ColorUtil.colorWithAlpha((Color)color, (int)150);
            image = ImageUtil.fillImage((BufferedImage)this.itemManager.getImage(itemId, qty, false), (Color)fillColor);
            this.fillCache.put((Object)key, (Object)image);
        }
        return image;
    }

    void invalidateCache() {
        this.fillCache.invalidateAll();
    }
}

